/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.interfacebase;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.base.BindStatus;
import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.BufferFactoryFinder;
import ch.icosys.popjava.core.buffer.BufferXDR;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.codemanager.AppService;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.combox.ComboxAllocate;
import ch.icosys.popjava.core.combox.ComboxConnection;
import ch.icosys.popjava.core.combox.ComboxFactory;
import ch.icosys.popjava.core.combox.ComboxFactoryFinder;
import ch.icosys.popjava.core.dataswaper.POPString;
import ch.icosys.popjava.core.service.deamon.POPJavaDeamonConnector;
import ch.icosys.popjava.core.service.jobmanager.POPJavaAppService;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.serviceadapter.POPAppService;
import ch.icosys.popjava.core.serviceadapter.POPJobManager;
import ch.icosys.popjava.core.serviceadapter.POPJobService;
import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.SystemUtil;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Interface {
    private static final int MIN_REQUEST_ID = 1000;
    private static final int MAX_REQUEST_ID = Integer.MAX_VALUE;
    private int requestID = 1000;
    protected final Broker parentBroker;
    protected ComboxConnection<?> combox;
    protected POPAccessPoint popAccessPoint = new POPAccessPoint();
    protected ObjectDescription od = new ObjectDescription();
    private static final Configuration conf = Configuration.getInstance();

    public Interface(Broker parentBroker) {
        this.parentBroker = parentBroker;
        this.od = new ObjectDescription();
    }

    public Interface(Broker parentBroker, POPAccessPoint accessPoint) throws POPException {
        this.popAccessPoint = accessPoint;
        this.parentBroker = parentBroker;
        this.bind(accessPoint);
    }

    public Interface(Broker parentBroker, POPAccessPoint accessPoint, ObjectDescription od) throws POPException {
        this.popAccessPoint = accessPoint;
        this.parentBroker = parentBroker;
        this.od.merge(od);
        this.bind(accessPoint);
    }

    public boolean serialize(POPBuffer buffer) {
        this.od.serialize(buffer);
        this.popAccessPoint.serialize(buffer);
        int ref = this.addRef();
        buffer.putInt(ref);
        return true;
    }

    public boolean deserialize(POPBuffer buffer) {
        return this.deserialize(null, buffer);
    }

    protected synchronized int getRequestID() {
        this.requestID = (this.requestID + 1) % Integer.MAX_VALUE;
        if (this.requestID < 1000) {
            this.requestID = 1000;
        }
        return this.requestID;
    }

    public boolean deserialize(Combox sourceCombox, POPBuffer buffer) {
        int ref;
        boolean result = true;
        this.od.deserialize(buffer);
        this.popAccessPoint.deserialize(buffer);
        byte[] certificate = this.popAccessPoint.getX509certificate();
        if (certificate != null && certificate.length > 0) {
            SSLUtils.addCertToTempStore(certificate, true);
        }
        if ((ref = buffer.getInt()) > 0) {
            try {
                boolean connected = false;
                if (sourceCombox != null) {
                    if (this.popAccessPoint.hasSameAccessPoint(sourceCombox.getRemoteCaller().getBrokerAP())) {
                        System.out.println("MAYBE WE CAN REUSE CONNECTION " + sourceCombox.getRemoteCaller().getBrokerAP() + " " + this.popAccessPoint);
                        connected = this.reuseCombox(sourceCombox);
                    } else {
                        System.out.println("Cannot reuse connection " + sourceCombox.getRemoteCaller().getBrokerAP() + " " + this.popAccessPoint);
                    }
                } else {
                    System.out.println("No remote AP defined");
                }
                if (!connected) {
                    this.bind(this.popAccessPoint);
                }
            }
            catch (POPException e) {
                result = false;
                LogWriter.writeDebugInfo("[Interface] Deserialize. Cannot bind to " + this.popAccessPoint.toString());
                e.printStackTrace();
            }
            if (result) {
                this.decRef();
            }
        }
        return result;
    }

    private boolean reuseCombox(Combox sourceCombox) {
        int connectionID = sourceCombox.makeBidirectional(this.parentBroker);
        if (connectionID >= 0) {
            this.combox = new ComboxConnection(sourceCombox, connectionID);
            return true;
        }
        return false;
    }

    public POPRemoteCaller getRemote() {
        return this.combox.getRemoteCaller();
    }

    public POPAccessPoint getAccessPoint() {
        return this.popAccessPoint;
    }

    public void setAccessPoint(POPAccessPoint accessPoint) {
        this.popAccessPoint = accessPoint;
    }

    public ObjectDescription getOD() {
        return this.od;
    }

    public void setOd(ObjectDescription od) {
        this.od = od;
    }

    public void release() {
        throw new UnsupportedOperationException();
    }

    public boolean allocate(String objectName) throws POPException {
        this.popAccessPoint = new POPAccessPoint();
        POPAccessPoint[] allocatedAccessPoint = new POPAccessPoint[]{this.popAccessPoint};
        POPAccessPoint remotjob = new POPAccessPoint();
        POPAccessPoint[] remotejobscontact = new POPAccessPoint[]{remotjob};
        boolean canExecLocal = false;
        canExecLocal = Interface.tryLocal(objectName, this.popAccessPoint, this.od);
        if (!canExecLocal) {
            if (!this.od.getHostName().isEmpty()) {
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                throw new POPException(-1, "Could not create " + objectName + " on " + this.od.getHostName());
            }
            boolean allocated = this.allocateThroughJobmanager(objectName, allocatedAccessPoint, remotejobscontact);
            if (!allocated && this.od.getHostName().isEmpty()) {
                LogWriter.printDebug("No url specified for " + objectName + ", fallback to localhost");
                this.od.setHostname("localhost");
                Interface.tryLocal(objectName, this.popAccessPoint, this.od);
            }
        }
        return this.bind(this.popAccessPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateThroughJobmanager(String objectName, POPAccessPoint[] allocatedAccessPoint, POPAccessPoint[] remotejobscontact) {
        int createdCode;
        String platforms = this.od.getPlatform();
        if (platforms.isEmpty()) {
            AppService appCoreService = null;
            appCoreService = PopJava.newActiveConnect(this.parentBroker, POPAppService.class, POPSystem.appServiceAccessPoint);
            POPString popStringPlatorm = new POPString();
            appCoreService.getPlatform(objectName, popStringPlatorm);
            platforms = popStringPlatorm.getValue();
            if (platforms.length() <= 0) {
                throw new POPException(10006, "OBJECT_EXECUTABLE_NOTFOUND");
            }
            this.od.setPlatform(platforms);
        }
        String jobUrl = this.od.getJobUrl();
        POPAccessPoint jobContact = new POPAccessPoint();
        if (jobUrl.length() > 0) {
            jobContact.setAccessString(jobUrl);
        } else {
            jobContact = POPSystem.jobService;
        }
        if (jobContact.isEmpty()) {
            ComboxFactoryFinder finder = ComboxFactoryFinder.getInstance();
            String[] jmProtocols = conf.getJobManagerProtocols();
            for (int i = 0; i < jmProtocols.length; ++i) {
                String protocol = jmProtocols[i];
                ComboxFactory factory = finder.findFactory(protocol);
                if (factory == null) continue;
                jobContact.setAccessString(String.format("%s://%s:%d", factory.getComboxName(), POPSystem.getHostIP(), conf.getJobManagerPorts()[i]));
                break;
            }
        }
        POPJobService jobManager = null;
        try {
            jobManager = conf.isConnectToPOPcpp() ? (POPJobService)PopJava.newActiveConnect(this.parentBroker, POPJobManager.class, jobContact) : (conf.isConnectToJavaJobmanager() ? (POPJobService)PopJava.newActiveConnect(this.parentBroker, POPJavaJobManager.class, jobContact) : PopJava.newActiveConnect(this.parentBroker, POPJobService.class, jobContact));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (jobManager == null) {
            return false;
        }
        try {
            createdCode = jobManager.createObject(POPSystem.appServiceAccessPoint, objectName, this.od, allocatedAccessPoint.length, allocatedAccessPoint, remotejobscontact.length, remotejobscontact);
        }
        catch (Exception e) {
            createdCode = 10010;
            LogWriter.writeDebugInfo("[Interface] Exception while calling job manager: %s", e.getCause());
        }
        finally {
            jobManager.exit();
        }
        if (createdCode != 0) {
            switch (createdCode) {
                case 10010: {
                    throw new POPException(createdCode, "OBJECT_EXECUTABLE_NOTFOUND");
                }
                case 10009: {
                    throw new POPException(createdCode, "NO_RESOURCE_MATCH " + objectName);
                }
            }
            throw new POPException(createdCode, "UNABLE_TO_CREATED_THE_PARALLEL_OBJECT");
        }
        for (int i = 0; i < allocatedAccessPoint.length; ++i) {
            if (allocatedAccessPoint[0].size() < 1 || !allocatedAccessPoint[0].get(0).getHost().equals("127.0.0.1") && !allocatedAccessPoint[0].get(0).getHost().equals("127.0.1.1")) continue;
            allocatedAccessPoint[0].get(0).setHost(remotejobscontact[0].get(0).getHost());
        }
        this.popAccessPoint.setAccessString(allocatedAccessPoint[0].toString());
        return true;
    }

    protected boolean bind(POPAccessPoint accesspoint) throws POPException {
        if (accesspoint == null || accesspoint.isEmpty()) {
            throw POPException.throwAccessPointNotAvailableException(accesspoint);
        }
        ComboxFactoryFinder finder = ComboxFactoryFinder.getInstance();
        if (this.combox != null) {
            this.combox.close();
        }
        for (int i = 0; i < accesspoint.size(); ++i) {
            String protocol = accesspoint.get(i).getProtocol();
            ComboxFactory factory = finder.findFactory(protocol);
            if (factory == null) continue;
            try {
                String networkUUID = this.od.getNetwork();
                if (networkUUID == null || networkUUID.isEmpty()) {
                    networkUUID = conf.getDefaultNetwork();
                }
                this.combox = new ComboxConnection(factory.createClientCombox(networkUUID), 1);
                break;
            }
            catch (IOException e) {
                LogWriter.writeExceptionLog(e);
            }
        }
        if (this.combox != null && this.combox.getCombox().connectToServer(this.parentBroker, accesspoint, conf.getConnectionTimeout())) {
            BindStatus bindStatus = new BindStatus();
            this.bindStatus(bindStatus);
            switch (bindStatus.getCode()) {
                case 0: {
                    this.getOD().setPlatform(bindStatus.getPlatform());
                    this.negotiateEncoding(conf.getSelectedEncoding(), bindStatus.getPlatform());
                    return true;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
        } else {
            POPException.throwObjectBindException(accesspoint);
        }
        return true;
    }

    private void bindStatus(BindStatus bindStatus) throws POPException {
        if (this.combox == null) {
            throw POPException.throwComboxNotAvailableException();
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(0, 0, 1);
        messageHeader.setRequestID(this.getRequestID());
        popBuffer.setHeader(messageHeader);
        this.popDispatch(popBuffer);
        int errorcode = 0;
        POPBuffer responseBuffer = this.combox.getBufferFactory().createBuffer();
        this.popResponse(responseBuffer, messageHeader.getRequestID());
        errorcode = responseBuffer.getInt();
        bindStatus.setCode(errorcode);
        String platform = responseBuffer.getString();
        String info = responseBuffer.getString();
        bindStatus.setPlatform(platform);
        bindStatus.setInfo(info);
    }

    private void negotiateEncoding(String info, String platform) throws POPException {
        if (this.combox == null) {
            throw POPException.throwComboxNotAvailableException();
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(0, 3, 1);
        messageHeader.setRequestID(this.getRequestID());
        popBuffer.setHeader(messageHeader);
        popBuffer.putString(conf.getSelectedEncoding());
        this.popDispatch(popBuffer);
        boolean result = false;
        POPBuffer responseBuffer = this.combox.getBufferFactory().createBuffer();
        this.popResponse(responseBuffer, messageHeader.getRequestID());
        result = responseBuffer.getBoolean();
        if (result) {
            BufferFactory bufferFactory = BufferFactoryFinder.getInstance().findFactory(conf.getSelectedEncoding());
            this.combox.setBufferFactory(bufferFactory);
        }
    }

    public int addRef() {
        if (this.combox == null) {
            return -1;
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(0, 1, 1);
        messageHeader.setRequestID(this.getRequestID());
        popBuffer.setHeader(messageHeader);
        int result = 0;
        try {
            this.popDispatch(popBuffer);
            POPBuffer responseBuffer = this.combox.getBufferFactory().createBuffer();
            this.popResponse(responseBuffer, messageHeader.getRequestID());
            result = responseBuffer.getInt();
        }
        catch (POPException e) {
            return -1;
        }
        return result;
    }

    public int decRef() {
        if (this.combox == null) {
            return -1;
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(0, 2, 1);
        messageHeader.setRequestID(this.getRequestID());
        popBuffer.setHeader(messageHeader);
        int result = 0;
        try {
            this.popDispatch(popBuffer);
            POPBuffer responseBuffer = this.combox.getBufferFactory().createBuffer();
            this.popResponse(responseBuffer, messageHeader.getRequestID());
            result = responseBuffer.getInt();
        }
        catch (POPException e) {
            return -1;
        }
        return result;
    }

    public boolean isAlive() {
        if (this.combox == null) {
            return false;
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(0, 5, 1);
        messageHeader.setRequestID(this.getRequestID());
        popBuffer.setHeader(messageHeader);
        this.popDispatch(popBuffer);
        boolean result = false;
        try {
            POPBuffer responseBuffer = this.combox.getBufferFactory().createBuffer();
            this.popResponse(responseBuffer, messageHeader.getRequestID());
            result = responseBuffer.getBoolean();
        }
        catch (POPException e) {
            return false;
        }
        return result;
    }

    public void kill() {
        if (this.combox == null) {
            return;
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(0, 4, 1);
        messageHeader.setRequestID(this.getRequestID());
        popBuffer.setHeader(messageHeader);
        this.popDispatch(popBuffer);
        try {
            POPBuffer responseBuffer = this.combox.getBufferFactory().createBuffer();
            this.popResponse(responseBuffer, messageHeader.getRequestID());
        }
        catch (POPException pOPException) {
            // empty catch block
        }
    }

    public static boolean tryLocal(String objectName, POPAccessPoint accesspoint, ObjectDescription od) throws POPException {
        int status;
        int nbProtocols;
        String joburl = "";
        String codeFile = "";
        boolean odEmpty = od.isEmpty();
        if (odEmpty) {
            return false;
        }
        joburl = od.getHostName();
        if (joburl == null || joburl.isEmpty()) {
            return false;
        }
        LogWriter.writeDebugInfo("[Interface] Creating %s on %s with %s", objectName, joburl, Arrays.toString(od.getProtocols()));
        codeFile = od.getCodeFile();
        if (!(codeFile != null && codeFile.length() != 0 || (codeFile = Interface.getRemoteCodeFile(objectName)) != null && codeFile.length() != 0)) {
            return false;
        }
        String[] rports = null;
        String[] protocols = null;
        int urlPortIndex = joburl.lastIndexOf(":");
        if (urlPortIndex > 0) {
            rports = new String[]{joburl.substring(urlPortIndex + 1)};
            joburl = joburl.substring(0, urlPortIndex);
        }
        if ((nbProtocols = od.getProtocols().length) == 1 && od.getProtocols()[0].isEmpty()) {
            ComboxFactoryFinder finder = ComboxFactoryFinder.getInstance();
            ComboxFactory[] protocolsFactories = finder.getAvailableFactories();
            int protocolsCount = protocolsFactories.length;
            if (rports != null) {
                protocols = new String[]{conf.getDefaultProtocol()};
            } else {
                protocols = new String[protocolsCount];
                rports = new String[protocolsCount];
                for (int i = 0; i < protocolsCount; ++i) {
                    protocols[i] = protocolsFactories[i].getComboxName();
                    rports[i] = "0";
                }
            }
        } else if (nbProtocols >= 1) {
            boolean setPorts;
            if (rports != null && nbProtocols != rports.length) {
                throw new POPException(10021, "You can't specify a port in the url and have multiple protocols.");
            }
            boolean bl = setPorts = rports == null;
            if (setPorts) {
                rports = new String[nbProtocols];
            }
            protocols = new String[nbProtocols];
            for (int i = 0; i < nbProtocols; ++i) {
                String protocol = od.getProtocols()[i];
                String port = null;
                int portIdx = protocol.lastIndexOf(":");
                if (portIdx > 0) {
                    port = protocol.substring(portIdx + 1);
                    protocol = protocol.substring(0, portIdx);
                }
                if (!setPorts && port != null) {
                    throw new POPException(10021, "You can't specify ports multiple times");
                }
                if (setPorts) {
                    rports[i] = port == null ? "0" : port;
                }
                protocols[i] = protocol;
            }
        } else {
            throw new POPException(10021, "At least one protocol should be specified");
        }
        POPAccessPoint appService = POPSystem.appServiceAccessPoint;
        if (od.getOriginAppService() != null) {
            appService = od.getOriginAppService();
        }
        if ((status = Interface.localExec(joburl, codeFile, objectName, protocols, rports, POPSystem.jobService, appService, accesspoint, od)) != 0) {
            LogWriter.writeDebugInfo("[Interface] Could not create " + objectName + " on " + joburl);
        }
        return status == 0;
    }

    private static String getRemoteCodeFile(String objectName) {
        if (objectName.equals(POPAppService.class.getName()) || objectName.equals(POPJavaAppService.class.getName())) {
            return Interface.getPOPCodeFile();
        }
        AppService appCoreService = Interface.getAppcoreService();
        if (appCoreService != null) {
            return Interface.getCodeFile(appCoreService, objectName);
        }
        return Interface.getPOPCodeFile();
    }

    public static AppService getAppcoreService() {
        AppService appCoreService = null;
        if (!POPSystem.appServiceAccessPoint.isEmpty()) {
            if (conf.isConnectToPOPcpp()) {
                try {
                    POPAppService tempService = PopJava.newActiveConnect(null, POPAppService.class, POPSystem.appServiceAccessPoint);
                    tempService.unregisterService("");
                    appCoreService = tempService;
                }
                catch (Exception e) {
                    LogWriter.writeDebugInfo("[Interface] Running app service is not from POP-C++, fall back to POP-Java");
                    appCoreService = null;
                }
            }
            if (appCoreService == null) {
                try {
                    appCoreService = PopJava.newActiveConnect(null, POPJavaAppService.class, POPSystem.appServiceAccessPoint);
                }
                catch (POPException e) {
                    LogWriter.writeDebugInfo("[Interface] Could not contact Appservice to recover code file");
                }
            }
        } else {
            System.err.println("POPSystem.appServiceAccessPoint was empty");
        }
        return appCoreService;
    }

    private static String getPOPCodeFile() {
        String popPath = POPJavaConfiguration.getClassPath();
        String popJar = POPJavaConfiguration.getPopJavaJar();
        return String.format(POPJavaConfiguration.getBrokerCommand(), popJar, popPath);
    }

    public static String getCodeFile(AppService manager, String objectName) {
        if (manager == null) {
            throw new NullPointerException("AppService can not be null");
        }
        POPString popStringCodeFile = new POPString();
        manager.queryCode(objectName, POPSystem.getPlatform(), popStringCodeFile);
        String codeFile = popStringCodeFile.getValue();
        if (codeFile == null || codeFile.isEmpty()) {
            popStringCodeFile = new POPString();
            manager.queryCode("*", "*-*", popStringCodeFile);
            codeFile = popStringCodeFile.getValue();
        }
        if (codeFile == null || codeFile.isEmpty()) {
            codeFile = Util.getLocalJavaFileLocation(objectName);
        }
        return codeFile;
    }

    private static int localExec(String hostname, String codeFile, String classname, String[] protocols, String[] rports, POPAccessPoint jobserv, POPAccessPoint appserv, POPAccessPoint objaccess, ObjectDescription od) {
        String networkUUID;
        assert (protocols.length == rports.length);
        boolean isLocal = Util.isLocal(hostname);
        if (codeFile == null || codeFile.length() == 0) {
            return -1;
        }
        codeFile = codeFile.trim();
        ArrayList<String> codeList = Util.splitTheCommand(codeFile);
        ArrayList<String> argvList = new ArrayList<String>(codeList);
        if (codeFile.startsWith("java")) {
            argvList.add(1, "--add-opens=java.base/java.lang=ALL-UNNAMED");
            argvList.add(1, "-XX:+IgnoreUnrecognizedVMOptions");
            if (conf.isActivateJmx()) {
                argvList.add(1, "-Dcom.sun.management.jmxremote.port=" + (int)(Math.random() * 1000.0 + 3000.0));
                argvList.add(1, "-Dcom.sun.management.jmxremote.ssl=false");
                argvList.add(1, "-Dcom.sun.management.jmxremote.authenticate=false");
            }
        }
        if (od.getJVMParameters() != null && !od.getJVMParameters().isEmpty()) {
            String[] jvmParameters = od.getJVMParameters().split(" ");
            for (String parameter : jvmParameters) {
                argvList.add(1, parameter);
            }
        }
        ComboxAllocate allocateCombox = null;
        for (String protocol : protocols) {
            ComboxFactory factory = ComboxFactoryFinder.getInstance().findFactory(protocol);
            if (factory == null || !factory.isAvailable()) continue;
            try {
                allocateCombox = factory.createAllocateCombox(false);
                break;
            }
            catch (IOException e) {
                LogWriter.writeExceptionLog(e);
            }
        }
        if (allocateCombox == null) {
            return -1;
        }
        String callbackString = "-callback=" + allocateCombox.getUrl();
        argvList.add(callbackString);
        if (classname != null && classname.length() > 0) {
            String objectString = "-object=" + classname;
            argvList.add(objectString);
        }
        if (appserv != null && !appserv.isEmpty()) {
            String appString = "-appservice=" + appserv.toString();
            argvList.add(appString);
        }
        if (jobserv != null && !jobserv.isEmpty()) {
            String jobString = "-jobservice=" + jobserv.toString();
            argvList.add(jobString);
        }
        if (od.isTracking()) {
            argvList.add("-tracking");
        }
        if (od.isUPNPEnabled()) {
            argvList.add("-upnp");
        }
        if ((networkUUID = od.getNetwork()) == null || networkUUID.isEmpty()) {
            networkUUID = conf.getDefaultNetwork();
        }
        String networkArg = "-network=" + networkUUID;
        argvList.add(networkArg);
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            String port = rports[i];
            ComboxFactory wantedProtocol = ComboxFactoryFinder.getInstance().findFactory(protocol);
            if (wantedProtocol != null) {
                String portString = String.format("-%s_port=%s", wantedProtocol.getComboxName(), port);
                argvList.add(portString);
                continue;
            }
            LogWriter.writeDebugInfo("[Interface] specified protocol '%s' can't be found.", protocol);
        }
        int ret = -1;
        if (hostname.equals("localhost-debug")) {
            hostname = "localhost";
        }
        String potentialServicePort = od.getValue("_service-port");
        if (isLocal && potentialServicePort.isEmpty()) {
            if (conf.isUsingUserConfig()) {
                argvList.add("-configfile=" + conf.getUserConfig().toString());
            }
            ret = SystemUtil.runCmd(argvList, od.getDirectory(), od.getHostuser());
        } else {
            switch (od.getConnectionType()) {
                case ANY: 
                case SSH: {
                    if (!potentialServicePort.isEmpty()) {
                        ret = SystemUtil.runRemoteCmd(hostname, potentialServicePort, argvList);
                        break;
                    }
                    ret = SystemUtil.runRemoteCmd(hostname, argvList);
                    break;
                }
                case DAEMON: {
                    try {
                        POPJavaDeamonConnector connector = potentialServicePort.equals("") ? new POPJavaDeamonConnector(hostname) : new POPJavaDeamonConnector(hostname, Integer.parseInt(potentialServicePort));
                        if (!connector.sendCommand(od.getConnectionSecret(), argvList)) break;
                        ret = 0;
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (ret == -1) {
            return ret;
        }
        allocateCombox.startToAcceptOneConnection();
        if (!allocateCombox.isComboxConnected()) {
            LogWriter.writeDebugInfo("[Interface] Could not connect broker");
            return -1;
        }
        BufferXDR buffer = new BufferXDR();
        int result = 0;
        if (allocateCombox.receive(buffer, 0) > 0) {
            int status = buffer.getInt();
            String str = buffer.getString();
            if (status == 0) {
                objaccess.setAccessString(str);
            } else {
                result = status;
            }
        } else {
            result = -1;
        }
        allocateCombox.close(0);
        return result;
    }

    protected void popDispatch(POPBuffer buffer) {
        int length = this.combox.send(buffer);
        if (length < 0) {
            throw new POPException(10017, "Connection closed remotely while sending");
        }
    }

    protected int popResponse(POPBuffer buffer, int requestId) throws POPException {
        if (this.combox.receive(buffer, requestId) > 0) {
            MessageHeader messageHeader = buffer.getHeader();
            if (messageHeader.getRequestType() == 2) {
                int errorCode = messageHeader.getExceptionCode();
                POPBuffer.checkAndThrow(errorCode, buffer);
            }
        } else {
            throw new POPException(10017, "Connection closed remotely while receiving " + this.combox.getCombox());
        }
        return 0;
    }

    public void close() {
        if (this.combox != null) {
            this.combox.close();
        }
        this.combox = null;
    }

    protected void finalize() throws Throwable {
        this.decRef();
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

