/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.mapgen;

import ch.icosys.popjava.core.mapgen.ClassReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JARReader {
    private String file;

    public JARReader(String file) {
        this.file = file;
    }

    public ArrayList<String> getParclassFromJar() throws IOException, ClassNotFoundException {
        ArrayList<String> parclasses = new ArrayList<String>();
        JarFile jf = new JarFile(this.file);
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            String className = je.getName();
            if (!className.endsWith(".class")) continue;
            className = className.substring(0, className.indexOf("."));
            className = className.replace("/", ".");
            URLClassLoader loader = URLClassLoader.newInstance(new URL[]{new URL("file://" + this.file)}, this.getClass().getClassLoader());
            try {
                Class<?> c = Class.forName(className, true, loader);
                if (!ClassReader.isParclass(c)) continue;
                parclasses.add(className);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        jf.close();
        return parclasses;
    }
}

