/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.mapgen;

import ch.icosys.popjava.core.mapgen.ConfigurationWorker;
import ch.icosys.popjava.core.mapgen.XMLWorker;
import java.io.File;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectMapWriter
extends XMLWorker {
    private String xmlFile;
    private boolean append;
    private Document objmap;

    public ObjectMapWriter(String xmlFile, boolean append) throws Exception {
        this.xmlFile = xmlFile;
        this.append = append;
        File f = null;
        if (xmlFile != null) {
            f = new File(xmlFile);
        }
        if (f == null || !f.exists()) {
            append = false;
            this.objmap = this.create();
            Element codeInfoList = this.objmap.createElement("CodeInfoList");
            this.objmap.appendChild(codeInfoList);
        } else {
            ConfigurationWorker cw = new ConfigurationWorker();
            String popjLocation = cw.getValue("popj_location");
            if (this.isValid(xmlFile, popjLocation + "/etc/objectmap.xsd")) {
                this.objmap = this.load(xmlFile);
            } else {
                throw new Exception("The input object map is not valid");
            }
        }
    }

    public void writePOPJavaEntries(ArrayList<String> parclasses, String path) throws Exception {
        for (int i = 0; i < parclasses.size(); ++i) {
            this.writePOPJavaEntry(parclasses.get(i), path);
        }
    }

    public void writePOPJavaEntry(String parclass, String path) {
        this.deleteEntry(parclass);
        Node codeInfoList = this.objmap.getFirstChild();
        Element objectName = this.objmap.createElement("ObjectName");
        objectName.setTextContent(parclass);
        Element codeFile = this.objmap.createElement("CodeFile");
        codeFile.setTextContent(path);
        codeFile.setAttribute("Type", "popjava");
        Element platform = this.objmap.createElement("PlatForm");
        platform.setTextContent("*-*");
        Element codeInfo = this.objmap.createElement("CodeInfo");
        codeInfo.appendChild(objectName);
        codeInfo.appendChild(codeFile);
        codeInfo.appendChild(platform);
        codeInfoList.appendChild(codeInfo);
    }

    public void writePOPCPPEntry(String parclass, String path, String arch) {
        this.deleteEntry(parclass);
        Node codeInfoList = this.objmap.getFirstChild();
        Element objectName = this.objmap.createElement("ObjectName");
        objectName.setTextContent(parclass);
        Element codeFile = this.objmap.createElement("CodeFile");
        codeFile.setTextContent(path);
        Element platform = this.objmap.createElement("PlatForm");
        platform.setTextContent(arch);
        Element codeInfo = this.objmap.createElement("CodeInfo");
        codeInfo.appendChild(objectName);
        codeInfo.appendChild(codeFile);
        codeInfo.appendChild(platform);
        codeInfoList.appendChild(codeInfo);
    }

    public void writeToFile() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(this.objmap);
        StreamResult result = new StreamResult(new File(this.xmlFile));
        transformer.transform(source, result);
    }

    public void writeToConsole() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(this.objmap);
        StreamResult result = new StreamResult(System.out);
        transformer.transform(source, result);
    }

    private void deleteEntry(String parclass) {
        Node codeInfoList = this.objmap.getFirstChild();
        NodeList codeInfos = codeInfoList.getChildNodes();
        block0: for (int i = 0; i < codeInfos.getLength(); ++i) {
            Node codeInfo = codeInfos.item(i);
            NodeList elements = codeInfo.getChildNodes();
            for (int j = 0; j < elements.getLength(); ++j) {
                Node element = elements.item(j);
                if (!element.getNodeName().equals("ObjectName") || !element.getTextContent().equals(parclass)) continue;
                while (codeInfo.hasChildNodes()) {
                    codeInfo.removeChild(codeInfo.getFirstChild());
                }
                codeInfo.getParentNode().removeChild(codeInfo);
                this.objmap.normalize();
                continue block0;
            }
        }
    }
}

