/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts.shell;

import ch.icosys.popjava.core.scripts.POPJShell;
import ch.icosys.popjava.core.scripts.shell.CommandInfo;
import ch.icosys.popjava.core.scripts.shell.ICommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CommandHandler {
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();

    public int execute(CommandInfo ci) {
        ICommand command = this.commands.get(ci.getKeyword());
        if (command == null) {
            POPJShell.optionNotFound(ci.getKeyword(), this.help());
            return 1;
        }
        if (ci.isNextHelp()) {
            System.out.println(command.help());
            return 0;
        }
        return command.execute(ci);
    }

    public void add(ICommand command) {
        this.commands.put(command.keyword(), command);
    }

    public String help() {
        Collection<ICommand> comm = this.commands.values();
        StringBuilder sb = new StringBuilder();
        sb.append("Available options:\n");
        for (ICommand com : comm) {
            sb.append(String.format("  %-20s  %s\n", com.keyword(), com.description()));
        }
        return sb.toString();
    }
}

