/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.deamon;

import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.SystemUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Key;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class POPJavaDeamon
implements Runnable,
Closeable {
    public static final String SUCCESS = "OK";
    private ServerSocket serverSocket;
    private int port;
    private String password = "";
    private static final String BACKUP_JAR = "build/popjava.jar";
    public static final String ERROR_PWD = "ERROR PASS";

    private static byte[] getIV(String salt, int size) {
        byte[] iv = new byte[size];
        Random rand = new Random(salt.hashCode());
        for (int i = 0; i < size; ++i) {
            iv[i] = (byte)rand.nextFloat();
        }
        return iv;
    }

    public static Cipher createKey(String salt, String password, boolean encrypt) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, Math.min(Cipher.getMaxAllowedKeyLength("AES"), 256));
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            IvParameterSpec paramSpec = new IvParameterSpec(POPJavaDeamon.getIV(salt, 16));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(encrypt ? 1 : 2, (Key)secret, paramSpec);
            return cipher;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public POPJavaDeamon(String password) {
        this(password, Configuration.getInstance().getPopJavaDaemonPort());
    }

    public POPJavaDeamon(String password, int port) {
        this.password = password;
        this.port = port;
    }

    public static boolean isClasspathValid(String classPath) {
        String[] parts;
        for (String part : parts = classPath.split(File.pathSeparator)) {
            if (!new File(part).exists() && !part.startsWith("http://")) continue;
            return true;
        }
        return false;
    }

    public static void main(String ... args) throws IOException {
        POPJavaDeamon deamon = new POPJavaDeamon("test");
        deamon.start();
    }

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        ExecutorService executor = Executors.newCachedThreadPool();
        System.out.println("Started POP-Java daemon");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Socket socket = this.serverSocket.accept();
                System.out.println("Accepted connection");
                executor.execute(new Acceptor(socket));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        System.out.println("Closed POP-Java daemon");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }

    public static String getSaltedHash(String salt, String secret) {
        return "" + (secret + salt).hashCode();
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class Acceptor
    implements Runnable {
        private final Socket socket;
        private final Random rand = new Random();
        private static final int SALT_LENGTH = 10;

        public Acceptor(Socket socket) {
            this.socket = socket;
        }

        private String createSecret() {
            StringBuilder secret = new StringBuilder();
            for (int i = 0; i < 10; ++i) {
                secret.append((char)(this.rand.nextInt(26) + 97));
            }
            return secret.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String salt = this.createSecret();
                writer.write(salt + "\n");
                writer.flush();
                System.out.println("Execute command: ");
                String saltedHash = POPJavaDeamon.getSaltedHash(salt, POPJavaDeamon.this.password);
                String challengeAnswer = reader.readLine();
                if (!saltedHash.equals(challengeAnswer)) {
                    System.err.println("The supplied secret was wrong : " + challengeAnswer + " should be " + saltedHash + " using password " + POPJavaDeamon.this.password);
                    writer.write("ERROR PASS\n");
                    writer.close();
                    reader.close();
                    return;
                }
                writer.write("SUCCESS\n");
                writer.flush();
                System.out.println("Correct login");
                writer = new BufferedWriter(new OutputStreamWriter(new CipherOutputStream(this.socket.getOutputStream(), POPJavaDeamon.createKey(salt, POPJavaDeamon.this.password, true))));
                reader = new BufferedReader(new InputStreamReader(new CipherInputStream(this.socket.getInputStream(), POPJavaDeamon.createKey(salt, POPJavaDeamon.this.password, false))));
                int commandLength = Integer.parseInt(reader.readLine());
                ArrayList<String> commands = new ArrayList<String>();
                System.out.println("Get commands " + commandLength);
                boolean isJava = false;
                boolean isClassPath = false;
                for (int i = 0; i < commandLength; ++i) {
                    String temp;
                    String line = reader.readLine();
                    if (isJava && isClassPath && !POPJavaDeamon.isClasspathValid(line) && (temp = POPJavaConfiguration.getClassPath()) != null && !temp.isEmpty()) {
                        line = temp;
                    }
                    if (line.startsWith("-javaagent:")) {
                        String popJavaJar = POPJavaConfiguration.getPOPJavaCodePath();
                        if (!POPJavaConfiguration.isJar()) {
                            popJavaJar = POPJavaDeamon.BACKUP_JAR;
                        }
                        line = "-javaagent:" + popJavaJar;
                    }
                    commands.add(line);
                    System.out.print(line + " ");
                    if (i == 0 && line.equals("java")) {
                        isJava = true;
                    }
                    isClassPath = line.equals("-cp");
                }
                System.out.println();
                System.out.println("Launching object");
                if (isJava) {
                    SystemUtil.runCmd(commands);
                    writer.write("OK\n");
                } else {
                    writer.write("ERROR NOT JAVA\n");
                }
                System.out.println("Finished daemon stuff");
                writer.close();
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

