/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager;

import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlResource;

public class Resource
implements IPOPBase {
    protected float flops;
    protected float memory;
    protected float bandwidth;

    public Resource() {
    }

    public Resource(float flops, float memory, float bandwidth) {
        this.flops = flops;
        this.memory = memory;
        this.bandwidth = bandwidth;
    }

    Resource(Resource r) {
        this(r.flops, r.memory, r.bandwidth);
    }

    public void add(Resource r) {
        this.flops += r.flops;
        this.memory += r.memory;
        this.bandwidth += r.bandwidth;
    }

    public void addTo(ObjectDescription od) {
        od.setBandwidth(this.bandwidth, this.bandwidth);
        od.setPower(this.flops, this.flops);
        od.setMemory(this.memory, this.memory);
    }

    public void subtract(Resource r) {
        this.flops -= r.flops;
        this.memory -= r.memory;
        this.bandwidth -= r.bandwidth;
    }

    public float getFlops() {
        return this.flops;
    }

    public float getMemory() {
        return this.memory;
    }

    public float getBandwidth() {
        return this.bandwidth;
    }

    public void setFlops(float flops) {
        this.flops = flops;
    }

    public void setMemory(float memory) {
        this.memory = memory;
    }

    public void setBandwidth(float bandwidth) {
        this.bandwidth = bandwidth;
    }

    public boolean canHandle(Resource resource) {
        boolean canHandle = true;
        canHandle &= this.flops >= resource.flops;
        canHandle &= this.memory >= resource.memory;
        return canHandle &= this.bandwidth >= resource.bandwidth;
    }

    public YamlResource toYamlResource() {
        YamlResource res = new YamlResource();
        res.setFlops(this.flops);
        res.setBandwidth(this.bandwidth);
        res.setMemory(this.memory);
        return res;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Float.floatToIntBits(this.flops);
        hash = 59 * hash + Float.floatToIntBits(this.memory);
        hash = 59 * hash + Float.floatToIntBits(this.bandwidth);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (Float.floatToIntBits(this.flops) != Float.floatToIntBits(other.flops)) {
            return false;
        }
        if (Float.floatToIntBits(this.memory) != Float.floatToIntBits(other.memory)) {
            return false;
        }
        return Float.floatToIntBits(this.bandwidth) == Float.floatToIntBits(other.bandwidth);
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putFloat(this.flops);
        buffer.putFloat(this.memory);
        buffer.putFloat(this.bandwidth);
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.flops = buffer.getFloat();
        this.memory = buffer.getFloat();
        this.bandwidth = buffer.getFloat();
        return true;
    }

    public String toString() {
        return String.format("power=%f memory=%f bandwidth=%f", Float.valueOf(this.flops), Float.valueOf(this.memory), Float.valueOf(this.bandwidth));
    }
}

