/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetwork;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class POPConnector {
    protected POPNetwork network;
    protected POPJavaJobManager jobManager;
    protected final POPNetworkDescriptor descriptor;
    protected final List<POPNode> nodes = new ArrayList<POPNode>();

    public POPConnector(POPNetworkDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public abstract int createObject(POPAccessPoint var1, String var2, ObjectDescription var3, int var4, POPAccessPoint[] var5, int var6, POPAccessPoint[] var7);

    public POPNetworkDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    boolean addNode(POPNode node) {
        return node.getConnectorDescriptor() == this.descriptor && this.nodes.contains(node) || this.nodes.add(node);
    }

    boolean removeNode(POPNode node) {
        return this.nodes.remove(node);
    }

    public int size() {
        return this.nodes.size();
    }

    List<POPNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    void setNetwork(POPNetwork network) {
        this.network = network;
    }

    void setJobManager(POPJavaJobManager jobManager) {
        this.jobManager = jobManager;
    }

    YamlConnector toYamlResource() {
        YamlConnector yamlConnector = new YamlConnector();
        yamlConnector.setType(this.descriptor.getGlobalName());
        ArrayList<Map<String, Object>> nodesParams = new ArrayList<Map<String, Object>>(this.nodes.size());
        yamlConnector.setNodes(nodesParams);
        for (POPNode node : this.nodes) {
            nodesParams.add(node.toYamlResource());
        }
        return yamlConnector;
    }
}

