/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.dataswaper.POPMutableFloat;
import ch.icosys.popjava.core.dataswaper.POPString;
import ch.icosys.popjava.core.interfacebase.Interface;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.Resource;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnector;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorSearchNodeInterface;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptorMethod;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeJobManager;
import ch.icosys.popjava.core.service.jobmanager.search.SNExploration;
import ch.icosys.popjava.core.service.jobmanager.search.SNNodesInfo;
import ch.icosys.popjava.core.service.jobmanager.search.SNRequest;
import ch.icosys.popjava.core.service.jobmanager.search.SNResponse;
import ch.icosys.popjava.core.service.jobmanager.search.SNWayback;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.security.cert.Certificate;
import java.util.List;

public class POPConnectorJobManager
extends POPConnector
implements POPConnectorSearchNodeInterface {
    static final POPNetworkDescriptor DESCRIPTOR = new POPNetworkDescriptor("jobmanager", new DescriptorMethodImpl());
    private final Configuration conf = Configuration.getInstance();

    public POPConnectorJobManager() {
        super(DESCRIPTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createObject(POPAccessPoint localservice, String objname, ObjectDescription od, int howmany, POPAccessPoint[] objcontacts, int howmany2, POPAccessPoint[] remotejobcontacts) {
        int i;
        Resource currAva = this.jobManager.getAvailableResources();
        Resource resourceReq = new Resource(od.getPowerReq(), od.getMemoryReq(), od.getBandwidthReq());
        Resource resourceMin = new Resource(od.getPowerMin(), od.getMemoryMin(), od.getBandwidthMin());
        String appServiceFingerprint = localservice.getFingerprint();
        SNRequest request = new SNRequest(Util.generateUUID(), resourceReq, resourceMin, this.network.getUUID(), this.descriptor.getGlobalName(), appServiceFingerprint);
        if (od.getSearchMaxDepth() > 0) {
            request.setHopLimit(od.getSearchMaxDepth());
        }
        if (od.getSearchMaxSize() > 0) {
            // empty if block
        }
        int timeout = this.conf.getSearchNodeSearchTimeout();
        if (od.getSearchWaitTime() >= 0) {
            timeout = od.getSearchWaitTime();
        }
        if (!od.getPlatform().isEmpty()) {
            request.setOS(od.getPlatform());
        }
        if (od.getSearchHosts().length > 0) {
            request.setHosts(od.getSearchHosts());
        }
        String appId = "";
        String reqId = "";
        SNNodesInfo remoteJobMngs = this.jobManager.launchDiscovery(request, timeout);
        POPAccessPoint[] chosenRemoteJobM = new POPAccessPoint[howmany];
        if (remoteJobMngs.isEmpty()) {
            throw new POPException(10005, "No answer from the network while looking for resource " + resourceReq);
        }
        int[] resIDs = new int[howmany];
        int jmIdx = 0;
        int failed = 0;
        for (int jobIdx = 0; jobIdx < howmany; ++jobIdx) {
            POPJavaJobManager jm = PopJava.newActiveConnect(null, POPJavaJobManager.class, remoteJobMngs.get(jmIdx).getJobManager());
            POPMutableFloat fitness = new POPMutableFloat();
            resIDs[jobIdx] = jm.reserve(od, fitness, appId, reqId);
            if (resIDs[jobIdx] == 0) {
                LogWriter.writeDebugInfo("[JM] Usable to reserve on %s", jm.getAccessPoint());
                --jobIdx;
                jm.exit();
                if (++failed == remoteJobMngs.size()) {
                    for (int k = 0; k < jobIdx; ++k) {
                        jm = PopJava.connect(null, POPJavaJobManager.class, od.getNetwork(), chosenRemoteJobM[k]);
                        jm.cancelReservation(new int[]{resIDs[k]}, 1);
                        jm.exit();
                    }
                    return 1;
                }
            } else {
                chosenRemoteJobM[jobIdx] = jm.getAccessPoint();
                jm.exit();
            }
            jmIdx = (jmIdx + 1) % remoteJobMngs.size();
        }
        int started = 0;
        for (i = 0; i < howmany; ++i) {
            if (chosenRemoteJobM[i].isEmpty()) continue;
            POPJavaJobManager jm = PopJava.connect(null, POPJavaJobManager.class, od.getNetwork(), chosenRemoteJobM[i]);
            try {
                POPString pobjname = new POPString(objname);
                int[] localRIDs = new int[]{resIDs[i]};
                POPAccessPoint[] localObjContact = new POPAccessPoint[]{objcontacts[i]};
                int status = jm.execObj(pobjname, 1, localRIDs, localservice.toString(), localObjContact);
                objcontacts[i] = localObjContact[0];
                ++started;
                if (status != 0) {
                    --started;
                    LogWriter.writeDebugInfo("[JM] execution failed");
                    jm.cancelReservation(localRIDs, 1);
                    int n = 10001;
                    return n;
                }
                POPRemoteCaller remote = PopJava.getRemoteCaller();
                if (remote == null || !remote.isSecure() || remote.isUsingConfidenceLink()) continue;
                POPObject object = PopJava.connect(null, POPObject.class, od.getNetwork(), objcontacts[i]);
                Certificate cert = SSLUtils.getCertificate(remote.getFingerprint());
                object.PopRegisterFutureConnectorCertificate(SSLUtils.certificateBytes(cert));
                object.exit();
                continue;
            }
            catch (Exception e) {
                jm.cancelReservation(new int[]{resIDs[i]}, 1);
                int n = 10009;
                return n;
            }
            finally {
                jm.exit();
            }
        }
        LogWriter.writeDebugInfo("[JM] Object count=%d, require=%d", started, howmany);
        if (started >= howmany) {
            return 0;
        }
        for (i = 0; i < started; ++i) {
            try {
                Interface obj = new Interface(null, objcontacts[i]);
                obj.kill();
                continue;
            }
            catch (POPException e) {
                LogWriter.writeDebugInfo("[JM] Exception while killing objects: %s", e.getMessage());
            }
        }
        return 10010;
    }

    @Override
    public void askResourcesDiscoveryAction(SNRequest request, POPAccessPoint sender, SNExploration oldExplorationList) {
        Resource available = this.jobManager.getAvailableResources();
        if (available.canHandle(request.getResourceNeeded()) || available.canHandle(request.getMinResourceNeeded())) {
            SNNodesInfo.Node nodeinfo = new SNNodesInfo.Node(this.jobManager.getNodeId(), this.jobManager.getAccessPoint(), POPSystem.getPlatform(), available);
            SNResponse response = new SNResponse(request.getUID(), request.getNetworkUUID(), request.getExplorationList(), nodeinfo);
            if (request.getPublicCertificate().length > 0) {
                SSLUtils.addCertToTempStore(request.getPublicCertificate());
            }
            if (request.getAppServiceCertificate().length > 0) {
                SSLUtils.addCertToTempStore(request.getAppServiceCertificate());
            }
            this.jobManager.rerouteResponse(response, new SNWayback(request.getWayback()));
        }
    }

    @Override
    public boolean broadcastPresence() {
        return true;
    }

    private static class DescriptorMethodImpl
    implements POPNetworkDescriptorMethod {
        private DescriptorMethodImpl() {
        }

        @Override
        public POPConnector createConnector() {
            return new POPConnectorJobManager();
        }

        @Override
        public POPNode createNode(List<String> params) {
            return new POPNodeJobManager(params);
        }
    }
}

