/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnector;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlConnector;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlNetwork;
import ch.icosys.popjava.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class POPNetwork {
    private final String uuid;
    private String friendlyName;
    private final Map<POPNetworkDescriptor, POPConnector> connectors;
    private final POPJavaJobManager jobManager;

    public POPNetwork(String frendlyName, POPJavaJobManager jobManager) {
        this(Util.generateUUID(), frendlyName, jobManager);
    }

    public POPNetwork(String uuid, String friendlyName, POPJavaJobManager jobManager) {
        this.uuid = uuid;
        this.friendlyName = friendlyName;
        this.connectors = new HashMap<POPNetworkDescriptor, POPConnector>();
        this.jobManager = jobManager;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getUUID() {
        return this.uuid;
    }

    public POPConnector[] getConnectors() {
        Collection<POPConnector> conns = this.connectors.values();
        return conns.toArray(new POPConnector[conns.size()]);
    }

    public <T extends POPConnector> T getConnector(POPNetworkDescriptor connector) {
        return (T)this.connectors.get(connector);
    }

    public int size() {
        int size = 0;
        for (POPConnector l : this.getConnectors()) {
            size += l.size();
        }
        return size;
    }

    public List<POPNode> getMembers(POPNetworkDescriptor connectorName) {
        POPConnector connector = this.connectors.get(connectorName);
        if (connector == null) {
            return Collections.EMPTY_LIST;
        }
        return connector.getNodes();
    }

    public boolean add(POPNode node) {
        POPConnector connector = this.connectors.get(node.getConnectorDescriptor());
        if (connector == null) {
            connector = node.getConnectorDescriptor().createConnector();
            connector.setJobManager(this.jobManager);
            connector.setNetwork(this);
            this.connectors.put(connector.getDescriptor(), connector);
        }
        return connector.addNode(node);
    }

    public boolean remove(POPNode node) {
        POPConnector connector = this.connectors.get(node.getConnectorDescriptor());
        if (connector == null) {
            return false;
        }
        boolean status = connector.removeNode(node);
        if (connector.isEmpty()) {
            this.connectors.remove(connector.getDescriptor());
        }
        return status;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.uuid);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPNetwork other = (POPNetwork)obj;
        if (!Objects.equals(this.uuid, other.uuid)) {
            return false;
        }
        return Objects.equals(this.jobManager, other.jobManager);
    }

    public YamlNetwork toYamlResource() {
        YamlNetwork yamlNetwork = new YamlNetwork();
        yamlNetwork.setUuid(this.uuid);
        yamlNetwork.setFriendlyName(this.friendlyName);
        ArrayList<YamlConnector> yamlConnectors = new ArrayList<YamlConnector>(this.connectors.size());
        yamlNetwork.setConnectors(yamlConnectors);
        for (POPConnector connector : this.connectors.values()) {
            yamlConnectors.add(connector.toYamlResource());
        }
        return yamlNetwork;
    }
}

