/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.dataswaper.POPString;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public abstract class POPNodeAJobManager
extends POPNode {
    protected POPAccessPoint jobManagerAccessPoint;
    protected POPJavaJobManager jm;
    protected int port;
    protected String protocol;
    protected boolean initialized = true;

    public POPNodeAJobManager(POPNetworkDescriptor descriptor, String host, int port, String protocol) {
        super(descriptor);
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.init();
    }

    public POPNodeAJobManager(POPNetworkDescriptor descriptor, List<String> params) {
        super(descriptor);
        this.host = Util.removeStringFromList(params, "host=");
        String portString = Util.removeStringFromList(params, "port=");
        this.protocol = Util.removeStringFromList(params, "protocol=");
        if (this.host == null) {
            this.initialized = false;
            return;
        }
        Configuration conf = Configuration.getInstance();
        if (this.protocol == null) {
            this.protocol = conf.getDefaultProtocol();
        }
        this.port = conf.getJobManagerPorts()[0];
        if (portString != null) {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                this.initialized = false;
            }
        }
        this.init();
    }

    private void init() {
        this.jobManagerAccessPoint = new POPAccessPoint(String.format("%s://%s:%d", this.protocol, this.host, this.port));
        HashSet<String> paramsSet = new HashSet<String>();
        paramsSet.add("connector=" + this.descriptor.getGlobalName());
        paramsSet.add("host=" + this.host);
        paramsSet.add("port=" + this.port);
        paramsSet.add("protocol=" + this.protocol);
        this.creationParams = paramsSet.toArray(new String[paramsSet.size()]);
    }

    public final POPAccessPoint getJobManagerAccessPoint() {
        return this.jobManagerAccessPoint;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final POPJavaJobManager getJobManager(POPJavaJobManager localJM, String networkUUID) {
        if (localJM != null) {
            return localJM.connectToJobmanager(this.getJobManagerAccessPoint(), networkUUID);
        }
        if (this.jm == null) {
            this.jm = PopJava.connect(localJM, POPJavaJobManager.class, networkUUID, this.getJobManagerAccessPoint());
        }
        try {
            POPString val = new POPString();
            this.jm.query("power", val);
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[NodeJM] Connection lost with [%s], opening new one", this.getJobManagerAccessPoint());
            this.jm = PopJava.connect(localJM, POPJavaJobManager.class, networkUUID, this.getJobManagerAccessPoint());
        }
        return this.jm;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.host);
        hash = 67 * hash + Objects.hashCode(this.descriptor);
        hash = 67 * hash + this.port;
        hash = 67 * hash + Objects.hashCode(this.protocol);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPNodeAJobManager other = (POPNodeAJobManager)obj;
        if (this.port != other.port) {
            return false;
        }
        if (!Objects.equals(this.host, other.host)) {
            return false;
        }
        if (!Objects.equals(this.protocol, other.protocol)) {
            return false;
        }
        return this.descriptor == other.descriptor;
    }

    @Override
    public String toString() {
        return String.format("host=%s port=%s connector=%s protocol=%s", this.host, this.port, this.descriptor.getGlobalName(), this.protocol);
    }
}

