/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.system;

import ch.icosys.popjava.core.system.XMLWorker;
import java.io.File;
import java.security.InvalidParameterException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationWorker
extends XMLWorker {
    private static final String CONFIG_SUFFIX = "popj_config";
    private static final String ENV_POPJ_LOCATION = "POPJAVA_LOCATION";
    private static final String CONFIG_DIRECTORY = "etc";
    private static final String DEFAULT_POPJ_LOCATION = "/home/clementval/popj";
    private static final String ATTRIBUTE_ITEM_NAME = "item";
    public static final String POPJ_LOCATION_ITEM = "popj_location";
    public static final String POPJ_PLUGIN_ITEM = "popj_plugin_location";
    public static final String POPJ_BROKER_COMMAND_ITEM = "popj_broker_command";
    public static final String POPC_APPCORESERVICE_ITEM = "popc_appcoreservice_location";
    private String configFileLocation;
    private String configSchemaLocation;
    private String popjLocation;

    public ConfigurationWorker() throws Exception {
        String baseLocation = System.getenv(ENV_POPJ_LOCATION);
        if (baseLocation == null) {
            baseLocation = DEFAULT_POPJ_LOCATION;
        }
        this.popjLocation = baseLocation;
        if (!this.popjLocation.endsWith("/")) {
            this.popjLocation = this.popjLocation + "/";
        }
        this.configFileLocation = this.popjLocation + CONFIG_DIRECTORY + "/" + CONFIG_SUFFIX + ".xml";
        this.configSchemaLocation = this.popjLocation + CONFIG_DIRECTORY + "/" + CONFIG_SUFFIX + ".xsd";
        if (!this.isValid(this.configFileLocation, this.configSchemaLocation)) {
            throw new InvalidParameterException("Configuration file is not valid");
        }
    }

    public String getValue(String name) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(this.configFileLocation));
            Element popjConfigElement = document.getDocumentElement();
            NodeList list = popjConfigElement.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                String itemName;
                NamedNodeMap attributes;
                Node node = list.item(index);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(ATTRIBUTE_ITEM_NAME) || (attributes = node.getAttributes()) == null || !(itemName = attributes.item(0).getTextContent()).equals(name)) continue;
                return node.getTextContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }
}

