/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.system;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class POPRemoteLogThread
extends Thread {
    private String appID;
    private String filename;
    private boolean running = true;
    private static final int POLLING_SLEEP = 750;

    public POPRemoteLogThread(String appID) {
        super("Remote log thread");
        this.appID = appID;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRunning(boolean value) {
        this.running = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.filename = new File("/tmp").exists() ? "/tmp/" : System.getProperty("java.io.tmpdir");
        this.filename = this.filename + "popjava_logremote_" + this.appID;
        File logFile = new File(this.filename);
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        RandomAccessFile log = null;
        try {
            log = new RandomAccessFile(logFile, "r");
            long filePointer = 0L;
            while (this.running) {
                long fileLength = log.length();
                if (fileLength > filePointer) {
                    log.seek(filePointer);
                    String line = log.readLine();
                    while (line != null) {
                        System.out.println(line);
                        line = log.readLine();
                    }
                    filePointer = log.getFilePointer();
                }
                POPRemoteLogThread.sleep(750L);
            }
            logFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (log != null) {
                try {
                    log.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

