/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class POPRemoteCaller
implements IPOPBase {
    private InetAddress remote;
    private String protocol;
    private String network;
    private boolean secure;
    private POPAccessPoint brokerAP = null;
    private String fingerprint;

    public POPRemoteCaller() {
    }

    public POPRemoteCaller(InetAddress remote, String protocol, String network, boolean secure, String fingerprint) {
        this.remote = remote;
        this.protocol = protocol;
        this.secure = secure;
        this.fingerprint = fingerprint;
        this.network = network;
    }

    public POPRemoteCaller(InetAddress remote, String protocol, String network, boolean secure) {
        this(remote, protocol, network, secure, null);
    }

    public InetAddress getRemote() {
        return this.remote;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getNetwork() {
        return this.network;
    }

    public boolean isUsingConfidenceLink() {
        return SSLUtils.isConfidenceLink(this.fingerprint);
    }

    public boolean isLocalHost() {
        return Util.isLocal(this.remote.getHostAddress());
    }

    public String toString() {
        return String.format("%s://%s [%s]", this.protocol, this.remote.getHostAddress(), this.network);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.remote);
        hash = 67 * hash + Objects.hashCode(this.protocol);
        hash = 67 * hash + Objects.hashCode(this.network);
        hash = 67 * hash + Objects.hashCode(this.fingerprint);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPRemoteCaller other = (POPRemoteCaller)obj;
        if (!Objects.equals(this.protocol, other.protocol)) {
            return false;
        }
        if (!Objects.equals(this.fingerprint, other.fingerprint)) {
            return false;
        }
        if (!Objects.equals(this.network, other.network)) {
            return false;
        }
        return Objects.equals(this.remote, other.remote);
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putByteArray(this.remote.getAddress());
        buffer.putString(this.protocol);
        buffer.putBoolean(this.secure);
        boolean net = this.network != null;
        buffer.putBoolean(net);
        if (net) {
            buffer.putString(this.network);
        }
        boolean fig = this.fingerprint != null;
        buffer.putBoolean(fig);
        if (fig) {
            buffer.putString(this.fingerprint);
        }
        buffer.putBoolean(this.brokerAP != null);
        if (this.brokerAP != null) {
            buffer.putValue(this.brokerAP, POPAccessPoint.class);
        }
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        try {
            int size = buffer.getInt();
            this.remote = InetAddress.getByAddress(buffer.getByteArray(size));
        }
        catch (UnknownHostException e) {
            LogWriter.writeDebugInfo("[POPRemoteCaller] can't decode received InetAddress");
        }
        this.protocol = buffer.getString();
        this.secure = buffer.getBoolean();
        if (buffer.getBoolean()) {
            this.network = buffer.getString();
        }
        if (buffer.getBoolean()) {
            this.fingerprint = buffer.getString();
        }
        if (buffer.getBoolean()) {
            this.brokerAP = (POPAccessPoint)buffer.getValue(POPAccessPoint.class);
        }
        return true;
    }

    public void setBrokerAP(POPAccessPoint ap) {
        this.brokerAP = ap;
    }

    public POPAccessPoint getBrokerAP() {
        return this.brokerAP;
    }
}

