/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.Resource;
import ch.icosys.popjava.core.service.jobmanager.external.POPNetworkDetails;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.KeyPairDetails;
import ch.icosys.popjava.core.util.ssl.KeyStoreDetails;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;

public class JobManagerConfig {
    private final POPJavaJobManager jobManager;

    public JobManagerConfig() {
        Configuration conf = Configuration.getInstance();
        String protocol = conf.getJobManagerProtocols()[0];
        int port = conf.getJobManagerPorts()[0];
        String accessString = String.format("%s://%s:%d", protocol, POPSystem.getHostIP(), port);
        POPAccessPoint jma = new POPAccessPoint(accessString);
        this.jobManager = PopJava.connect(null, POPJavaJobManager.class, conf.getDefaultNetwork(), jma);
    }

    public boolean publishTFCObject(Object object, String tfcNetworkUUID, String secret) {
        if (object instanceof POPObject) {
            POPObject temp = (POPObject)object;
            return this.jobManager.registerTFCObject(tfcNetworkUUID, temp.getClassName(), temp.getAccessPoint(), secret);
        }
        return false;
    }

    public void withdrawnTFCObject(Object object, String tfcNetworkUUID, String secret) {
        if (object instanceof POPObject) {
            POPObject temp = (POPObject)object;
            this.jobManager.unregisterTFCObject(tfcNetworkUUID, temp.getClassName(), temp.getAccessPoint(), secret);
        }
    }

    public void registerNode(String networksUUID, POPNode node) {
        this.jobManager.registerPermanentNode(networksUUID, node.getCreationParams());
    }

    public void registerNode(String networkUUID, POPNode node, Certificate certificate) {
        this.jobManager.registerPermanentNode(networkUUID, SSLUtils.certificateBytes(certificate), node.getCreationParams());
    }

    public void unregisterNode(String networkUUID, POPNode node) {
        this.jobManager.unregisterPermanentNode(networkUUID, node.getCreationParams());
    }

    public POPNetworkDetails createNetwork(String friendlyName) {
        return this.jobManager.createNetwork(friendlyName);
    }

    public POPNetworkDetails createNetwork(String networkUUID, String friendlyName) {
        return this.jobManager.createNetwork(networkUUID, friendlyName);
    }

    public void removeNetwork(String networkUUID) {
        this.jobManager.removeNetwork(networkUUID);
    }

    public void changeAvailablePower(float limit) {
        this.jobManager.changeAvailablePower(limit);
    }

    public void changeAvailableMemory(float limit) {
        this.jobManager.changeAvailableMemory(limit);
    }

    public void changeAvailableBandwidth(float limit) {
        this.jobManager.changeAvailableBandwidth(limit);
    }

    public void changeMaxJobLimit(int limit) {
        this.jobManager.changeMaxJobLimit(limit);
    }

    public void changeMaxJobPower(float limit) {
        this.jobManager.changeMaxJobPower(limit);
    }

    public void changeMaxJobMemory(float limit) {
        this.jobManager.changeMaxJobMemory(limit);
    }

    public void changeMaxJobBandwidth(float limit) {
        this.jobManager.changeMaxJobBandwidth(limit);
    }

    public POPNetworkDetails[] availableNetworks() {
        return this.jobManager.getAvailableNetworks();
    }

    public POPNode[] networkNodes(String networkUUID) {
        String[][] networkNodes = this.jobManager.getNetworkNodes(networkUUID);
        if (networkNodes == null) {
            return new POPNode[0];
        }
        POPNode[] nodes = new POPNode[networkNodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ArrayList<String> nodeParams = new ArrayList<String>(Arrays.asList(networkNodes[i]));
            String connector = Util.removeStringFromList(nodeParams, "connector=");
            POPNetworkDescriptor descriptor = POPNetworkDescriptor.from(connector);
            if (descriptor == null) continue;
            nodes[i] = descriptor.createNode(nodeParams);
        }
        return nodes;
    }

    public boolean generateKeyStore(KeyStoreDetails ksDetails, KeyPairDetails keyDetails) {
        return SSLUtils.generateKeyStore(ksDetails, keyDetails);
    }

    public void setConfigurationFileLocation(File location) throws IOException {
        if (!location.canWrite()) {
            throw new IOException("Can't write in this location");
        }
        this.jobManager.setConfigurationFile(location.getAbsolutePath());
    }

    public Resource getInitialAvailableResources() {
        return this.jobManager.getInitialAvailableResources();
    }

    public Resource getJobResourcesLimit() {
        return this.jobManager.getInitialAvailableResources();
    }

    public int getMaxJobs() {
        return this.jobManager.getMaxJobs();
    }

    @Deprecated
    public void dump() {
        this.jobManager.dump();
    }
}

