/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.base;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.annotation.POPAsyncConc;
import ch.icosys.popjava.core.annotation.POPAsyncMutex;
import ch.icosys.popjava.core.annotation.POPAsyncSeq;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.annotation.POPConfig;
import ch.icosys.popjava.core.annotation.POPObjectDescription;
import ch.icosys.popjava.core.annotation.POPPrivate;
import ch.icosys.popjava.core.annotation.POPSyncConc;
import ch.icosys.popjava.core.annotation.POPSyncMutex;
import ch.icosys.popjava.core.annotation.POPSyncSeq;
import ch.icosys.popjava.core.base.MethodInfo;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.baseobject.ConnectionType;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.baseobject.POPTracking;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.util.ClassUtil;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.MethodUtil;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.ProxyObject;

public class POPObject
implements IPOPBase {
    protected int refCount = 0;
    private int classId = 0;
    protected boolean generateClassId = true;
    protected boolean definedMethodId = false;
    private boolean hasDestructor = false;
    protected ObjectDescription od = new ObjectDescription();
    private String className = "";
    private final ConcurrentHashMap<MethodInfo, Integer> semantics = new ConcurrentHashMap();
    private final HashMap<MethodInfo, Method> methodInfos = new HashMap();
    private final HashMap<Method, MethodInfo> reverseMethodInfos = new HashMap();
    private final HashMap<MethodInfo, Constructor<?>> constructorInfos = new HashMap();
    private final HashMap<Constructor<?>, MethodInfo> reverseConstructorInfos = new HashMap();
    private boolean temporary = false;
    private POPObject me = null;
    private Broker broker = null;

    public POPObject() {
        this.className = this.getRealClass().getName();
        this.loadClassAnnotations();
        this.initializePOPObject();
    }

    private Class<? extends POPObject> getRealClass() {
        if (this instanceof ProxyObject) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    private void loadClassAnnotations() {
        for (Annotation annotation : this.getRealClass().getDeclaredAnnotations()) {
            if (!(annotation instanceof POPClass)) continue;
            POPClass popClassAnnotation = (POPClass)annotation;
            if (!popClassAnnotation.className().isEmpty()) {
                this.setClassName(popClassAnnotation.className());
            }
            if (popClassAnnotation.classId() != -1) {
                this.setClassId(popClassAnnotation.classId());
            }
            this.hasDestructor(popClassAnnotation.deconstructor());
        }
    }

    private void loadODAnnotations(Constructor<?> constructor) {
        POPObjectDescription objectDescription = constructor.getAnnotation(POPObjectDescription.class);
        if (objectDescription != null) {
            this.od.setHostname(objectDescription.url());
            this.od.setJVMParamters(objectDescription.jvmParameters());
            this.od.setConnectionType(objectDescription.connection());
            this.od.setConnectionSecret(objectDescription.connectionSecret());
            this.od.setEncoding(objectDescription.encoding().toString());
            this.od.setProtocols(objectDescription.protocols());
            this.od.setNetwork(objectDescription.network());
            this.od.setConnector(objectDescription.connector());
            this.od.setPower(objectDescription.power(), objectDescription.minPower());
            this.od.setMemory(objectDescription.memory(), objectDescription.minMemory());
            this.od.setBandwidth(objectDescription.bandwidth(), objectDescription.minBandwidth());
            this.od.setSearch(objectDescription.searchDepth(), -1, objectDescription.searchTime());
            this.od.setUseLocalJVM(objectDescription.localJVM());
            this.od.setTracking(objectDescription.tracking());
            this.od.setUPNP(objectDescription.upnp());
        }
    }

    private void loadParameterAnnotations(Constructor<?> constructor, Object ... argvs) {
        Annotation[][] annotations = constructor.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            block10: for (int loop = 0; loop < annotations[i].length; ++loop) {
                if (!annotations[i][loop].annotationType().equals(POPConfig.class)) continue;
                POPConfig config = (POPConfig)annotations[i][loop];
                if (argvs[i] == null) {
                    throw new InvalidParameterException("Annotated paramater " + i + " for " + this.getClassName() + " is null");
                }
                switch (config.value()) {
                    case URL: {
                        if (argvs[i] instanceof String) {
                            this.od.setHostname((String)argvs[i]);
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type String for Annotation " + config.value().name());
                    }
                    case CONNECTION: {
                        if (argvs[i] instanceof ConnectionType) {
                            this.od.setConnectionType((ConnectionType)((Object)argvs[i]));
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type ConnectionType for Annotation " + config.value().name());
                    }
                    case CONNECTION_PWD: {
                        if (argvs[i] instanceof String) {
                            this.od.setConnectionSecret((String)argvs[i]);
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type String for Annotation " + config.value().name());
                    }
                    case ACCESS_POINT: {
                        if (argvs[i] instanceof String) {
                            this.od.setRemoteAccessPoint((String)argvs[i]);
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type String for Annotation " + config.value().name());
                    }
                    case LOCAL_JVM: {
                        if (argvs[i] instanceof Boolean) {
                            this.od.setUseLocalJVM((Boolean)argvs[i]);
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type Boolean for Annotation  " + config.value().name());
                    }
                    case UPNP: {
                        if (argvs[i] instanceof Boolean) {
                            this.od.setUPNP((Boolean)argvs[i]);
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type Boolean for Annotation " + config.value().name());
                    }
                    case PROTOCOLS: {
                        if (argvs[i] instanceof String) {
                            this.od.setProtocols(new String[]{(String)argvs[i]});
                            continue block10;
                        }
                        if (argvs[i] instanceof String[]) {
                            this.od.setProtocols((String[])argvs[i]);
                            continue block10;
                        }
                        throw new InvalidParameterException("Annotated paramater " + i + " in " + this.getClassName() + " was not of type String or String[] for Annotation " + config.value().name());
                    }
                }
            }
        }
    }

    private void loadDynamicOD(Constructor<?> constructor, Object ... argvs) {
        this.loadODAnnotations(constructor);
        this.loadParameterAnnotations(constructor, argvs);
    }

    public void loadPOPAnnotations(Constructor<?> constructor, Object ... argvs) {
        this.loadDynamicOD(constructor, argvs);
    }

    protected final void initializePOPObject() {
        if (this.generateClassId) {
            this.classId = ClassUtil.classId(this.getRealClass());
        }
        Class<? extends POPObject> c = this.getRealClass();
        this.initializeConstructorInfo(c);
        this.initializeMethodInfo(c);
    }

    public boolean isDaemon() {
        return false;
    }

    public final boolean canKill() {
        return true;
    }

    public final ObjectDescription getOd() {
        return this.od;
    }

    public final void setOd(ObjectDescription od) {
        this.od = od;
    }

    public POPAccessPoint getAccessPoint() {
        if (this.broker == null) {
            throw new RuntimeException("Can not pass object as parameter before it has been initialized");
        }
        return this.broker.getAccessPoint();
    }

    public Broker getBroker() {
        return this.broker;
    }

    public final String getClassName() {
        return this.className;
    }

    protected final void setClassName(String className) {
        this.className = className;
    }

    protected final boolean hasDestructor() {
        return this.hasDestructor;
    }

    protected final void hasDestructor(boolean hasDestructor) {
        this.hasDestructor = hasDestructor;
    }

    public final int getClassId() {
        return this.classId;
    }

    protected final void setClassId(int classId) {
        this.generateClassId = false;
        this.classId = classId;
    }

    public Method getMethodByInfo(MethodInfo info) throws NoSuchMethodException {
        Method method = this.methodInfos.get(info);
        if (method == null) {
            for (MethodInfo key : this.methodInfos.keySet()) {
                System.out.println(key.getClassId() + " " + key.getMethodId() + " " + this.methodInfos.get(key).getName());
            }
            throw new NoSuchMethodException();
        }
        return method;
    }

    public Constructor<?> getConstructorByInfo(MethodInfo info) throws NoSuchMethodException {
        Constructor<?> c = this.constructorInfos.get(info);
        if (c == null) {
            throw new NoSuchMethodException();
        }
        return c;
    }

    public MethodInfo getMethodInfo(Method method) {
        return this.reverseMethodInfos.getOrDefault(method, new MethodInfo(0, 0));
    }

    public MethodInfo getMethodInfo(Constructor<?> constructor) {
        MethodInfo c = this.reverseConstructorInfos.get(constructor);
        if (c == null) {
            throw new RuntimeException("Could not find constructor " + constructor.toGenericString());
        }
        return c;
    }

    public int getSemantic(MethodInfo methodInfo) {
        return this.semantics.getOrDefault(methodInfo, 1);
    }

    public int getSemantic(Method method) {
        MethodInfo methodInfo = this.getMethodInfo(method);
        return this.getSemantic(methodInfo);
    }

    public final void addSemantic(Class<?> c, String methodName, int semantic) {
        Method[] allMethods = c.getDeclaredMethods();
        if (allMethods.length > 0) {
            for (Method m : allMethods) {
                MethodInfo methodInfo;
                if (!m.getName().equals(methodName) || (methodInfo = this.getMethodInfo(m)).getMethodId() <= 0) continue;
                if (this.semantics.containsKey(methodInfo)) {
                    this.semantics.replace(methodInfo, semantic);
                    continue;
                }
                this.semantics.put(methodInfo, semantic);
            }
        }
    }

    public final void addSemantic(Class<?> c, String methodName, int semantic, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = c.getMethod(methodName, parameterTypes);
        MethodInfo methodInfo = this.getMethodInfo(method);
        if (methodInfo.getMethodId() > 0) {
            if (this.semantics.containsKey(methodInfo)) {
                this.semantics.replace(methodInfo, semantic);
            } else {
                this.semantics.put(methodInfo, semantic);
            }
        } else {
            String errorMessage = ClassUtil.getMethodSign(method);
            throw new NoSuchMethodException(errorMessage);
        }
    }

    protected void initializeMethodInfo(Class<?> c) {
        if (!this.definedMethodId) {
            while (c != Object.class) {
                Method[] allMethods;
                for (Method m : allMethods = c.getDeclaredMethods()) {
                    Class<?> declaringClass = m.getDeclaringClass();
                    POPClass popClassAnnotation = declaringClass.getAnnotation(POPClass.class);
                    if (popClassAnnotation == null && !declaringClass.equals(POPObject.class) || !Modifier.isPublic(m.getModifiers()) || !MethodUtil.isMethodPOPAnnotated(m)) continue;
                    int methodId = MethodUtil.methodId(m);
                    int methodClassId = ClassUtil.classId(c);
                    MethodInfo methodInfo = new MethodInfo(methodClassId, methodId);
                    this.methodInfos.put(methodInfo, m);
                    this.reverseMethodInfos.put(m, methodInfo);
                    this.addMethodSemantic(methodInfo, m);
                }
                c = c.getSuperclass();
            }
        }
    }

    private void addMethodSemantic(MethodInfo mi, Method m) {
        if (m.isAnnotationPresent(POPPrivate.class)) {
            return;
        }
        Annotation[] annotations = new Annotation[]{MethodUtil.getMethodPOPAnnotation(m, POPSyncConc.class), MethodUtil.getMethodPOPAnnotation(m, POPSyncSeq.class), MethodUtil.getMethodPOPAnnotation(m, POPSyncMutex.class), MethodUtil.getMethodPOPAnnotation(m, POPAsyncConc.class), MethodUtil.getMethodPOPAnnotation(m, POPAsyncSeq.class), MethodUtil.getMethodPOPAnnotation(m, POPAsyncMutex.class)};
        Annotation annotation = null;
        for (Annotation ia : annotations) {
            if (Objects.isNull(ia)) continue;
            if (annotation != null) {
                throw new POPException(10021, "Can not declare mutliple POP Semantics for same method " + m.toGenericString());
            }
            annotation = ia;
        }
        int semantic = -1;
        if (annotation.annotationType() == POPSyncConc.class) {
            semantic = 9;
        } else if (annotation.annotationType() == POPSyncSeq.class) {
            semantic = 1;
        } else if (annotation.annotationType() == POPSyncMutex.class) {
            semantic = 17;
        } else if (annotation.annotationType() == POPAsyncConc.class) {
            semantic = 8;
        } else if (annotation.annotationType() == POPAsyncSeq.class) {
            semantic = 0;
        }
        if (annotation.annotationType() == POPAsyncMutex.class) {
            semantic = 16;
        }
        if (semantic != -1) {
            this.semantics.put(mi, semantic);
        }
    }

    protected void initializeConstructorInfo(Class<?> c) {
        if (!this.definedMethodId) {
            Constructor<?>[] allConstructors = c.getDeclaredConstructors();
            Arrays.sort(allConstructors, new Comparator<Constructor<?>>(){

                @Override
                public int compare(Constructor<?> first, Constructor<?> second) {
                    String firstSign = ClassUtil.getMethodSign(first);
                    String secondSign = ClassUtil.getMethodSign(second);
                    return firstSign.compareTo(secondSign);
                }
            });
            for (Constructor<?> constructor : allConstructors) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                int id = MethodUtil.constructorId(constructor);
                MethodInfo info = new MethodInfo(this.getClassId(), id);
                this.constructorInfos.put(info, constructor);
                this.reverseConstructorInfos.put(constructor, info);
                this.semantics.put(info, 5);
            }
        }
    }

    protected void defineMethod(Class<?> c, String methodName, int methodId, int semanticId, Class<?> ... paramTypes) {
        try {
            Method m = c.getMethod(methodName, paramTypes);
            MethodInfo methodInfo = new MethodInfo(this.getClassId(), methodId);
            this.methodInfos.put(methodInfo, m);
            if (this.semantics.containsKey(methodInfo)) {
                this.semantics.replace(methodInfo, semanticId);
            } else {
                this.semantics.put(methodInfo, semanticId);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }

    protected void defineConstructor(Class<?> c, int constructorId, Class<?> ... paramTypes) {
        try {
            Constructor<?> constructor = c.getConstructor(paramTypes);
            MethodInfo info = new MethodInfo(this.getClassId(), constructorId);
            this.constructorInfos.put(info, constructor);
            this.semantics.put(info, 5);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        return true;
    }

    public boolean deserialize(Combox<?> sourceCombox, POPBuffer buffer) {
        return true;
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        if (this.od.useLocalJVM() && this.broker != null) {
            this.od.serialize(buffer);
            this.broker.getAccessPoint().serialize(buffer);
            buffer.putInt(1);
            return true;
        }
        return true;
    }

    public void exit() {
    }

    public void printMethodInfo() {
        System.out.println("===========ConstructorInfo============");
        this.constructorInfos.forEach((mi, c) -> System.out.format("ClassId:%d.ConstructorId:%d.Sign:%s", mi.getClassId(), mi.getMethodId(), c.toGenericString()));
        System.out.println("===========MethodInfo============");
        this.methodInfos.forEach((mi, m) -> System.out.format("ClassId:%d.MethodId:%d.Sign:%s", mi.getClassId(), mi.getMethodId(), m.toGenericString()));
        System.out.println("===========SemanticsInfo============");
        this.semantics.forEach((mi, s) -> System.out.format("ClassId:%d.ConstructorId:%d.Semantics:%d", mi.getClassId(), mi.getMethodId(), s));
    }

    public String getPOPCReference() {
        return this.getAccessPoint().toString();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void makeTemporary() {
        this.temporary = true;
    }

    public <T extends POPObject> T makePermanent() {
        this.temporary = false;
        return (T)this;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public <T> T getThis(Class<T> myClass) {
        return this.getThis();
    }

    public <T> T getThis() {
        if (this.me == null) {
            this.me = (POPObject)PopJava.newActiveConnect(this, this.getClass(), this.getAccessPoint());
            if (this.me != null && this.broker != null) {
                this.broker.onCloseConnection("SelfReference");
            }
        }
        return (T)this.me;
    }

    @POPSyncConc
    public void PopRegisterFutureConnectorCertificate(byte[] cert) {
        LogWriter.writeDebugInfo("Writing certificate received from middleman.");
        SSLUtils.addCertToTempStore(cert, true);
    }

    @POPSyncSeq(localhost=true)
    public POPRemoteCaller[] getTrackedUsers() {
        return this.broker.getTrackingUsers();
    }

    @POPSyncSeq(localhost=true)
    public POPTracking getTracked(POPRemoteCaller caller) {
        return this.broker.getTracked(caller);
    }

    @POPSyncSeq
    public POPTracking getTracked() {
        return this.broker.getTracked(PopJava.getRemoteCaller());
    }

    @POPSyncConc
    public boolean isTracking() {
        return this.broker.isTraking();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        PopJava.disconnect(this);
    }
}

