/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.baseobject;

import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.system.POPSystem;
import java.util.ArrayList;

public class POPAccessPoint
implements IPOPBase {
    private boolean isService;
    private boolean noaddref = false;
    private int security;
    private String fingerprint = null;
    private byte[] x509certificate = null;
    protected final ArrayList<AccessPoint> accessPoints = new ArrayList();

    public POPAccessPoint() {
    }

    public POPAccessPoint(boolean initialize) {
        if (initialize) {
            this.accessPoints.addAll(POPSystem.getDefaultAccessPoint().accessPoints);
        }
    }

    public POPAccessPoint(String accessString) {
        this.setAccessString(accessString);
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putString(this.toString());
        buffer.putInt(this.security);
        buffer.putBoolean(this.isService);
        buffer.putBoolean(this.noaddref);
        if (this.fingerprint != null) {
            buffer.putBoolean(true);
            buffer.putString(this.fingerprint);
        } else {
            buffer.putBoolean(false);
        }
        if (this.x509certificate != null) {
            buffer.putBoolean(true);
            buffer.putArray(this.x509certificate);
        } else {
            buffer.putBoolean(false);
        }
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        String accessPoint = buffer.getString();
        this.setAccessString(accessPoint);
        this.security = buffer.getInt();
        this.isService = buffer.getBoolean();
        this.noaddref = buffer.getBoolean();
        if (buffer.getBoolean()) {
            this.fingerprint = buffer.getString();
        }
        if (buffer.getBoolean()) {
            int size = buffer.getInt();
            this.x509certificate = buffer.getByteArray(size);
        }
        return true;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public byte[] getX509certificate() {
        return this.x509certificate;
    }

    public void setX509certificate(byte[] x509certificate) {
        this.x509certificate = x509certificate;
    }

    public void addAccessPoint(AccessPoint accessPoint) {
        if (!this.accessPoints.contains(accessPoint)) {
            this.accessPoints.add(accessPoint);
        }
    }

    public boolean isEmpty() {
        return this.accessPoints.isEmpty();
    }

    public String toString() {
        StringBuilder accessString = new StringBuilder();
        for (AccessPoint accessPoint : this.accessPoints) {
            accessString.append(accessPoint.toString()).append(" ");
        }
        accessString = new StringBuilder(accessString.toString().trim());
        return accessString.toString();
    }

    public void setAccessString(String accessString) {
        String[] accessStrings;
        this.accessPoints.clear();
        for (String str : accessStrings = accessString.split("[ \t\r\n]")) {
            AccessPoint acessPoint;
            if ((str = str.trim()).length() <= 0 || (acessPoint = AccessPoint.create(str)) == null) continue;
            this.accessPoints.add(acessPoint);
        }
    }

    public int size() {
        return this.accessPoints.size();
    }

    public AccessPoint get(int index) {
        return this.accessPoints.get(index);
    }

    public boolean hasSameAccessPoint(POPAccessPoint ap) {
        if (ap == null) {
            return false;
        }
        for (int i = 0; i < ap.size(); ++i) {
            if (!this.accessPoints.contains(ap.get(i))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPoints == null ? 0 : this.accessPoints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPAccessPoint other = (POPAccessPoint)obj;
        return !(this.accessPoints == null ? other.accessPoints != null : !this.accessPoints.equals(other.accessPoints));
    }
}

