/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.baseobject;

import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;

public class POPTrackingMethod
implements IPOPBase {
    private String method;
    private int calls;
    private long totalTime;
    private long totalInputParamsSize;
    private long totalOutputResultSize;

    public POPTrackingMethod() {
        this(null);
    }

    POPTrackingMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public long getTotalCalls() {
        return this.calls;
    }

    public synchronized void increment(long time, int inputParamsSize, int outputResultSize) {
        ++this.calls;
        this.totalTime += time;
        this.totalInputParamsSize += (long)inputParamsSize;
        this.totalOutputResultSize += (long)outputResultSize;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getTotalInputParamsSize() {
        return this.totalInputParamsSize;
    }

    public long getTotalOutputResultSize() {
        return this.totalOutputResultSize;
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putString(this.method);
        buffer.putInt(this.calls);
        buffer.putLong(this.totalTime);
        buffer.putLong(this.totalInputParamsSize);
        buffer.putLong(this.totalOutputResultSize);
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.method = buffer.getString();
        this.calls = buffer.getInt();
        this.totalTime = buffer.getLong();
        this.totalInputParamsSize = buffer.getLong();
        this.totalOutputResultSize = buffer.getLong();
        return true;
    }

    public String toString() {
        return String.format("%s -> calls: %d, time: %d ms, input size: %d bytes, output size: %d bytes ", this.method, this.calls, this.totalTime, this.totalInputParamsSize, this.totalOutputResultSize);
    }
}

