/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox;

import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.BufferFactoryFinder;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.socket.ComboxAcceptSocket;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import java.util.HashSet;
import java.util.Set;

public abstract class Combox<T> {
    private static final boolean KEEP_ALIVE = true;
    private static final int KEEP_ALIVE_INTERVAL = 30000;
    protected static final int SEND_REMOTE_AP = 1;
    protected static final int OPEN_BIDIRECTIONAL = 2;
    protected static final int CLOSE_SUBCONNECTION = 3;
    protected static final int PING = 4;
    protected int timeOut = 0;
    protected POPAccessPoint accessPoint;
    protected boolean available = false;
    protected BufferFactory bufferFactory;
    protected T peerConnection;
    private String networkUUID;
    protected POPRemoteCaller remoteCaller;
    protected final Configuration conf = Configuration.getInstance();
    private Broker broker = null;
    private Set<Integer> openConnections = new HashSet<Integer>();
    private int connectionCounter = 10;
    private Thread keepAliveThread;
    private long lastCommunication = 0L;

    public Combox() {
        this(null);
    }

    public Combox(String networkUUID) {
        this.networkUUID = networkUUID;
        this.accessPoint = new POPAccessPoint();
        this.bufferFactory = BufferFactoryFinder.getInstance().findFactory(this.conf.getDefaultEncoding());
    }

    protected int registerNewConnection() {
        int id;
        do {
            ++this.connectionCounter;
        } while (this.openConnections.contains(id));
        this.openConnections.add(id);
        return id;
    }

    public final boolean connectToServer(Broker broker, POPAccessPoint accesspoint, int timeout) {
        this.accessPoint = accesspoint;
        this.timeOut = timeout;
        this.broker = broker;
        return this.connectToServer() && this.sendNetworkName() && this.exportConnectionInfo() && this.sendLocalAP(broker) && this.startKeepAlive();
    }

    public final boolean serverAccept(Broker broker, T peerConnection) {
        this.peerConnection = peerConnection;
        this.broker = broker;
        return this.serverAccept() && this.receiveNetworkName() && this.exportConnectionInfo() && this.receiveRemoveAP() && this.startKeepAlive();
    }

    private boolean startKeepAlive() {
        this.keepAliveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (System.currentTimeMillis() - Combox.this.lastCommunication <= 30000L) continue;
                    POPBuffer buffer = Combox.this.createServicePacket(4);
                    Combox.this.send(buffer);
                }
            }
        }, "Keep alive thread");
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.start();
        return true;
    }

    protected abstract boolean exportConnectionInfo();

    protected abstract boolean sendNetworkName();

    protected abstract boolean receiveNetworkName();

    protected abstract boolean connectToServer();

    protected abstract boolean serverAccept();

    private boolean sendLocalAP(Broker broker) {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.setRequestID(1);
        messageHeader.setRequestType(0);
        messageHeader.setConnectionID(0);
        POPBuffer buffer = this.bufferFactory.createBuffer();
        buffer.setHeader(messageHeader);
        buffer.putBoolean(broker != null);
        if (broker != null) {
            buffer.putValue(broker.getAccessPoint(), POPAccessPoint.class);
        }
        this.send(buffer);
        return true;
    }

    private boolean receiveRemoveAP() {
        POPBuffer buffer = this.bufferFactory.createBuffer();
        this.receive(buffer, 1, 0);
        POPAccessPoint ap = buffer.getBoolean() ? (POPAccessPoint)buffer.getValue(POPAccessPoint.class) : new POPAccessPoint();
        if (this.remoteCaller != null) {
            this.remoteCaller.setBrokerAP(ap);
        }
        return true;
    }

    public abstract int send(POPBuffer var1);

    public abstract int receive(POPBuffer var1, int var2, int var3);

    public void close(int connectionID) {
        this.close(connectionID, true);
    }

    protected void close(int connectionID, boolean informPartner) {
        if (connectionID == 0 || connectionID == 1) {
            this.openConnections.remove(0);
            this.openConnections.remove(1);
        } else {
            this.openConnections.remove(connectionID);
        }
        if (this.openConnections.size() == 0) {
            if (this.keepAliveThread != null) {
                this.keepAliveThread.interrupt();
                this.keepAliveThread = null;
            }
            this.closeInternal();
        } else if (informPartner) {
            POPBuffer buffer = this.createServicePacket(3);
            buffer.putInt(connectionID);
            this.send(buffer);
        }
    }

    protected abstract void closeInternal();

    public void setBufferFactory(BufferFactory bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public POPAccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public POPRemoteCaller getRemoteCaller() {
        return this.remoteCaller;
    }

    public String getNetworkUUID() {
        return this.networkUUID == null ? "" : this.networkUUID;
    }

    public void setNetworkUUID(String networkUUID) {
        this.networkUUID = networkUUID;
    }

    private POPBuffer createServicePacket(int methodID) {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.setRequestID(2);
        messageHeader.setMethodId(methodID);
        messageHeader.setConnectionID(0);
        messageHeader.setRequestType(0);
        POPBuffer buffer = this.bufferFactory.createBuffer();
        buffer.setHeader(messageHeader);
        return buffer;
    }

    public int makeBidirectional(Broker broker) {
        if (this.broker == null) {
            this.broker = broker;
        } else if (broker == null || this.broker != broker) {
            // empty if block
        }
        POPBuffer buffer = this.createServicePacket(2);
        buffer.putBoolean(this.broker != null);
        if (this.broker != null) {
            buffer.putValue(this.broker.getAccessPoint(), POPAccessPoint.class);
        }
        this.send(buffer);
        int answer = this.receive(buffer, 2, 0);
        if (answer > 0) {
            if (buffer.getHeader().getRequestType() == 2) {
                return -1;
            }
            int connectionID = buffer.getInt();
            this.openConnections.add(connectionID);
            return connectionID;
        }
        return -1;
    }

    protected boolean bindToBroker(int connectionID) {
        if (this.broker != null) {
            ComboxAcceptSocket.serveConnection(this.broker, this.broker.getRequestQueue(), this, connectionID);
            this.broker.onNewConnection();
            return true;
        }
        return false;
    }

    protected void handleComboxMessages(POPBuffer tempBuffer) {
        switch (tempBuffer.getHeader().getMethodId()) {
            case 2: {
                if (tempBuffer.getBoolean()) {
                    POPAccessPoint otherAP = (POPAccessPoint)tempBuffer.getValue(POPAccessPoint.class);
                    if (this.remoteCaller.getBrokerAP() == null) {
                        this.remoteCaller.setBrokerAP(otherAP);
                    }
                }
                int newConnectionID = this.registerNewConnection();
                this.bindToBroker(newConnectionID);
                tempBuffer.reset();
                MessageHeader header = new MessageHeader();
                header.setRequestType(1);
                header.setRequestID(tempBuffer.getHeader().getRequestID());
                header.setConnectionID(0);
                tempBuffer.setHeader(header);
                tempBuffer.putInt(newConnectionID);
                this.send(tempBuffer);
                break;
            }
            case 3: {
                int closedConnectionID = tempBuffer.getInt();
                this.close(closedConnectionID, false);
                break;
            }
            case 4: {
                break;
            }
            default: {
                System.out.println("Unknown internal method id " + tempBuffer.getHeader().getMethodId());
            }
        }
    }

    protected synchronized void registerCommuncation() {
        this.lastCommunication = System.currentTimeMillis();
    }
}

