/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox;

import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.broker.Request;
import ch.icosys.popjava.core.broker.RequestQueue;
import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.BufferFactoryFinder;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.ComboxConnection;
import ch.icosys.popjava.core.util.LogWriter;

public final class ComboxReceiveRequest
implements Runnable {
    public static final int RUNNING = 0;
    public static final int EXIT = 1;
    public static final int ABORT = 2;
    protected ComboxConnection combox;
    protected final RequestQueue requestQueue;
    protected final Broker broker;
    protected int status = 1;

    public ComboxReceiveRequest(Broker broker, RequestQueue requestQueue, ComboxConnection combox) {
        this.broker = broker;
        this.requestQueue = requestQueue;
        this.combox = combox;
    }

    @Override
    public void run() {
        this.setStatus(0);
        while (this.getStatus() == 0) {
            Request popRequest = new Request();
            popRequest.setRemoteCaller(this.combox.getRemoteCaller());
            try {
                if (!this.receiveRequest(popRequest)) {
                    this.setStatus(1);
                    break;
                }
                if (this.broker == null || this.broker.popCall(popRequest)) continue;
                this.broker.finalizeRequest(popRequest);
                this.requestQueue.add(popRequest);
            }
            catch (Exception e) {
                LogWriter.writeExceptionLog(e);
                this.setStatus(1);
            }
        }
        this.close();
    }

    public boolean receiveRequest(Request request) {
        POPBuffer buffer = this.combox.getCombox().getBufferFactory().createBuffer();
        int receivedLength = this.combox.receive(buffer, -1);
        if (receivedLength > 0) {
            request.setBroker(this.broker);
            MessageHeader messageHeader = buffer.extractHeader();
            request.setClassId(messageHeader.getClassId());
            request.setMethodId(messageHeader.getMethodId());
            request.setSenmatics(messageHeader.getSemantics());
            request.setRequestID(messageHeader.getRequestID());
            request.setBuffer(buffer);
            request.setReceiveCombox(this);
            request.setCombox(this.combox);
            return true;
        }
        return false;
    }

    public void close() {
        if (this.combox != null) {
            this.broker.onCloseConnection(this.hashCode() + " " + this.combox);
            this.combox.close();
            this.combox = null;
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized void setStatus(int status) {
        this.status = status;
    }

    public void setBuffer(String bufferType) {
        BufferFactoryFinder finder = BufferFactoryFinder.getInstance();
        BufferFactory factory = finder.findFactory(bufferType);
        this.combox.getCombox().setBufferFactory(factory);
    }

    public RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

