/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox;

import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.upnp.UPNPManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.Future;
import javax.net.ServerSocketFactory;

public class ComboxUtils {
    private static final PreOperation EMPTY = ss -> {};
    private static final ServerSocketFactory SS_FACTORY = ServerSocketFactory.getDefault();

    public static ServerSocket createServerSocket(int port, PreOperation op, boolean upnp) throws IOException {
        if (op == null) {
            op = EMPTY;
        }
        return ComboxUtils.createServerSocket(port, op, port == 0, upnp);
    }

    private static ServerSocket createServerSocket(int port, PreOperation op, boolean sequential, boolean upnp) throws IOException {
        ServerSocket server = SS_FACTORY.createServerSocket();
        boolean working = false;
        if (port == 0) {
            port = Configuration.getInstance().getAllocatePortRange();
        }
        do {
            try {
                op.preBind(server);
                server.bind(new InetSocketAddress(port));
                working = true;
            }
            catch (IOException ex) {
                server.close();
                server = new ServerSocket();
                if (!sequential) {
                    server.close();
                    throw ex;
                }
                if (++port <= 65535) continue;
                server.close();
                throw new IOException("[ComboxUtils] can't find an available port");
            }
        } while (!working);
        if (upnp) {
            Future<String> future = UPNPManager.registerPort(server.getLocalPort());
        }
        return server;
    }

    public static interface PreOperation {
        public void preBind(ServerSocket var1) throws IOException;
    }
}

