/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.ssl;

import ch.icosys.popjava.core.combox.ComboxAllocate;
import ch.icosys.popjava.core.combox.ComboxUtils;
import ch.icosys.popjava.core.combox.socket.ssl.ComboxSecureSocket;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ComboxAllocateSecureSocket
extends ComboxAllocate {
    protected ServerSocket serverSocket = null;
    protected SSLSocketFactory sslFactory = null;

    public ComboxAllocateSecureSocket(boolean enableUPNP) {
        try {
            SSLContext sslContext = SSLUtils.getSSLContext();
            this.sslFactory = sslContext.getSocketFactory();
            this.serverSocket = ComboxUtils.createServerSocket(0, ss -> ss.setSoTimeout(30000), enableUPNP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startToAcceptOneConnection() {
        try {
            Socket plainConnection = this.serverSocket.accept();
            SSLSocket sslConnection = (SSLSocket)this.sslFactory.createSocket(plainConnection, plainConnection.getInputStream(), true);
            sslConnection.setUseClientMode(false);
            sslConnection.setNeedClientAuth(true);
            this.combox = new ComboxSecureSocket();
            this.combox.serverAccept(null, sslConnection);
        }
        catch (IOException e) {
            e.printStackTrace();
            LogWriter.writeExceptionLog(e);
        }
    }

    @Override
    public String getUrl() {
        InetAddress address = this.serverSocket.getInetAddress();
        String ip = address.getHostAddress();
        if (address.isAnyLocalAddress()) {
            ip = POPSystem.getHostIP();
        }
        return String.format("%s://%s:%d", "ssl", ip, this.serverSocket.getLocalPort());
    }

    @Override
    public void close(int connectionID) {
        super.close(connectionID);
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

