/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.mapgen;

import ch.icosys.popjava.core.mapgen.ClassReader;
import ch.icosys.popjava.core.mapgen.JARReader;
import ch.icosys.popjava.core.mapgen.ObjectMapWriter;
import ch.icosys.popjava.core.mapgen.POPCPPParclassWorker;
import java.util.ArrayList;

public class ObjectMapGenerator {
    private String file;
    private ArrayList<String> files;
    private boolean append;
    private String cwd;

    public ObjectMapGenerator(String file, ArrayList<String> files, boolean append, String cwd) {
        this.file = file;
        this.files = files;
        this.append = append;
        this.cwd = cwd;
    }

    public void generate() throws Exception {
        ObjectMapWriter omw = new ObjectMapWriter(this.file, this.append);
        for (int i = 0; i < this.files.size(); ++i) {
            String crtFile = this.files.get(i);
            if (crtFile.endsWith(".jar")) {
                JARReader jr = new JARReader(crtFile);
                ArrayList<String> parclasses = jr.getParclassFromJar();
                omw.writePOPJavaEntries(parclasses, crtFile);
                continue;
            }
            if (crtFile.endsWith(".class")) {
                ClassReader cr = new ClassReader(crtFile);
                if (!cr.isParclass()) continue;
                omw.writePOPJavaEntry(cr.getClassFullName(), cr.getCleanPath());
                continue;
            }
            if (!crtFile.endsWith(".obj") && !crtFile.endsWith(".module")) continue;
            POPCPPParclassWorker ppw = new POPCPPParclassWorker(crtFile);
            ppw.loadExecutableInfo();
            omw.writePOPCPPEntry(ppw.getParclassName(), ppw.getPath(), ppw.getArch());
        }
        omw.writeToConsole();
    }
}

