/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.deamon;

import ch.icosys.popjava.core.service.deamon.POPJavaDeamon;
import ch.icosys.popjava.core.util.Configuration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class POPJavaDeamonConnector {
    private final Socket socket;

    public POPJavaDeamonConnector(String url) throws IOException {
        this(url, Configuration.getInstance().getPopJavaDaemonPort());
    }

    public POPJavaDeamonConnector(String url, int port) throws IOException {
        this.socket = new Socket(url, port);
    }

    public boolean sendCommand(String secret, List<String> command) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        String salt = reader.readLine();
        String saltedHash = POPJavaDeamon.getSaltedHash(salt, secret);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        writer.write(saltedHash + "\n");
        writer.flush();
        String connectionStatus = reader.readLine();
        if ("ERROR PASS".equals(connectionStatus)) {
            reader.close();
            writer.close();
            return false;
        }
        reader = new BufferedReader(new InputStreamReader(new CipherInputStream(this.socket.getInputStream(), POPJavaDeamon.createKey(salt, secret, false))));
        Cipher outputCipher = POPJavaDeamon.createKey(salt, secret, true);
        CipherOutputStream outputCipherStream = new CipherOutputStream(this.socket.getOutputStream(), outputCipher);
        writer = new BufferedWriter(new OutputStreamWriter(outputCipherStream));
        writer.write(command.size() + "\n");
        for (String part : command) {
            writer.write(part + "\n");
        }
        for (int i = 0; i < 100; ++i) {
            writer.write("\n");
        }
        writer.flush();
        String answer = reader.readLine();
        System.out.println(answer);
        reader.close();
        writer.close();
        return answer != null && answer.equals("OK");
    }
}

