/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager;

import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.annotation.POPObjectDescription;
import ch.icosys.popjava.core.annotation.POPSyncSeq;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.codemanager.AppService;
import ch.icosys.popjava.core.dataswaper.POPString;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@POPClass(classId=99923)
public class POPJavaAppService
extends POPObject
implements AppService {
    private final String uuid = Util.generateUUID();
    private final Map<String, Map<String, String>> registeredCode = new HashMap<String, Map<String, String>>();

    @POPObjectDescription(url="localhost")
    public POPJavaAppService() {
    }

    @Override
    @POPSyncSeq(id=13)
    public void registerCode(String objname, String platform, String codefile) {
        Map<String, String> platf = this.registeredCode.get(platform);
        if (platf == null) {
            platf = new HashMap<String, String>();
            this.registeredCode.put(platform, platf);
        }
        platf.put(objname, codefile);
    }

    @Override
    @POPSyncSeq(id=14)
    public int queryCode(String objname, String platform, POPString codefile) {
        Map<String, String> platf = this.registeredCode.get(platform);
        String storeCodeFile = null;
        if (platf == null) {
            if (!platform.equals("*-*")) {
                if (this.registeredCode.containsKey("*-*")) {
                    storeCodeFile = this.registeredCode.get("*-*").get(objname);
                }
                if (storeCodeFile == null) {
                    LogWriter.writeDebugInfo("Platform " + platform + " not found");
                }
            } else {
                String possiblePlatform;
                Iterator<String> iterator = this.registeredCode.keySet().iterator();
                while (iterator.hasNext() && (storeCodeFile = this.registeredCode.get(possiblePlatform = iterator.next()).get(objname)) == null) {
                }
            }
        } else {
            storeCodeFile = platf.get(objname);
        }
        if (storeCodeFile == null) {
            return 0;
        }
        codefile.setValue(storeCodeFile);
        return 1;
    }

    public String getLocalJavaFileLocation(String objname) {
        return Util.getLocalJavaFileLocation(objname);
    }

    @Override
    @POPSyncSeq(id=15)
    public int getPlatform(String objname, POPString platform) {
        return 0;
    }

    @Override
    @POPSyncSeq
    public String getPOPCAppID() {
        return this.uuid;
    }
}

