/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.annotation.POPAsyncConc;
import ch.icosys.popjava.core.annotation.POPAsyncSeq;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.annotation.POPConfig;
import ch.icosys.popjava.core.annotation.POPObjectDescription;
import ch.icosys.popjava.core.annotation.POPParameter;
import ch.icosys.popjava.core.annotation.POPSyncConc;
import ch.icosys.popjava.core.annotation.POPSyncSeq;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.codemanager.AppService;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.dataswaper.POPMutableFloat;
import ch.icosys.popjava.core.dataswaper.POPString;
import ch.icosys.popjava.core.interfacebase.Interface;
import ch.icosys.popjava.core.service.jobmanager.AppResource;
import ch.icosys.popjava.core.service.jobmanager.POPJavaAppService;
import ch.icosys.popjava.core.service.jobmanager.Resource;
import ch.icosys.popjava.core.service.jobmanager.external.POPNetworkDetails;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnector;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorSearchNodeInterface;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorTFC;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetwork;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeAJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeTFC;
import ch.icosys.popjava.core.service.jobmanager.search.SNExploration;
import ch.icosys.popjava.core.service.jobmanager.search.SNNodesInfo;
import ch.icosys.popjava.core.service.jobmanager.search.SNRequest;
import ch.icosys.popjava.core.service.jobmanager.search.SNResponse;
import ch.icosys.popjava.core.service.jobmanager.search.SNWayback;
import ch.icosys.popjava.core.service.jobmanager.tfc.TFCResource;
import ch.icosys.popjava.core.service.jobmanager.yaml.PropertyReverser;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlConnector;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlJobManager;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlNetwork;
import ch.icosys.popjava.core.service.jobmanager.yaml.YamlResource;
import ch.icosys.popjava.core.serviceadapter.POPAppService;
import ch.icosys.popjava.core.serviceadapter.POPJobService;
import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.SystemUtil;
import ch.icosys.popjava.core.util.Tuple;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.KeyPairDetails;
import ch.icosys.popjava.core.util.ssl.KeyStoreDetails;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

@POPClass
public class POPJavaJobManager
extends POPJobService {
    private final Configuration conf = Configuration.getInstance();
    protected File configurationFile;
    protected final Resource available = new Resource();
    protected final Resource total = new Resource();
    protected final Resource jobLimit = new Resource();
    protected final AtomicInteger requestCounter = new AtomicInteger(1 + (int)(Math.random() * 2.147483647E9));
    protected final Map<Integer, AppResource> jobs = new HashMap<Integer, AppResource>();
    private final LinkedBlockingDeque<AppResource> cleanupJobs = new LinkedBlockingDeque();
    protected final Map<String, POPNetwork> networks = new HashMap<String, POPNetwork>();
    protected String defaultNetwork = null;
    protected int maxJobs;
    protected final Map<String, List<String>> nodeExtra = new HashMap<String, List<String>>();
    protected final ReentrantLock mutex = new ReentrantLock(true);
    protected final String nodeId = Util.generateUUID();
    private long nextUpdate = 0L;
    private long nextSelfRegister = 0L;
    private final Semaphore stayAlive = new Semaphore(0);
    private final Map<Tuple<String, POPAccessPoint>, POPJavaJobManager> cachedJobManangers = Collections.synchronizedMap(new HashMap());
    private final LinkedBlockingDeque<String> SNKnownRequests = new LinkedBlockingDeque(this.conf.getSearchNodeMaxRequests());
    private final Map<String, SNNodesInfo> SNActualRequets = new HashMap<String, SNNodesInfo>();
    private final Map<String, Semaphore> SNRequestSemaphore = new HashMap<String, Semaphore>();

    @POPObjectDescription(url="localhost", jvmParameters="-Xmx512m")
    public POPJavaJobManager() {
        this.configurationFile = this.conf.getSystemJobManagerConfig();
    }

    @POPObjectDescription(jvmParameters="-Xmx512m")
    public POPJavaJobManager(@POPConfig(value=POPConfig.Type.URL) String url) {
        this.configurationFile = this.conf.getSystemJobManagerConfig();
        this.init(this.conf.getSystemJobManagerConfig());
    }

    @POPObjectDescription(jvmParameters="-Xmx512m")
    public POPJavaJobManager(@POPConfig(value=POPConfig.Type.URL) String url, @POPConfig(value=POPConfig.Type.PROTOCOLS) String[] protocols) {
        this.configurationFile = this.conf.getSystemJobManagerConfig();
        this.init(this.conf.getSystemJobManagerConfig());
    }

    @POPObjectDescription(jvmParameters="-Xmx512m")
    public POPJavaJobManager(@POPConfig(value=POPConfig.Type.URL) String url, @POPConfig(value=POPConfig.Type.PROTOCOLS) String[] protocols, String conf) {
        this.configurationFile = new File(conf);
        this.init(this.configurationFile);
    }

    @POPObjectDescription(jvmParameters="-Xmx512m")
    public POPJavaJobManager(@POPConfig(value=POPConfig.Type.URL) String url, @POPConfig(value=POPConfig.Type.PROTOCOLS) String[] protocols, String conf, @POPConfig(value=POPConfig.Type.LOCAL_JVM) boolean localJVM, @POPConfig(value=POPConfig.Type.UPNP) boolean upnp) {
        this.configurationFile = new File(conf);
        this.init(this.configurationFile);
    }

    @POPObjectDescription(jvmParameters="-Xmx512m")
    public POPJavaJobManager(@POPConfig(value=POPConfig.Type.URL) String url, String conf) {
        this.configurationFile = new File(conf);
        this.init(this.configurationFile);
    }

    private void init(File configFile) {
        YamlResource jobResources;
        YamlJobManager config;
        if (!configFile.exists()) {
            LogWriter.writeDebugInfo("[JM] Open config file [%s] fail, trying to create", configFile);
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                LogWriter.writeDebugInfo("[JM] can't create job manager file %s", configFile);
            }
        }
        LogWriter.writeDebugInfo("[JM] Using %s as config file", configFile.getAbsoluteFile().toString());
        this.maxJobs = 200;
        this.available.add(new Resource(30000.0f, 8192.0f, 102400.0f));
        this.jobLimit.add(this.available);
        this.total.add(this.available);
        Yaml yaml = new Yaml();
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            config = (YamlJobManager)yaml.loadAs((Reader)br, YamlJobManager.class);
        }
        catch (IOException e) {
            LogWriter.writeExceptionLog(e);
            throw new POPException(0, e.getMessage());
        }
        if (config == null) {
            return;
        }
        this.maxJobs = config.getJobLimit() > 0 ? config.getJobLimit() : this.maxJobs;
        this.defaultNetwork = config.getDefaultNetwork();
        YamlResource machineResources = config.getMachineResources();
        if (machineResources != null && machineResources.getFlops() > 0.0f) {
            this.available.setFlops(machineResources.getFlops());
            this.total.setFlops(machineResources.getFlops());
            LogWriter.writeDebugInfo("[JM] setting maximim flops to [%f]", Float.valueOf(machineResources.getFlops()));
        }
        if (machineResources != null && machineResources.getBandwidth() > 0.0f) {
            this.available.setBandwidth(machineResources.getBandwidth());
            this.total.setBandwidth(machineResources.getBandwidth());
            LogWriter.writeDebugInfo("[JM] setting maximim bandwidth to [%f]", Float.valueOf(machineResources.getBandwidth()));
        }
        if (machineResources != null && machineResources.getMemory() > 0.0f) {
            this.available.setMemory(machineResources.getMemory());
            this.total.setMemory(machineResources.getMemory());
            LogWriter.writeDebugInfo("[JM] setting maximim memory to [%f]", Float.valueOf(machineResources.getMemory()));
        }
        if ((jobResources = config.getJobResources()) != null && jobResources.getFlops() > 0.0f) {
            this.jobLimit.setFlops(jobResources.getFlops());
            LogWriter.writeDebugInfo("[JM] setting job limit flops to [%f]", Float.valueOf(jobResources.getFlops()));
        }
        if (jobResources != null && jobResources.getBandwidth() > 0.0f) {
            this.jobLimit.setBandwidth(jobResources.getBandwidth());
            LogWriter.writeDebugInfo("[JM] setting job limit bandwidth to [%f]", Float.valueOf(jobResources.getBandwidth()));
        }
        if (jobResources != null && jobResources.getMemory() > 0.0f) {
            this.jobLimit.setMemory(jobResources.getMemory());
            LogWriter.writeDebugInfo("[JM] setting job limit memory to [%f]", Float.valueOf(jobResources.getMemory()));
        }
        for (YamlNetwork ymlNetwork : config.getNetworks()) {
            String uuid = ymlNetwork.getUuid();
            String friendlyName = ymlNetwork.getFriendlyName();
            if (this.defaultNetwork == null) {
                this.defaultNetwork = uuid;
            }
            POPNetwork network = new POPNetwork(uuid, friendlyName, this);
            this.networks.put(uuid, network);
            LogWriter.writeDebugInfo("[JM] added network [%s] (%s)", friendlyName, uuid);
            for (YamlConnector ymlConnector : ymlNetwork.getConnectors()) {
                String connectorType = ymlConnector.getType();
                POPNetworkDescriptor descriptor = POPNetworkDescriptor.from(connectorType);
                if (descriptor == null) {
                    LogWriter.writeDebugInfo("[JM] couldn't find implementation of [%s] POPConnector", connectorType);
                    continue;
                }
                for (List<String> listNode : ymlConnector.asPOPNodeParams()) {
                    POPNode node = descriptor.createNode(listNode);
                    network.add(node);
                    LogWriter.writeDebugInfo("[JM] node [%s] added to [%s] (%s)", node.toString(), friendlyName, uuid);
                }
            }
        }
    }

    @Override
    @POPSyncConc(id=12)
    public int createObject(POPAccessPoint localservice, String objname, @POPParameter(value=POPParameter.Direction.IN) ObjectDescription od, int howmany, POPAccessPoint[] objcontacts, int howmany2, POPAccessPoint[] remotejobcontacts) {
        try {
            POPNetwork network;
            if (howmany <= 0) {
                return 0;
            }
            String networkString = od.getNetwork();
            if (networkString.isEmpty()) {
                networkString = this.defaultNetwork;
                od.setNetwork(networkString);
            }
            if ((network = this.networks.get(networkString)) == null) {
                throw new POPException(10009, networkString + " not found.");
            }
            POPNetworkDescriptor connector = null;
            try {
                connector = POPNetworkDescriptor.from(od.getConnector());
            }
            catch (IllegalArgumentException e) {
                throw new POPException(10009, od.getConnector() + " in " + networkString + " unknown.");
            }
            Object connectorImpl = network.getConnector(connector);
            if (connectorImpl == null) {
                throw new POPException(10009, od.getConnector() + " in " + networkString + " not found.");
            }
            return ((POPConnector)connectorImpl).createObject(localservice, objname, od, howmany, objcontacts, howmany2, remotejobcontacts);
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo(String.format("[JM] Exception caught in createObject: %s", e.getMessage()));
            throw e;
        }
    }

    @POPSyncConc
    public int execObj(@POPParameter(value=POPParameter.Direction.IN) POPString objname, int howmany, int[] reserveIDs, String localservice, POPAccessPoint[] objcontacts) {
        try {
            if (howmany < 0) {
                return 1;
            }
            List<AppResource> reservations = this.verifyReservation(reserveIDs);
            if (reservations == null) {
                this.cancelReservation(reserveIDs, howmany);
                return -1;
            }
            boolean status = true;
            try {
                for (int i = 0; i < howmany; ++i) {
                    AppService service;
                    AppResource res = reservations.get(i);
                    res.setAppService(new POPAccessPoint(localservice));
                    ObjectDescription od = new ObjectDescription();
                    od.merge(res.getOd());
                    res.addTo(od);
                    od.setHostname("localhost");
                    String hostuser = this.conf.getJobmanagerExecutionUser();
                    od.setHostuser(hostuser);
                    POPString codeFile = new POPString();
                    String appId = "unknown";
                    try {
                        service = PopJava.newActiveConnect(this, POPJavaAppService.class, res.getAppService());
                        service.queryCode(objname.getValue(), POPSystem.getPlatform(), codeFile);
                        appId = service.getPOPCAppID();
                        service.exit();
                    }
                    catch (POPException e) {
                        service = PopJava.newActiveConnect(this, POPAppService.class, res.getAppService());
                        service.queryCode(objname.getValue(), POPSystem.getPlatform(), codeFile);
                        appId = service.getPOPCAppID();
                        service.exit();
                    }
                    Path objectAppCwd = Paths.get(this.conf.getJobManagerExecutionBaseDirectory(), appId).toAbsolutePath();
                    SystemUtil.mkdir(objectAppCwd, hostuser);
                    for (int j = 0; !Files.exists(objectAppCwd, new LinkOption[0]) && j < 20; ++j) {
                        Thread.sleep(10L);
                    }
                    od.setDirectory(objectAppCwd.toString());
                    res.setAppDirectory(objectAppCwd);
                    String[] args = codeFile.getValue().split(" ");
                    String jarLocation = POPJavaConfiguration.getPopJavaJar();
                    for (int j = 0; j < args.length; ++j) {
                        if (args[j].startsWith("-javaagent:")) {
                            args[j] = "-javaagent:" + jarLocation;
                            continue;
                        }
                        if (!args[j].equals("-cp")) continue;
                        args[j + 1] = jarLocation;
                    }
                    od.setCodeFile(Util.join(" ", args));
                    od.setOriginAppService(res.getAppService());
                    status |= Interface.tryLocal(objname.getValue(), objcontacts[i], od);
                    res.setContact(objcontacts[i]);
                    res.setAccessTime(System.currentTimeMillis());
                }
            }
            catch (Throwable e) {
                LogWriter.writeExceptionLog(e);
                status = false;
                this.cancelReservation(reserveIDs, howmany);
            }
            return status ? 0 : -1;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo(String.format("[JM] Exception caught in createObject: %s", e.getMessage()));
            throw e;
        }
    }

    private List<AppResource> verifyReservation(int[] ids) {
        ArrayList<AppResource> reservations = new ArrayList<AppResource>();
        for (int id : ids) {
            AppResource app = this.jobs.get(id);
            if (app == null) {
                return null;
            }
            if (app.isUsed()) {
                return null;
            }
            app.setAccessTime(System.currentTimeMillis());
            app.setUsed(true);
            reservations.add(app);
        }
        return reservations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POPSyncConc(id=16)
    public int reserve(@POPParameter(value=POPParameter.Direction.IN) ObjectDescription od, @POPParameter(value=POPParameter.Direction.INOUT) POPMutableFloat iofitness, String popAppId, String reqID) {
        if (this.jobs.size() >= this.maxJobs) {
            return 0;
        }
        Resource weighted = new Resource();
        float fitness = 1.0f;
        try {
            this.mutex.lock();
            if (!od.isEmpty()) {
                iofitness.setValue(fitness);
            }
            AppResource app = new AppResource();
            app.setId(this.requestCounter.incrementAndGet());
            app.add(weighted);
            app.setAppId(popAppId);
            app.setReqId(reqID);
            app.setOd(od);
            app.setAccessTime(System.currentTimeMillis());
            this.jobs.put(app.getId(), app);
            this.available.subtract(app);
            LogWriter.writeDebugInfo(String.format("[JM] Reserved [%s] resources", app));
            int n = app.getId();
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POPAsyncSeq
    public void cancelReservation(@POPParameter(value=POPParameter.Direction.IN) int[] req, int howmany) {
        try {
            this.mutex.lock();
            for (int reqId : req) {
                AppResource resource = this.jobs.remove(reqId);
                if (resource == null) continue;
                this.available.add(resource);
                LogWriter.writeDebugInfo(String.format("[JM] Free up [%s] resources (cancellation).", resource));
            }
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo(String.format("[JM] Exception caught in cancelReservation: %s", e.getMessage()));
        }
        finally {
            this.mutex.unlock();
        }
    }

    @POPAsyncSeq(localhost=true)
    public void dump() {
        String location232;
        String f;
        File dumpFile;
        int idx = 0;
        do {
            if ((location232 = System.getenv("POPJAVA_LOCATION")) != null) continue;
            location232 = ".";
        } while ((dumpFile = new File(f = String.format("%s/dump/JobMgr.%d.dump", location232, idx++))).exists());
        try {
            dumpFile.createNewFile();
        }
        catch (IOException location232) {
            // empty catch block
        }
        if (!dumpFile.canWrite()) {
            LogWriter.writeDebugInfo("[JM] No writable dump location found");
            return;
        }
        try (PrintStream out = new PrintStream(dumpFile);){
            out.println("[networks]");
            for (Map.Entry<String, POPNetwork> entry : this.networks.entrySet()) {
                POPNetwork net = entry.getValue();
                Object[] connectors = net.getConnectors();
                out.println(String.format("[%s]", net.getUUID()));
                out.println(String.format("connectors=%s", Arrays.toString(connectors)));
                out.println(String.format("members=%d", net.size()));
                for (Object connector : connectors) {
                    out.println(String.format("[%s.%s]", net.getUUID(), connector.getClass().getCanonicalName()));
                    for (POPNode node : net.getMembers(((POPConnector)connector).getDescriptor())) {
                        out.println(String.format("node=%s", node.toString()));
                    }
                }
            }
            out.println("[config]");
            out.println(String.format("available power=%f", Float.valueOf(this.available.getFlops())));
            out.println(String.format("available memory=%f", Float.valueOf(this.available.getMemory())));
            out.println(String.format("available bandwidth=%f", Float.valueOf(this.available.getBandwidth())));
            out.println(String.format("total power=%f", Float.valueOf(this.total.getFlops())));
            out.println(String.format("total memory=%f", Float.valueOf(this.total.getMemory())));
            out.println(String.format("total bandwidth=%f", Float.valueOf(this.total.getBandwidth())));
            out.println(String.format("job limit power=%f", Float.valueOf(this.jobLimit.getFlops())));
            out.println(String.format("job limit memory=%f", Float.valueOf(this.jobLimit.getMemory())));
            out.println(String.format("job limit bandwidth=%f", Float.valueOf(this.jobLimit.getBandwidth())));
            out.println(String.format("max jobs=%d", this.maxJobs));
            out.println("[extra]");
            for (Map.Entry<String, Object> entry : this.nodeExtra.entrySet()) {
                String k = entry.getKey();
                List v = (List)entry.getValue();
                out.println(String.format("%s=%s", k, v));
            }
        }
        catch (IOException e) {
            LogWriter.writeDebugInfo("[JM] IO Error while dumping JobManager");
        }
    }

    @Override
    @POPAsyncConc(localhost=true)
    public void start() {
        while (true) {
            try {
                while (true) {
                    this.selfRegister();
                    this.update();
                    this.cleanup();
                    Thread.sleep(this.conf.getJobManagerUpdateInterval());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @POPSyncConc
    public boolean query(String type, @POPParameter(value=POPParameter.Direction.INOUT) POPString value) {
        switch (type) {
            case "platform": {
                value.setValue(POPSystem.getPlatform());
                return true;
            }
            case "host": {
                value.setValue(POPSystem.getHostIP());
                return true;
            }
            case "jobs": {
                this.update();
                value.setValue(String.format("%d/%d", this.jobs.size(), this.maxJobs));
                return true;
            }
            case "joblist": {
                this.update();
                HashSet<AppResource> apps = new HashSet<AppResource>(this.jobs.values());
                StringBuilder sb = new StringBuilder();
                for (AppResource app : apps) {
                    if (app.getContact().isEmpty() || app.getAppService().isEmpty()) continue;
                    sb.append(String.format("APP=%s/JOB=%s\n", app.getAppService().toString(), app.getContact().toString()));
                }
                value.setValue(sb.toString());
                return true;
            }
            case "pausejobs": {
                return false;
            }
            case "neighbors": {
                return false;
            }
            case "networks": {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, POPNetwork> entry : this.networks.entrySet()) {
                    String k = entry.getKey();
                    POPNetwork v = entry.getValue();
                    sb.append(String.format("%s=%s\n", k, v.size()));
                }
                value.setValue(sb.toString().trim());
                return true;
            }
            case "power_available": 
            case "power": {
                this.update();
                value.setValue(String.valueOf(this.available.getFlops()));
                return true;
            }
        }
        List<String> vals = this.nodeExtra.get(type);
        if (vals == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : vals) {
            sb.append(s).append("\n");
        }
        value.setValue(sb.toString().trim());
        return true;
    }

    @POPSyncSeq(localhost=true)
    public void changeAvailablePower(float limit) {
        Resource diff = new Resource(this.total);
        diff.setFlops(limit);
        diff.subtract(this.total);
        this.total.setFlops(limit);
        this.available.add(diff);
        this.writeConfigurationFile();
    }

    @POPSyncSeq(localhost=true)
    public void changeAvailableMemory(float limit) {
        Resource diff = new Resource(this.total);
        diff.setMemory(limit);
        diff.subtract(this.total);
        this.total.setMemory(limit);
        this.available.add(diff);
        this.writeConfigurationFile();
    }

    @POPSyncSeq(localhost=true)
    public void changeAvailableBandwidth(float limit) {
        Resource diff = new Resource(this.total);
        diff.setBandwidth(limit);
        diff.subtract(this.total);
        this.total.setBandwidth(limit);
        this.available.add(diff);
        this.writeConfigurationFile();
    }

    @POPSyncSeq(localhost=true)
    public void changeMaxJobLimit(int limit) {
        this.maxJobs = limit;
        this.writeConfigurationFile();
    }

    @POPSyncSeq(localhost=true)
    public void changeMaxJobPower(float limit) {
        this.jobLimit.setFlops(limit);
        this.writeConfigurationFile();
    }

    @POPSyncSeq(localhost=true)
    public void changeMaxJobMemory(float limit) {
        this.jobLimit.setMemory(limit);
        this.writeConfigurationFile();
    }

    @POPSyncSeq(localhost=true)
    public void changeMaxJobBandwidth(float limit) {
        this.jobLimit.setBandwidth(limit);
        this.writeConfigurationFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POPAsyncConc
    protected void selfRegister() {
        if (this.nextSelfRegister > System.currentTimeMillis()) {
            return;
        }
        try {
            Collection<POPNetwork> nets = this.networks.values();
            for (POPNetwork network : nets) {
                POPConnector[] connectors;
                for (POPConnector connector : connectors = network.getConnectors()) {
                    POPConnectorSearchNodeInterface jmConnector;
                    if (!(connector instanceof POPConnectorSearchNodeInterface) || !(jmConnector = (POPConnectorSearchNodeInterface)((Object)connector)).broadcastPresence()) continue;
                    List<POPNode> nodes = network.getMembers(connector.getDescriptor());
                    for (POPNode node : nodes) {
                        if (!(node instanceof POPNodeAJobManager)) continue;
                        POPNodeAJobManager jmnode = (POPNodeAJobManager)node;
                        this.registerRemoteAsync(network.getUUID(), jmnode);
                    }
                }
            }
        }
        finally {
            this.nextSelfRegister = System.currentTimeMillis() + (long)this.conf.getJobManagerSelfRegisterInterval();
        }
    }

    @POPAsyncConc
    protected void selfUnregister() {
    }

    @POPAsyncConc
    private void registerRemoteAsync(String networkUUID, POPNodeAJobManager node) {
    }

    @POPSyncConc(localhost=true)
    public POPNetworkDetails createNetwork(String friendlyName) {
        try {
            POPNetwork network = new POPNetwork(friendlyName, this);
            LogWriter.writeDebugInfo("[JM] Network %s added", friendlyName);
            this.networks.put(network.getUUID(), network);
            KeyStoreDetails keyStoreDetails = this.conf.getSSLKeyStoreOptions();
            if (keyStoreDetails.getKeyStoreFile() != null) {
                try {
                    KeyPairDetails keyPairDetails = new KeyPairDetails(network.getUUID());
                    KeyStore.PrivateKeyEntry generateKeyPair = SSLUtils.ensureKeyPairGeneration(keyPairDetails);
                    SSLUtils.addKeyEntryToKeyStore(keyStoreDetails, keyPairDetails, generateKeyPair);
                }
                catch (Exception e) {
                    LogWriter.writeDebugInfo("[JM] Failed to generate Key add it to KeyStore with message: %s", e.getMessage());
                }
            }
            POPNetworkDetails d = new POPNetworkDetails(network);
            if (this.defaultNetwork == null || this.defaultNetwork.isEmpty()) {
                this.defaultNetwork = d.getUUID();
            }
            this.writeConfigurationFile();
            return d;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[JM] Exception caught in createNetwork: %s", e.getMessage());
            LogWriter.writeExceptionLog(e);
            return null;
        }
    }

    @POPSyncConc(localhost=true)
    public POPNetworkDetails createNetwork(String networkUUID, String friendlyName) {
        try {
            POPNetwork network = this.networks.get(networkUUID);
            if (network != null) {
                return new POPNetworkDetails(network);
            }
            POPNetwork newNetwork = new POPNetwork(networkUUID, friendlyName, this);
            LogWriter.writeDebugInfo("[JM] Network %s added", friendlyName);
            this.networks.put(newNetwork.getUUID(), newNetwork);
            KeyStoreDetails keyStoreDetails = this.conf.getSSLKeyStoreOptions();
            if (keyStoreDetails.getKeyStoreFile() != null) {
                try {
                    KeyPairDetails keyPairDetails = new KeyPairDetails(newNetwork.getUUID());
                    KeyStore.PrivateKeyEntry generateKeyPair = SSLUtils.ensureKeyPairGeneration(keyPairDetails);
                    SSLUtils.addKeyEntryToKeyStore(keyStoreDetails, keyPairDetails, generateKeyPair);
                }
                catch (Exception e) {
                    LogWriter.writeDebugInfo("[JM] Failed to generate Key add it to KeyStore with message: %s", e.getMessage());
                }
            }
            POPNetworkDetails d = new POPNetworkDetails(newNetwork);
            if (this.defaultNetwork == null || this.defaultNetwork.isEmpty()) {
                this.defaultNetwork = d.getUUID();
            }
            this.writeConfigurationFile();
            return d;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[JM] Exception caught in createNetwork: %s", e.getMessage());
            LogWriter.writeExceptionLog(e);
            return null;
        }
    }

    @POPAsyncConc(localhost=true)
    public void removeNetwork(String networkUUID) {
        if (!this.networks.containsKey(networkUUID)) {
            LogWriter.writeDebugInfo("[JM] Network %s not removed, not found", networkUUID);
            return;
        }
        POPNetwork network = this.networks.get(networkUUID);
        for (POPConnector connector : network.getConnectors()) {
            ArrayList<POPNode> copy = new ArrayList<POPNode>(network.getMembers(connector.getDescriptor()));
            for (POPNode member : copy) {
                this.unregisterNode(networkUUID, member.getCreationParams());
            }
        }
        try {
            SSLUtils.removeAlias(networkUUID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LogWriter.writeDebugInfo("[JM] Network %s removed", networkUUID);
        this.networks.remove(networkUUID);
        this.writeConfigurationFile();
    }

    @POPSyncConc
    public void registerNode(String networkUUID, String ... params) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            LogWriter.writeDebugInfo("[JM] Node %s not registered, network %s not found", Arrays.toString(params), networkUUID);
            return;
        }
        ArrayList<String> listparams = new ArrayList<String>(Arrays.asList(params));
        String connector = Util.removeStringFromList(listparams, "connector=");
        POPNode node = POPNetworkDescriptor.from(connector).createNode(listparams);
        node.setTemporary(true);
        network.add(node);
        LogWriter.writeDebugInfo("[JM] Node %s added to %s", Arrays.toString(params), networkUUID);
    }

    @POPAsyncConc
    public void unregisterNode(String networkUUID, String ... params) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            LogWriter.writeDebugInfo("[JM] Node %s not removed, network not found", Arrays.toString(params));
            return;
        }
        ArrayList<String> listparams = new ArrayList<String>(Arrays.asList(params));
        String connector = Util.removeStringFromList(listparams, "connector=");
        POPNode node = POPNetworkDescriptor.from(connector).createNode(listparams);
        network.remove(node);
        try {
            SSLUtils.removeConfidenceLink(node, networkUUID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogWriter.writeDebugInfo("[JM] Node %s removed", Arrays.toString(params));
    }

    @POPSyncConc
    public void registerNode(String ... params) {
        this.registerNode(this.defaultNetwork, params);
    }

    @POPAsyncConc
    public void unregisterNode(String ... params) {
        this.unregisterNode(this.defaultNetwork, params);
    }

    @POPSyncConc(localhost=true)
    public void registerPermanentNode(String networkUUID, String ... params) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            LogWriter.writeDebugInfo("[JM] Node %s not registered, network %s not found", Arrays.toString(params), networkUUID);
            return;
        }
        ArrayList<String> listparams = new ArrayList<String>(Arrays.asList(params));
        String connector = Util.removeStringFromList(listparams, "connector=");
        network.add(POPNetworkDescriptor.from(connector).createNode(listparams));
        this.writeConfigurationFile();
        LogWriter.writeDebugInfo("[JM] Node %s added to %s", Arrays.toString(params), network);
    }

    @POPSyncConc(localhost=true)
    public void registerPermanentNode(String networkUUID, byte[] certificate, String ... params) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            LogWriter.writeDebugInfo("[JM] Node %s not registered, network %s not found", Arrays.toString(params), networkUUID);
            return;
        }
        ArrayList<String> listparams = new ArrayList<String>(Arrays.asList(params));
        String connector = Util.removeStringFromList(listparams, "connector=");
        POPNode node = POPNetworkDescriptor.from(connector).createNode(listparams);
        try {
            SSLUtils.addConfidenceLink(node, SSLUtils.certificateFromBytes(certificate), networkUUID);
        }
        catch (Exception e) {
            throw new POPException(20, "Job Manager couldn't add certificate to Key Store");
        }
        network.add(node);
        this.writeConfigurationFile();
        LogWriter.writeDebugInfo("[JM] Node %s added to %s", Arrays.toString(params), network);
    }

    @POPSyncConc(localhost=true)
    public void unregisterPermanentNode(String networkUUID, String ... params) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            LogWriter.writeDebugInfo("[JM] Node %s not removed, network not found", Arrays.toString(params));
            return;
        }
        ArrayList<String> listparams = new ArrayList<String>(Arrays.asList(params));
        String connector = Util.removeStringFromList(listparams, "connector=");
        POPNode node = POPNetworkDescriptor.from(connector).createNode(listparams);
        try {
            SSLUtils.removeConfidenceLink(node, networkUUID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        network.remove(node);
        LogWriter.writeDebugInfo("[JM] Node %s removed", Arrays.toString(params));
        this.writeConfigurationFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POPAsyncConc(localhost=true)
    public void update() {
        if (this.nextUpdate > System.currentTimeMillis()) {
            return;
        }
        try {
            this.mutex.lock();
            long updateInterval = this.conf.getJobManagerUpdateInterval();
            Iterator<AppResource> iterator = this.jobs.values().iterator();
            while (iterator.hasNext()) {
                AppResource job = iterator.next();
                if (!job.isUsed()) {
                    if (job.getAccessTime() + (long)this.conf.getReserveTimeout() <= System.currentTimeMillis()) continue;
                    this.available.add(job);
                    iterator.remove();
                    LogWriter.writeDebugInfo("[JM] Free up [%s] resources (unused).", job);
                    continue;
                }
                if (job.getAccessTime() >= System.currentTimeMillis() - updateInterval) continue;
                job.setAccessTime(System.currentTimeMillis());
                try {
                    Interface obj = new Interface(null, job.getContact());
                    obj.close();
                }
                catch (Exception e) {
                    this.available.add(job);
                    iterator.remove();
                    this.cleanupJobs.add(job);
                    LogWriter.writeDebugInfo("[JM] Free up [%s] resources (dead object).", job);
                }
            }
        }
        finally {
            this.nextUpdate = System.currentTimeMillis() + (long)this.conf.getJobManagerUpdateInterval();
            this.mutex.unlock();
        }
    }

    @POPSyncConc(localhost=true)
    public Resource getAvailableResources() {
        return new Resource(this.available);
    }

    @POPSyncConc(localhost=true)
    public Resource getInitialAvailableResources() {
        return new Resource(this.total);
    }

    @POPSyncConc(localhost=true)
    public Resource getJobResourcesLimit() {
        return new Resource(this.jobLimit);
    }

    @POPSyncConc(localhost=true)
    public int getMaxJobs() {
        return this.maxJobs;
    }

    @POPSyncConc
    public String getNodeId() {
        return this.nodeId;
    }

    @POPAsyncConc
    public void applicationEnd(int popAppId, boolean initiator) {
        IPOPBase r;
        AppResource res = this.jobs.get(popAppId);
        if (initiator && res != null) {
            r = new SNRequest(Util.generateUUID(), null, null, res.getOd().getNetwork(), res.getOd().getConnector(), null);
            ((SNRequest)r).setAsEndRequest();
            ((SNRequest)r).setPOPAppId(popAppId);
            this.launchDiscovery((SNRequest)r, 1);
        }
        if ((r = (Resource)this.jobs.remove(popAppId)) != null) {
            this.available.add((Resource)r);
        }
    }

    private void writeConfigurationFile() {
        try {
            if (!this.configurationFile.exists()) {
                this.configurationFile.createNewFile();
            }
            YamlJobManager yamlJobManager = new YamlJobManager();
            yamlJobManager.setDefaultNetwork(this.defaultNetwork);
            yamlJobManager.setJobLimit(this.maxJobs);
            yamlJobManager.setMachineResources(this.total.toYamlResource());
            yamlJobManager.setJobResources(this.jobLimit.toYamlResource());
            ArrayList<YamlNetwork> yamlNetworks = new ArrayList<YamlNetwork>(this.networks.size());
            yamlJobManager.setNetworks(yamlNetworks);
            for (POPNetwork network : this.networks.values()) {
                yamlNetworks.add(network.toYamlResource());
            }
            Representer representer = new Representer();
            representer.setPropertyUtils((PropertyUtils)new PropertyReverser());
            Yaml yaml = new Yaml(representer);
            String output = yaml.dumpAs((Object)yamlJobManager, Tag.MAP, DumperOptions.FlowStyle.AUTO);
            try (FileOutputStream fos = new FileOutputStream(this.configurationFile);){
                fos.write(output.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            LogWriter.writeDebugInfo("[JM] Failed to write current configuration to disk");
        }
    }

    @POPAsyncSeq
    protected void cleanup() {
        Iterator<AppResource> iterator = this.cleanupJobs.iterator();
        while (iterator.hasNext()) {
            AppResource job = iterator.next();
            Path appDirectory = job.getAppDirectory();
            if (appDirectory == null || !Files.exists(appDirectory, new LinkOption[0]) || appDirectory.toFile().list().length != 0) continue;
            SystemUtil.rmdir(appDirectory, this.conf.getJobmanagerExecutionUser());
            if (Files.exists(appDirectory, new LinkOption[0])) continue;
            iterator.remove();
        }
    }

    @POPAsyncConc(localhost=true)
    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = new File(configurationFile);
        this.writeConfigurationFile();
    }

    @POPSyncConc(localhost=true)
    public POPNetworkDetails[] getAvailableNetworks() {
        ArrayList<POPNetwork> nets = new ArrayList<POPNetwork>(this.networks.values());
        int size = nets.size();
        POPNetworkDetails[] netsDetails = new POPNetworkDetails[size];
        int i = 0;
        for (POPNetwork net : nets) {
            netsDetails[i++] = new POPNetworkDetails(net);
        }
        return netsDetails;
    }

    @POPSyncConc(localhost=true)
    public String[][] getNetworkNodes(String networkUUID) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            return new String[0][0];
        }
        String[][] nodes = new String[network.size()][];
        int i = 0;
        for (POPConnector connector : network.getConnectors()) {
            for (POPNode node : network.getMembers(connector.getDescriptor())) {
                nodes[i++] = node.getCreationParams();
            }
        }
        return nodes;
    }

    @POPSyncConc(localhost=true)
    public void stayAlive() {
        this.stayAlive.acquireUninterruptibly();
    }

    @Override
    protected void finalize() throws Throwable {
        this.stayAlive.release(Integer.MAX_VALUE);
        super.finalize();
    }

    @POPSyncConc(localhost=true)
    public boolean registerTFCObject(String networkUUID, String objectName, POPAccessPoint accessPoint, String secret) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            return false;
        }
        POPConnectorTFC tfc = (POPConnectorTFC)network.getConnector(POPNetworkDescriptor.from("tfc"));
        if (tfc == null) {
            AccessPoint myself = this.getAccessPoint().get(0);
            String protocol = myself.getProtocol();
            int port = myself.getPort();
            POPNodeTFC newNode = new POPNodeTFC("localhost", port, protocol);
            this.registerNode(networkUUID, newNode.getCreationParams());
            this.writeConfigurationFile();
            tfc = (POPConnectorTFC)network.getConnector(POPNetworkDescriptor.from("tfc"));
        }
        TFCResource resource = new TFCResource(objectName, accessPoint, secret);
        return tfc.registerObject(resource);
    }

    @POPSyncConc(localhost=true)
    public void unregisterTFCObject(String networkUUID, String objectName, POPAccessPoint accessPoint, String secret) {
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            return;
        }
        POPConnectorTFC tfc = (POPConnectorTFC)network.getConnector(POPNetworkDescriptor.from("tfc"));
        if (tfc == null) {
            return;
        }
        TFCResource resource = new TFCResource(objectName, accessPoint, secret);
        tfc.unregisterObject(resource);
    }

    @POPSyncConc
    public POPAccessPoint[] localTFCSearch(String networkUUID, String objectName) {
        List<TFCResource> resources;
        POPAccessPoint[] aps = new POPAccessPoint[]{};
        POPNetwork network = this.networks.get(networkUUID);
        if (network == null) {
            return aps;
        }
        POPConnectorTFC tfc = (POPConnectorTFC)network.getConnector(POPNetworkDescriptor.from("tfc"));
        if (tfc == null) {
            return aps;
        }
        POPRemoteCaller remote = PopJava.getRemoteCaller();
        Certificate cert = null;
        if (remote.isSecure() && !remote.isUsingConfidenceLink()) {
            cert = SSLUtils.getCertificate(remote.getFingerprint());
        }
        if ((resources = tfc.getObjects(objectName, cert)) == null || resources.isEmpty()) {
            return aps;
        }
        aps = new POPAccessPoint[resources.size()];
        for (int i = 0; i < aps.length; ++i) {
            aps[i] = resources.get(i).getAccessPoint();
        }
        return aps;
    }

    @POPSyncConc(localhost=true)
    public SNNodesInfo launchDiscovery(final @POPParameter(value=POPParameter.Direction.IN) SNRequest request, int timeout) {
        try {
            LogWriter.writeDebugInfo("[PSN] starting research");
            request.getExplorationList().add(this.getAccessPoint());
            if (request.isEndRequest()) {
                timeout = 1;
            } else {
                LogWriter.writeDebugInfo("[PSN] LDISCOVERY;TIMEOUT;%d", timeout);
            }
            SNNodesInfo infos = new SNNodesInfo();
            this.SNActualRequets.put(request.getUID(), infos);
            if (timeout > 0) {
                POPAccessPoint sender = new POPAccessPoint();
                this.askResourcesDiscovery(request, sender);
                Thread.sleep(timeout);
            } else {
                Semaphore reqsem = new Semaphore(0);
                this.SNRequestSemaphore.put(request.getUID(), reqsem);
                POPAccessPoint sender = new POPAccessPoint();
                this.askResourcesDiscovery(request, sender);
                Thread SNunlock = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(POPJavaJobManager.this.conf.getSearchNodeUnlockTimeout());
                            POPJavaJobManager.this.unlockDiscovery(request.getUID());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }, "SearchNode auto-unlock timer");
                SNunlock.setDaemon(true);
                SNunlock.start();
                reqsem.acquireUninterruptibly();
                this.SNRequestSemaphore.remove(request.getUID());
            }
            SNNodesInfo results = this.SNActualRequets.get(request.getUID());
            this.SNActualRequets.remove(request.getUID());
            return results;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[PSN] Exception caught in launchDiscovery: %s", e.getMessage());
            LogWriter.writeExceptionLog(e);
            return new SNNodesInfo();
        }
    }

    @POPAsyncSeq
    public void askResourcesDiscovery(@POPParameter(value=POPParameter.Direction.IN) SNRequest request, @POPParameter(value=POPParameter.Direction.IN) POPAccessPoint sender) {
        try {
            boolean answer;
            String[] jmNode;
            SNExploration explorationList = request.getExplorationList();
            SNExploration oldExplorationList = new SNExploration(request.getExplorationList());
            POPNetwork network = this.networks.get(request.getNetworkUUID());
            if (network == null) {
                LogWriter.writeDebugInfo("[JM] Network [%s] not found", request.getNetworkUUID());
                return;
            }
            if (request.getRemainingHops() != this.conf.getSearchNodeUnlimitedHops()) {
                request.decreaseHopLimit();
            }
            POPNetworkDescriptor descriptor = null;
            try {
                descriptor = POPNetworkDescriptor.from(request.getConnector());
            }
            catch (IllegalArgumentException e) {
                LogWriter.writeDebugInfo("[JM] Connector descriptor [%s] not found", request.getConnector());
                return;
            }
            Object connectorImpl = network.getConnector(descriptor);
            if (!(connectorImpl instanceof POPConnectorSearchNodeInterface)) {
                LogWriter.writeDebugInfo("[JM] Connector [%s] is not Job Manager enabed", request.getConnector());
                return;
            }
            POPConnectorSearchNodeInterface snEnableConnector = (POPConnectorSearchNodeInterface)connectorImpl;
            for (POPNode node : network.getMembers(((POPConnector)connectorImpl).getDescriptor())) {
                if (!(node instanceof POPNodeAJobManager)) continue;
                jmNode = (String[])node;
                explorationList.add(jmNode.getJobManagerAccessPoint());
            }
            if (request.isEndRequest()) {
                if (request.getRemainingHops() >= 0 || request.getRemainingHops() == this.conf.getSearchNodeUnlimitedHops()) {
                    for (POPNode node : network.getMembers(((POPConnector)connectorImpl).getDescriptor())) {
                        if (!(node instanceof POPNodeJobManager) || oldExplorationList.contains((jmNode = (POPNodeAJobManager)node).getJobManagerAccessPoint())) continue;
                        try {
                            POPJavaJobManager jm = this.connectToJobmanager(jmNode.getJobManagerAccessPoint(), request.getNetworkUUID());
                            jm.askResourcesDiscovery(request, this.getAccessPoint());
                        }
                        catch (Exception e) {
                            LogWriter.writeDebugInfo("[PSN] askResourcesDiscovery can't reach %s: %s", jmNode.getJobManagerAccessPoint(), e.getMessage());
                        }
                    }
                }
                this.applicationEnd(request.getPOPAppId(), false);
                return;
            }
            if (this.SNKnownRequests.contains(request.getUID())) {
                return;
            }
            this.SNKnownRequests.push(request.getUID());
            if (this.SNKnownRequests.size() > this.conf.getSearchNodeMaxRequests()) {
                this.SNKnownRequests.pollLast();
            }
            boolean bl = answer = request.getHosts().length == 0;
            if (!answer) {
                InetAddress myself = InetAddress.getByName(POPSystem.getHostIP());
                for (String host : request.getHosts()) {
                    InetAddress addr = InetAddress.getByName(host);
                    if (!myself.equals(addr)) continue;
                    answer = true;
                    break;
                }
            }
            if (answer) {
                LogWriter.writeDebugInfo("[PSN] Looking for local answer");
                snEnableConnector.askResourcesDiscoveryAction(request, sender, oldExplorationList);
            } else {
                LogWriter.writeDebugInfo("[PSN] Node not in request answer list, skipping and propagating request");
            }
            if (request.getRemainingHops() >= 0 || request.getRemainingHops() == this.conf.getSearchNodeUnlimitedHops()) {
                request.getWayback().push(this.getAccessPoint());
                for (POPNode node : network.getMembers(((POPConnector)connectorImpl).getDescriptor())) {
                    POPNodeAJobManager jmNode2;
                    if (!(node instanceof POPNodeAJobManager) || oldExplorationList.contains((jmNode2 = (POPNodeAJobManager)node).getJobManagerAccessPoint())) continue;
                    try {
                        POPJavaJobManager jm = this.connectToJobmanager(jmNode2.getJobManagerAccessPoint(), request.getNetworkUUID());
                        jm.askResourcesDiscovery(request, this.getAccessPoint());
                    }
                    catch (Exception e) {
                        LogWriter.writeDebugInfo("[PSN] askResourcesDiscovery can't reach %s: %s", jmNode2.getJobManagerAccessPoint(), e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[PSN] Exception caught in askResourcesDiscovery: %s", e.getMessage());
            LogWriter.writeExceptionLog(e);
        }
    }

    @POPAsyncConc
    public void callbackResult(@POPParameter(value=POPParameter.Direction.IN) SNResponse response) {
        try {
            SNNodesInfo.Node result = response.getResultNode();
            SNNodesInfo nodes = this.SNActualRequets.get(response.getUID());
            if (nodes == null) {
                return;
            }
            nodes.add(result);
            if (response.getPublicCertificate().length > 0) {
                SSLUtils.addCertToTempStore(response.getPublicCertificate());
            }
            this.unlockDiscovery(response.getUID());
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[PSN] Exception caught in callbackResult: %s", e.getMessage());
            LogWriter.writeExceptionLog(e);
        }
    }

    @POPAsyncConc
    public void rerouteResponse(@POPParameter(value=POPParameter.Direction.IN) SNResponse response, @POPParameter(value=POPParameter.Direction.IN) SNWayback wayback) {
        try {
            if (!wayback.isLastNode()) {
                LogWriter.writeDebugInfo("[PSN] REROUTE;%s;DEST;%s", response.getUID(), wayback.toString());
                POPAccessPoint jm = wayback.pop();
                POPJavaJobManager njm = this.connectToJobmanager(jm, response.getNetworkUUID());
                njm.rerouteResponse(response, wayback);
            } else {
                LogWriter.writeDebugInfo("[PSN] REROUTE_ORIGIN;%s;", response.getUID());
                this.callbackResult(response);
            }
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[PSN] Exception caught in rerouteResponse: %s", e.getMessage());
            LogWriter.writeExceptionLog(e);
        }
    }

    @POPAsyncConc
    public void unlockDiscovery(String requid) {
        Semaphore sem = this.SNRequestSemaphore.remove(requid);
        if (sem != null) {
            sem.release();
            LogWriter.writeDebugInfo("[PSN] UNLOCK SEMAPHORE %s", requid);
        }
    }

    public synchronized POPJavaJobManager connectToJobmanager(POPAccessPoint ap, String network) {
        POPJavaJobManager jm;
        Tuple<String, POPAccessPoint> key = new Tuple<String, POPAccessPoint>(network, ap);
        if (!this.cachedJobManangers.containsKey(key)) {
            System.out.println("######No JM found for " + ap + " # " + network);
            for (Tuple<String, POPAccessPoint> tmpKey : this.cachedJobManangers.keySet()) {
                System.out.println("#####Cached JM : " + (String)tmpKey.a + " " + tmpKey.b);
                System.out.println("#####FP : " + tmpKey.getB().getFingerprint() + " " + ap.getFingerprint());
            }
            jm = PopJava.connect(this, POPJavaJobManager.class, network, ap);
            this.cachedJobManangers.put(key, jm);
        }
        jm = this.cachedJobManangers.get(key);
        try {
            POPString val = new POPString();
            jm.query("power", val);
            jm.registerNeighbourJobmanager(this.getAccessPoint(), network, this);
        }
        catch (Exception e) {
            this.cachedJobManangers.put(key, null);
            LogWriter.writeDebugInfo("[POPJavaJobManager] Connection lost with [%s], opening new one");
            jm = PopJava.connect(this, POPJavaJobManager.class, network, ap);
            this.cachedJobManangers.put(key, jm);
        }
        System.out.println("#####Connected to JM " + ap);
        return jm;
    }

    @POPSyncConc
    public POPAccessPoint[] newTFCSearchOn(POPAccessPoint ap, String network, String objectName) {
        return this.connectToJobmanager(ap, network).localTFCSearch(network, objectName);
    }

    @POPSyncConc
    public void registerNeighbourJobmanager(POPAccessPoint ap, String network, POPJavaJobManager jm) {
        Tuple<String, POPAccessPoint> key = new Tuple<String, POPAccessPoint>(network, ap);
        if (!this.cachedJobManangers.containsKey(key)) {
            jm.makePermanent();
            this.cachedJobManangers.put(key, jm);
        } else {
            try {
                POPString val = new POPString();
                jm.query("power", val);
            }
            catch (Exception e) {
                jm.makePermanent();
                this.cachedJobManangers.put(key, jm);
            }
        }
    }
}

