/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorDirect;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorTFC;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.util.Configuration;
import java.util.HashMap;
import java.util.Map;

public class POPNetworkDescriptorFinder {
    private static POPNetworkDescriptorFinder instance;
    private final Map<String, POPNetworkDescriptor> descriptors = new HashMap<String, POPNetworkDescriptor>();

    private POPNetworkDescriptorFinder() {
        POPNetworkDescriptor jm = POPConnectorJobManager.DESCRIPTOR;
        POPNetworkDescriptor direct = POPConnectorDirect.DESCRIPTOR;
        POPNetworkDescriptor tfc = POPConnectorTFC.DESCRIPTOR;
        this.descriptors.put(jm.getGlobalName(), jm);
        this.descriptors.put(direct.getGlobalName(), direct);
        this.descriptors.put(tfc.getGlobalName(), tfc);
        this.loadCustomDescriptors();
    }

    private void loadCustomDescriptors() {
    }

    public void register(POPNetworkDescriptor descriptor) {
        if (!this.descriptors.containsKey(descriptor.getGlobalName())) {
            this.descriptors.put(descriptor.getGlobalName(), descriptor);
        }
    }

    public static POPNetworkDescriptorFinder getInstance() {
        if (instance == null) {
            instance = new POPNetworkDescriptorFinder();
        }
        return instance;
    }

    public POPNetworkDescriptor find(String globalName) {
        if (globalName == null || globalName.isEmpty()) {
            globalName = Configuration.getInstance().getJobManagerDefaultConnector();
        }
        return this.descriptors.get(globalName);
    }

    public POPNetworkDescriptor[] all() {
        return this.descriptors.values().toArray(new POPNetworkDescriptor[this.descriptors.size()]);
    }
}

