/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorDirect;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class POPNodeDirect
extends POPNode {
    private int port;
    private boolean daemon;
    private String daemonSecret;
    private boolean initialized = true;

    public POPNodeDirect(String host, int port, String daemonSecret) {
        super(POPConnectorDirect.DESCRIPTOR);
        this.host = host;
        this.port = port;
        this.daemon = true;
        this.daemonSecret = daemonSecret;
        this.init();
    }

    public POPNodeDirect(String host, int port) {
        super(POPConnectorDirect.DESCRIPTOR);
        this.host = host;
        this.port = port;
        this.daemon = false;
        this.daemonSecret = null;
        this.init();
    }

    public POPNodeDirect(List<String> params) {
        super(POPConnectorDirect.DESCRIPTOR);
        String host = Util.removeStringFromList(params, "host=");
        String portString = Util.removeStringFromList(params, "port=");
        String protocol = Util.removeStringFromList(params, "protocol=");
        String secret = Util.removeStringFromList(params, "secret=");
        if (host == null) {
            this.initialized = false;
            return;
        }
        this.host = host;
        this.daemon = protocol != null && protocol.equals("daemon");
        this.daemonSecret = secret;
        int n = this.port = !this.daemon ? 22 : Configuration.getInstance().getPopJavaDaemonPort();
        if (portString != null) {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                this.initialized = false;
            }
        }
        this.init();
    }

    private void init() {
        HashSet<String> paramsSet = new HashSet<String>();
        paramsSet.add("connector=" + this.descriptor.getGlobalName());
        paramsSet.add("host=" + this.host);
        paramsSet.add("port=" + this.port);
        paramsSet.add("protocol=" + (this.daemon ? "daemon" : "ssh"));
        if (this.daemonSecret != null) {
            paramsSet.add("secret=" + this.daemonSecret);
        }
        this.creationParams = paramsSet.toArray(new String[paramsSet.size()]);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String getDaemonSecret() {
        return this.daemonSecret;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.host);
        hash = 59 * hash + this.port;
        hash = 59 * hash + (this.daemon ? 1 : 0);
        hash = 59 * hash + Objects.hashCode(this.daemonSecret);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPNodeDirect other = (POPNodeDirect)obj;
        if (this.port != other.port) {
            return false;
        }
        if (this.daemon != other.daemon) {
            return false;
        }
        if (!Objects.equals(this.host, other.host)) {
            return false;
        }
        return Objects.equals(this.daemonSecret, other.daemonSecret);
    }

    @Override
    public String toString() {
        return String.format("host=%s port=%d connector=%s protocol=%s %s", this.host, this.port, this.descriptor.getGlobalName(), this.daemon ? "daemon" : "ssh", this.daemonSecret == null ? "" : "secret=" + this.daemonSecret).trim();
    }
}

