/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.search;

import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.service.jobmanager.search.SNExploration;
import ch.icosys.popjava.core.service.jobmanager.search.SNNodesInfo;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.security.cert.Certificate;

public class SNResponse
implements IPOPBase {
    private String uid;
    private SNExploration explorationList;
    private SNNodesInfo.Node nodeinfo;
    private String networkUUID;
    private byte[] publicCertificate = new byte[0];

    public SNResponse() {
    }

    public SNResponse(String uid, String networkUUID, SNExploration explorationList, SNNodesInfo.Node nodeinfo) {
        this.uid = uid;
        this.explorationList = explorationList;
        this.nodeinfo = nodeinfo;
        this.networkUUID = networkUUID;
        Certificate localPublicCertificate = SSLUtils.getCertificateFromAlias(networkUUID);
        if (localPublicCertificate != null) {
            this.publicCertificate = SSLUtils.certificateBytes(localPublicCertificate);
            nodeinfo.setCertificate(this.publicCertificate);
        }
    }

    public String getUID() {
        return this.uid;
    }

    public SNNodesInfo.Node getResultNode() {
        return this.nodeinfo;
    }

    public byte[] getPublicCertificate() {
        return this.publicCertificate;
    }

    public String getNetworkUUID() {
        return this.networkUUID;
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putString(this.uid);
        buffer.putValue(this.explorationList, SNExploration.class);
        buffer.putValue(this.nodeinfo, SNNodesInfo.Node.class);
        buffer.putByteArray(this.publicCertificate);
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.uid = buffer.getString();
        this.explorationList = (SNExploration)buffer.getValue(SNExploration.class);
        this.nodeinfo = (SNNodesInfo.Node)buffer.getValue(SNNodesInfo.Node.class);
        int buffSize = buffer.getInt();
        this.publicCertificate = buffer.getByteArray(buffSize);
        return true;
    }
}

