/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.util.ssl.KeyStoreDetails;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Configuration {
    private static Configuration instance;
    private static final String POPJAVA_LOCATION;
    private static final Boolean ENV_DEBUG;
    private static final File SYSTEM_CONFIG;
    private File systemJobManagerConfig = Paths.get(POPJAVA_LOCATION, "etc", "jobmgr.yml").toFile();
    private File userConfig = null;
    private boolean usingUserConfig = false;
    private final Properties USER_PROPERTIES = new Properties();
    private final Properties ALL_PROPERTIES = new Properties();
    private boolean debug = ENV_DEBUG != null ? ENV_DEBUG : false;
    private boolean debugCombox = false;
    private int reserveTimeout = 60000;
    private int allocTimeout = 30000;
    private int connectionTimeout = 30000;
    private int jobManagerUpdateInterval = 10000;
    private int jobManagerSelfRegisterInterval = 43200000;
    private String jobManagerDefaultConnector = "jobmanager";
    private int searchNodeUnlockTimeout = 10000;
    private int searchNodeSearchTimeout = 0;
    private int tfcSearchTimeout = 5000;
    private int searchNodeUnlimitedHops = Integer.MAX_VALUE;
    private int searchNodeMaxRequests = 300;
    private int searchNodeExplorationQueueSize = 300;
    private String[] jobManagerProtocols = new String[]{"socket"};
    private int[] jobManagerPorts = new int[]{2711};
    private int popJavaDaemonPort = 43424;
    private String jobManagerExecutionBaseDirectory = ".";
    private String jobmanagerExecutionUser = null;
    private String defaultEncoding = "xdr";
    private String selectedEncoding = "raw";
    private String defaultProtocol = "socket";
    private String defaultNetwork = "";
    private int allocatePortRange = 49152;
    private final Set<String> protocolsWhitelist = new HashSet<String>();
    private final Set<String> protocolsBlacklist = new HashSet<String>();
    private boolean asyncConstructor = true;
    private boolean activateJmx = false;
    private boolean connectToPOPcpp = false;
    private boolean connectToJavaJobmanager = !this.connectToPOPcpp;
    private boolean redirectOutputToRoot = true;
    private boolean useNativeSSHifPossible = true;
    private final KeyStoreDetails SSLKeyStoreOptions = new KeyStoreDetails();
    private File SSLTemporaryCertificatesLocation = new File(".");
    private String SSLProtocolVersion = "TLSv1.2";

    private Configuration() {
        try {
            this.load(SYSTEM_CONFIG);
        }
        catch (IOException e) {
            System.out.format("[Configuration] couldn't load '%s' using POP-Java's defaults.\n", SYSTEM_CONFIG);
        }
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public String getPopJavaLocation() {
        return POPJAVA_LOCATION;
    }

    public File getSystemJobManagerConfig() {
        return this.systemJobManagerConfig;
    }

    public File getUserConfig() {
        return this.userConfig;
    }

    public boolean isUsingUserConfig() {
        return this.usingUserConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isDebugCombox() {
        return this.debugCombox;
    }

    public int getReserveTimeout() {
        return this.reserveTimeout;
    }

    public int getAllocTimeout() {
        return this.allocTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getJobManagerUpdateInterval() {
        return this.jobManagerUpdateInterval;
    }

    @Deprecated
    public int getJobManagerSelfRegisterInterval() {
        return this.jobManagerSelfRegisterInterval;
    }

    public String getJobManagerDefaultConnector() {
        return this.jobManagerDefaultConnector;
    }

    public String getJobManagerExecutionBaseDirectory() {
        return this.jobManagerExecutionBaseDirectory;
    }

    public String getJobmanagerExecutionUser() {
        return this.jobmanagerExecutionUser;
    }

    public int getSearchNodeUnlockTimeout() {
        return this.searchNodeUnlockTimeout;
    }

    public int getSearchNodeSearchTimeout() {
        return this.searchNodeSearchTimeout;
    }

    public int getTFCSearchTimeout() {
        return this.tfcSearchTimeout;
    }

    public int getSearchNodeUnlimitedHops() {
        return this.searchNodeUnlimitedHops;
    }

    public int getSearchNodeMaxRequests() {
        return this.searchNodeMaxRequests;
    }

    public int getSearchNodeExplorationQueueSize() {
        return this.searchNodeExplorationQueueSize;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getSelectedEncoding() {
        return this.selectedEncoding;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public String getDefaultNetwork() {
        return this.defaultNetwork;
    }

    public int getAllocatePortRange() {
        return this.allocatePortRange;
    }

    public boolean isAsyncConstructor() {
        return this.asyncConstructor;
    }

    public boolean isActivateJmx() {
        return this.activateJmx;
    }

    public boolean isConnectToPOPcpp() {
        return this.connectToPOPcpp;
    }

    public boolean isConnectToJavaJobmanager() {
        return this.connectToJavaJobmanager;
    }

    public boolean isRedirectOutputToRoot() {
        return this.redirectOutputToRoot;
    }

    public boolean isUseNativeSSHifPossible() {
        return this.useNativeSSHifPossible;
    }

    public KeyStoreDetails getSSLKeyStoreOptions() {
        return new KeyStoreDetails(this.SSLKeyStoreOptions);
    }

    public String getSSLProtocolVersion() {
        return this.SSLProtocolVersion;
    }

    public File getSSLKeyStoreFile() {
        return this.SSLKeyStoreOptions.getKeyStoreFile();
    }

    public String getSSLKeyStorePassword() {
        return this.SSLKeyStoreOptions.getKeyStorePassword();
    }

    public String getSSLKeyStorePrivateKeyPassword() {
        return this.SSLKeyStoreOptions.getPrivateKeyPassword();
    }

    public KeyStoreDetails.KeyStoreFormat getSSLKeyStoreFormat() {
        return this.SSLKeyStoreOptions.getKeyStoreFormat();
    }

    public File getSSLTemporaryCertificateLocation() {
        return this.SSLTemporaryCertificatesLocation;
    }

    public int[] getJobManagerPorts() {
        return Arrays.copyOf(this.jobManagerPorts, this.jobManagerPorts.length);
    }

    public String[] getJobManagerProtocols() {
        return Arrays.copyOf(this.jobManagerProtocols, this.jobManagerProtocols.length);
    }

    public int getPopJavaDaemonPort() {
        return this.popJavaDaemonPort;
    }

    public Set<String> getProtocolsWhitelist() {
        return Collections.unmodifiableSet(this.protocolsWhitelist);
    }

    public Set<String> getProtocolsBlacklist() {
        return Collections.unmodifiableSet(this.protocolsBlacklist);
    }

    public void setSystemJobManagerConfig(File systemJobManagerConfig) {
        this.setUserProp(Settable.SYSTEM_JOBMANAGER_CONFIG, systemJobManagerConfig);
        this.systemJobManagerConfig = systemJobManagerConfig;
    }

    public void setUserConfig(File userConfig) {
        this.userConfig = userConfig;
        this.usingUserConfig = userConfig != null;
    }

    public void setDebug(boolean debug) {
        if (ENV_DEBUG == null) {
            this.setUserProp(Settable.DEBUG, debug);
            this.debug = debug;
        }
    }

    public void setDebugCombox(boolean debugCombox) {
        this.setUserProp(Settable.DEBUG_COMBOX, debugCombox);
        this.debugCombox = debugCombox;
    }

    public void setReserveTimeout(int reserveTimeout) {
        this.setUserProp(Settable.RESERVE_TIMEOUT, reserveTimeout);
        this.reserveTimeout = reserveTimeout;
    }

    public void setAllocTimeout(int allocTimeout) {
        this.setUserProp(Settable.ALLOC_TIMEOUT, allocTimeout);
        this.allocTimeout = allocTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.setUserProp(Settable.CONNECTION_TIMEOUT, connectionTimeout);
        this.connectionTimeout = connectionTimeout;
    }

    public void setJobManagerUpdateInterval(int jobManagerUpdateInterval) {
        this.setUserProp(Settable.JOBMANAGER_UPDATE_INTERVAL, jobManagerUpdateInterval);
        this.jobManagerUpdateInterval = jobManagerUpdateInterval;
    }

    public void setJobManagerSelfRegisterInterval(int jobManagerSelfRegisterInterval) {
        this.setUserProp(Settable.JOBMANAGER_SELF_REGISTER_INTERVAL, jobManagerSelfRegisterInterval);
        this.jobManagerSelfRegisterInterval = jobManagerSelfRegisterInterval;
    }

    public void setJobManagerDefaultConnector(String jobManagerDefaultConnector) {
        this.setUserProp(Settable.JOBMANAGER_DEFAULT_CONNECTOR, jobManagerDefaultConnector);
        this.jobManagerDefaultConnector = jobManagerDefaultConnector;
    }

    public void setJobManagerExecutionBaseDirectory(String jobManagerExecutionBaseDirectory) {
        this.setUserProp(Settable.JOBMANAGER_EXECUTION_BASE_DIRECTORY, jobManagerExecutionBaseDirectory);
        this.jobManagerExecutionBaseDirectory = jobManagerExecutionBaseDirectory;
    }

    public void setJobmanagerExecutionUser(String jobmanagerExecutionUser) {
        this.setUserProp(Settable.JOBMANAGER_EXECUTION_USER, jobmanagerExecutionUser);
        this.jobmanagerExecutionUser = jobmanagerExecutionUser;
    }

    public void setSearchNodeUnlockTimeout(int searchNodeUnlockTimeout) {
        this.setUserProp(Settable.SEARCH_NODE_UNLOCK_TIMEOUT, searchNodeUnlockTimeout);
        this.searchNodeUnlockTimeout = searchNodeUnlockTimeout;
    }

    public void setSearchNodeSearchTimeout(int searchNodeSearchTimeout) {
        this.setUserProp(Settable.SEARCH_NODE_SEARCH_TIMEOUT, searchNodeSearchTimeout);
        this.searchNodeSearchTimeout = searchNodeSearchTimeout;
    }

    public void setTFCSearchTimeout(int tfcSearchTimeout) {
        this.setUserProp(Settable.TFC_SEARCH_TIMEOUT, tfcSearchTimeout);
        this.tfcSearchTimeout = tfcSearchTimeout;
    }

    public void setSearchNodeMaxRequests(int searchNodeMaxRequests) {
        this.setUserProp(Settable.SEARCH_NODE_MAX_REQUESTS, searchNodeMaxRequests);
        this.searchNodeMaxRequests = searchNodeMaxRequests;
    }

    public void setSearchNodeExplorationQueueSize(int searchNodeExplorationQueueSize) {
        this.setUserProp(Settable.SEARCH_NODE_EXPLORATION_QUEUE_SIZE, searchNodeExplorationQueueSize);
        this.searchNodeExplorationQueueSize = searchNodeExplorationQueueSize;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.setUserProp(Settable.DEFAULT_ENCODING, defaultEncoding);
        this.defaultEncoding = defaultEncoding;
    }

    public void setSelectedEncoding(String selectedEncoding) {
        this.setUserProp(Settable.SELECTED_ENCODING, selectedEncoding);
        this.selectedEncoding = selectedEncoding;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        this.setUserProp(Settable.DEFAULT_PROTOCOL, defaultProtocol);
        this.defaultProtocol = defaultProtocol.toUpperCase();
    }

    public void setAllocatePortRange(int allocatePortRange) {
        this.setUserProp(Settable.ALLOCATE_PORT_RANGE, allocatePortRange);
        this.allocatePortRange = allocatePortRange;
    }

    public void setDefaultNetwork(String systemDefaultNetwork) {
        this.setUserProp(Settable.DEFAULT_NETWORK, systemDefaultNetwork);
        this.defaultNetwork = systemDefaultNetwork;
    }

    public void setAsyncConstructor(boolean asyncConstructor) {
        this.setUserProp(Settable.ASYNC_CONSTRUCTOR, asyncConstructor);
        this.asyncConstructor = asyncConstructor;
    }

    public void setActivateJmx(boolean activateJmx) {
        this.setUserProp(Settable.ACTIVATE_JMX, activateJmx);
        this.activateJmx = activateJmx;
    }

    public void setConnectToPOPcpp(boolean connectToPOPcpp) {
        this.setUserProp(Settable.CONNECT_TO_POPCPP, connectToPOPcpp);
        this.connectToPOPcpp = connectToPOPcpp;
    }

    public void setConnectToJavaJobmanager(boolean connectToJavaJobmanager) {
        this.setUserProp(Settable.CONNECT_TO_JAVA_JOBMANAGER, connectToJavaJobmanager);
        this.connectToJavaJobmanager = connectToJavaJobmanager;
    }

    public void setRedirectOutputToRoot(boolean redirectOutputToRoot) {
        this.setUserProp(Settable.REDIRECT_OUTPUT_TO_ROOT, redirectOutputToRoot);
        this.redirectOutputToRoot = redirectOutputToRoot;
    }

    public void setUseNativeSSHifPossible(boolean useNativeSSHifPossible) {
        this.setUserProp(Settable.USE_NATIVE_SSH_IF_POSSIBLE, useNativeSSHifPossible);
        this.useNativeSSHifPossible = useNativeSSHifPossible;
    }

    public void setSSLProtocolVersion(String SSLProtocolVersion) {
        this.setUserProp(Settable.SSL_PROTOCOL_VERSION, SSLProtocolVersion);
        this.SSLProtocolVersion = SSLProtocolVersion;
    }

    public void setSSLKeyStoreFile(File file) {
        this.setUserProp(Settable.SSL_KEY_STORE_FILE, file);
        this.SSLKeyStoreOptions.setKeyStoreFile(file);
    }

    public void setSSLKeyStorePassword(String val) {
        this.setUserProp(Settable.SSL_KEY_STORE_PASSWORD, val);
        this.SSLKeyStoreOptions.setKeyStorePassword(val);
    }

    public void setSSLKeyStorePrivateKeyPassword(String val) {
        this.setUserProp(Settable.SSL_KEY_STORE_PRIVATE_KEY_PASSWORD, val);
        this.SSLKeyStoreOptions.setPrivateKeyPassword(val);
    }

    public void setSSLKeyStoreFormat(KeyStoreDetails.KeyStoreFormat val) {
        this.setUserProp(Settable.SSL_KEY_STORE_FORMAT, val);
        this.SSLKeyStoreOptions.setKeyStoreFormat(val);
    }

    public void setSSLTemporaryCertificateDirectory(File file) {
        this.SSLTemporaryCertificatesLocation = file;
    }

    public void setSSLKeyStoreOptions(KeyStoreDetails options) {
        if (options == null) {
            this.setSSLKeyStoreFile(null);
            this.setSSLKeyStoreFormat(null);
            this.setSSLKeyStorePassword(null);
            this.setSSLKeyStorePrivateKeyPassword(null);
        } else {
            this.setSSLKeyStoreFile(options.getKeyStoreFile());
            this.setSSLKeyStoreFormat(options.getKeyStoreFormat());
            this.setSSLKeyStorePassword(options.getKeyStorePassword());
            this.setSSLKeyStorePrivateKeyPassword(options.getPrivateKeyPassword());
        }
    }

    public void setJobManagerPorts(int[] jobManagerPorts) {
        this.setUserProp(Settable.JOBMANAGER_PORTS, Arrays.toString(jobManagerPorts));
        this.jobManagerPorts = Arrays.copyOf(jobManagerPorts, jobManagerPorts.length);
    }

    public void setJobManagerProtocols(String[] jobManagerProtocols) {
        this.setUserProp(Settable.JOBMANAGER_PROTOCOLS, Arrays.toString(jobManagerProtocols));
        this.jobManagerProtocols = Arrays.copyOf(jobManagerProtocols, jobManagerProtocols.length);
    }

    public void setPopJavaDaemonPort(int popJavaDaemonPort) {
        this.setUserProp(Settable.POP_JAVA_DEAMON_PORT, popJavaDaemonPort);
        this.popJavaDaemonPort = popJavaDaemonPort;
    }

    public void setProtocolsWhitelist(Set<String> protocolsWhitelist) {
        this.setUserProp(Settable.PROTOCOLS_WHITELIST, protocolsWhitelist);
        this.protocolsWhitelist.clear();
        this.protocolsWhitelist.addAll(protocolsWhitelist);
    }

    public void setProtocolsBlacklist(Set<String> protocolsBlacklist) {
        this.setUserProp(Settable.PROTOCOLS_BLACKLIST, protocolsBlacklist);
        this.protocolsBlacklist.clear();
        this.protocolsBlacklist.addAll(protocolsBlacklist);
    }

    private <T> void setUserProp(Settable prop, T value) {
        if (value == null) {
            this.USER_PROPERTIES.remove(prop.name());
        } else {
            this.USER_PROPERTIES.put(prop.name(), String.valueOf(value));
        }
    }

    public void load(File file) throws IOException {
        Object in;
        long start = System.currentTimeMillis();
        Objects.requireNonNull(file);
        if (!file.equals(SYSTEM_CONFIG)) {
            this.userConfig = file.getCanonicalFile();
            this.usingUserConfig = true;
        }
        if (!file.exists()) {
            if (this.debug) {
                System.out.format("[Configuration] '%s' doesn't exists or can't be read.\n", file.getCanonicalPath());
            }
            return;
        }
        this.ALL_PROPERTIES.putAll((Map<?, ?>)this.USER_PROPERTIES);
        if (this.usingUserConfig) {
            in = new FileInputStream(file);
            Throwable throwable = null;
            try {
                this.USER_PROPERTIES.load((InputStream)in);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                Configuration.$closeResource(throwable, (AutoCloseable)in);
            }
            this.ALL_PROPERTIES.putAll((Map<?, ?>)this.USER_PROPERTIES);
        } else {
            in = new FileInputStream(file);
            Throwable throwable = null;
            try {
                this.ALL_PROPERTIES.load((InputStream)in);
            }
            catch (Throwable throwable4) {
                Throwable throwable5 = throwable4;
                throw throwable4;
            }
            finally {
                Configuration.$closeResource(throwable, (AutoCloseable)in);
            }
        }
        block53: for (Object e : this.ALL_PROPERTIES.keySet()) {
            Settable keyEnum;
            if (!(e instanceof String)) continue;
            String key = (String)e;
            String[] keys = key.split("\\.");
            String value = this.ALL_PROPERTIES.getProperty(key);
            try {
                keyEnum = Settable.valueOf(keys[0].toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                if (!this.debug) continue;
                System.out.format("[Configuration] unknown key '%s'\n", key);
                continue;
            }
            try {
                switch (keyEnum) {
                    case SYSTEM_JOBMANAGER_CONFIG: {
                        this.systemJobManagerConfig = new File(value);
                        break;
                    }
                    case DEBUG: {
                        if (ENV_DEBUG == null) {
                            this.debug = Boolean.parseBoolean(value);
                            break;
                        }
                    }
                    case DEBUG_COMBOX: {
                        this.debugCombox = Boolean.parseBoolean(value);
                        break;
                    }
                    case RESERVE_TIMEOUT: {
                        this.reserveTimeout = Integer.parseInt(value);
                        break;
                    }
                    case ALLOC_TIMEOUT: {
                        this.allocTimeout = Integer.parseInt(value);
                        break;
                    }
                    case CONNECTION_TIMEOUT: {
                        this.connectionTimeout = Integer.parseInt(value);
                        break;
                    }
                    case JOBMANAGER_UPDATE_INTERVAL: {
                        this.jobManagerUpdateInterval = Integer.parseInt(value);
                        break;
                    }
                    case JOBMANAGER_SELF_REGISTER_INTERVAL: {
                        this.jobManagerSelfRegisterInterval = Integer.parseInt(value);
                        break;
                    }
                    case JOBMANAGER_DEFAULT_CONNECTOR: {
                        this.jobManagerDefaultConnector = value;
                        break;
                    }
                    case JOBMANAGER_EXECUTION_BASE_DIRECTORY: {
                        this.jobManagerExecutionBaseDirectory = value;
                        break;
                    }
                    case JOBMANAGER_EXECUTION_USER: {
                        this.jobmanagerExecutionUser = value;
                        break;
                    }
                    case JOBMANAGER_PORTS: {
                        String[] ports = this.matchRegEx(value, "\\d+");
                        this.jobManagerPorts = new int[ports.length];
                        for (int i = 0; i < ports.length; ++i) {
                            this.jobManagerPorts[i] = Integer.parseInt(ports[i]);
                        }
                        continue block53;
                    }
                    case JOBMANAGER_PROTOCOLS: {
                        this.jobManagerProtocols = this.matchRegEx(value, "[\\w\\d]+");
                        break;
                    }
                    case POP_JAVA_DEAMON_PORT: {
                        this.popJavaDaemonPort = Integer.parseInt(value);
                        break;
                    }
                    case SEARCH_NODE_UNLOCK_TIMEOUT: {
                        this.searchNodeUnlockTimeout = Integer.parseInt(value);
                        break;
                    }
                    case SEARCH_NODE_SEARCH_TIMEOUT: {
                        this.searchNodeSearchTimeout = Integer.parseInt(value);
                        break;
                    }
                    case SEARCH_NODE_MAX_REQUESTS: {
                        this.searchNodeMaxRequests = Integer.parseInt(value);
                        break;
                    }
                    case SEARCH_NODE_EXPLORATION_QUEUE_SIZE: {
                        this.searchNodeExplorationQueueSize = Integer.parseInt(value);
                        break;
                    }
                    case TFC_SEARCH_TIMEOUT: {
                        this.tfcSearchTimeout = Integer.parseInt(value);
                        break;
                    }
                    case DEFAULT_ENCODING: {
                        this.defaultEncoding = value;
                        break;
                    }
                    case SELECTED_ENCODING: {
                        this.selectedEncoding = value;
                        break;
                    }
                    case DEFAULT_PROTOCOL: {
                        this.defaultProtocol = value.toUpperCase();
                        break;
                    }
                    case DEFAULT_NETWORK: {
                        this.defaultNetwork = value.toLowerCase();
                        break;
                    }
                    case ALLOCATE_PORT_RANGE: {
                        this.allocatePortRange = Integer.parseInt(value);
                        break;
                    }
                    case PROTOCOLS_WHITELIST: {
                        this.protocolsWhitelist.clear();
                        this.protocolsWhitelist.addAll(Arrays.asList(this.matchRegEx(value, "[\\w\\d]+")));
                        break;
                    }
                    case PROTOCOLS_BLACKLIST: {
                        this.protocolsBlacklist.clear();
                        this.protocolsBlacklist.addAll(Arrays.asList(this.matchRegEx(value, "[\\w\\d]+")));
                        break;
                    }
                    case ASYNC_CONSTRUCTOR: {
                        this.asyncConstructor = Boolean.parseBoolean(value);
                        break;
                    }
                    case ACTIVATE_JMX: {
                        this.activateJmx = Boolean.parseBoolean(value);
                        break;
                    }
                    case CONNECT_TO_POPCPP: {
                        this.connectToPOPcpp = Boolean.parseBoolean(value);
                        break;
                    }
                    case CONNECT_TO_JAVA_JOBMANAGER: {
                        this.connectToJavaJobmanager = Boolean.parseBoolean(value);
                        break;
                    }
                    case REDIRECT_OUTPUT_TO_ROOT: {
                        this.redirectOutputToRoot = Boolean.parseBoolean(value);
                        break;
                    }
                    case USE_NATIVE_SSH_IF_POSSIBLE: {
                        this.useNativeSSHifPossible = Boolean.parseBoolean(value);
                        break;
                    }
                    case SSL_PROTOCOL_VERSION: {
                        this.SSLProtocolVersion = value;
                        break;
                    }
                    case SSL_KEY_STORE_FILE: {
                        this.SSLKeyStoreOptions.setKeyStoreFile(new File(value));
                        break;
                    }
                    case SSL_KEY_STORE_PASSWORD: {
                        this.SSLKeyStoreOptions.setKeyStorePassword(value);
                        break;
                    }
                    case SSL_KEY_STORE_PRIVATE_KEY_PASSWORD: {
                        this.SSLKeyStoreOptions.setPrivateKeyPassword(value);
                        break;
                    }
                    case SSL_KEY_STORE_FORMAT: {
                        this.SSLKeyStoreOptions.setKeyStoreFormat(KeyStoreDetails.KeyStoreFormat.valueOf(value));
                    }
                }
            }
            catch (NumberFormatException e3) {
                if (!this.debug) continue;
                System.out.format("[Configuration] unknown value '%s' for key '%s'.\n", value, key);
            }
        }
        if (this.debug) {
            long end = System.currentTimeMillis();
            System.out.format("[Configuration] loaded '%s' in %d ms\n", file.getCanonicalPath(), end - start);
        }
    }

    public void store() throws IOException {
        Objects.requireNonNull(this.userConfig, "A user configuration file must be provided via setUserConfig or load.");
        File file = this.userConfig;
        try (PrintStream out = new PrintStream(file);){
            this.USER_PROPERTIES.store(out, "Automatically generated by POP-Java");
        }
    }

    public void writeSystemConfiguration() throws IOException {
        Properties dump = new Properties();
        dump.putAll((Map<?, ?>)this.ALL_PROPERTIES);
        dump.putAll((Map<?, ?>)this.USER_PROPERTIES);
        try (PrintStream out = new PrintStream(SYSTEM_CONFIG);){
            dump.store(out, "Automatically generated by POP-Java");
        }
    }

    private String[] matchRegEx(String value, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            matches.add(m.group());
        }
        return matches.toArray(new String[matches.size()]);
    }

    static {
        String location = System.getenv("POPJAVA_LOCATION");
        String debug = System.getenv("POP_DEBUG");
        POPJAVA_LOCATION = location == null ? new File("./").getAbsolutePath() : new File(location).getAbsolutePath();
        ENV_DEBUG = debug != null ? Boolean.valueOf(Boolean.getBoolean(debug)) : null;
        SYSTEM_CONFIG = Paths.get(POPJAVA_LOCATION, "etc", "popjava.properties").toFile();
    }

    private static enum Settable {
        SYSTEM_JOBMANAGER_CONFIG,
        DEBUG,
        DEBUG_COMBOX,
        RESERVE_TIMEOUT,
        ALLOC_TIMEOUT,
        CONNECTION_TIMEOUT,
        JOBMANAGER_UPDATE_INTERVAL,
        JOBMANAGER_SELF_REGISTER_INTERVAL,
        JOBMANAGER_DEFAULT_CONNECTOR,
        JOBMANAGER_PROTOCOLS,
        JOBMANAGER_PORTS,
        JOBMANAGER_EXECUTION_BASE_DIRECTORY,
        JOBMANAGER_EXECUTION_USER,
        POP_JAVA_DEAMON_PORT,
        SEARCH_NODE_UNLOCK_TIMEOUT,
        SEARCH_NODE_SEARCH_TIMEOUT,
        SEARCH_NODE_MAX_REQUESTS,
        SEARCH_NODE_EXPLORATION_QUEUE_SIZE,
        TFC_SEARCH_TIMEOUT,
        DEFAULT_ENCODING,
        SELECTED_ENCODING,
        DEFAULT_PROTOCOL,
        DEFAULT_NETWORK,
        ALLOCATE_PORT_RANGE,
        PROTOCOLS_WHITELIST,
        PROTOCOLS_BLACKLIST,
        ASYNC_CONSTRUCTOR,
        ACTIVATE_JMX,
        CONNECT_TO_POPCPP,
        CONNECT_TO_JAVA_JOBMANAGER,
        REDIRECT_OUTPUT_TO_ROOT,
        USE_NATIVE_SSH_IF_POSSIBLE,
        SSL_PROTOCOL_VERSION,
        SSL_KEY_STORE_FILE,
        SSL_KEY_STORE_PASSWORD,
        SSL_KEY_STORE_PRIVATE_KEY_PASSWORD,
        SSL_KEY_STORE_FORMAT;

    }
}

