/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.annotation.POPAsyncConc;
import ch.icosys.popjava.core.annotation.POPAsyncMutex;
import ch.icosys.popjava.core.annotation.POPAsyncSeq;
import ch.icosys.popjava.core.annotation.POPObjectDescription;
import ch.icosys.popjava.core.annotation.POPSemantic;
import ch.icosys.popjava.core.annotation.POPSyncConc;
import ch.icosys.popjava.core.annotation.POPSyncMutex;
import ch.icosys.popjava.core.annotation.POPSyncSeq;
import ch.icosys.popjava.core.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodUtil {
    public static boolean isMethodPOPAnnotated(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
            POPSemantic semantic = annotation.annotationType().getAnnotation(POPSemantic.class);
            if (semantic == null) continue;
            return true;
        }
        try {
            Method parentMethod;
            if (method.getDeclaringClass().getSuperclass() != null && (parentMethod = method.getDeclaringClass().getSuperclass().getMethod(method.getName(), method.getParameterTypes())) != null) {
                return MethodUtil.isMethodPOPAnnotated(parentMethod);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static <A extends Annotation> A getMethodPOPAnnotation(Method m, Class<A> type) {
        A mainAnnotation = null;
        try {
            Method workingMethod = m;
            for (Class<?> declaringClass = m.getDeclaringClass(); declaringClass != Object.class; declaringClass = declaringClass.getSuperclass()) {
                A currentAnnotation = workingMethod.getAnnotation(type);
                if (mainAnnotation == null) {
                    mainAnnotation = currentAnnotation;
                } else if (currentAnnotation == null && workingMethod.getAnnotation(POPSemantic.class) != null) {
                    throw new RuntimeException("Method " + m.toGenericString() + " has mismatching POP Annotations");
                }
                workingMethod = declaringClass.getMethod(m.getName(), m.getParameterTypes());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return mainAnnotation;
    }

    public static int methodId(Method method) {
        int id = -1;
        if (method.isAnnotationPresent(POPSyncConc.class)) {
            id = method.getAnnotation(POPSyncConc.class).id();
        } else if (method.isAnnotationPresent(POPSyncSeq.class)) {
            id = method.getAnnotation(POPSyncSeq.class).id();
        } else if (method.isAnnotationPresent(POPSyncMutex.class)) {
            id = method.getAnnotation(POPSyncMutex.class).id();
        } else if (method.isAnnotationPresent(POPAsyncConc.class)) {
            id = method.getAnnotation(POPAsyncConc.class).id();
        } else if (method.isAnnotationPresent(POPAsyncSeq.class)) {
            id = method.getAnnotation(POPAsyncSeq.class).id();
        } else if (method.isAnnotationPresent(POPAsyncMutex.class)) {
            id = method.getAnnotation(POPAsyncMutex.class).id();
        }
        if (id >= 0) {
            return id;
        }
        String methodSign = ClassUtil.getMethodSign(method);
        return Math.abs(methodSign.hashCode());
    }

    public static int constructorId(Constructor<?> constructor) {
        int id;
        if (constructor.isAnnotationPresent(POPObjectDescription.class) && (id = constructor.getAnnotation(POPObjectDescription.class).id()) != -1) {
            return id;
        }
        String constructorSign = ClassUtil.getMethodSign(constructor);
        return Math.abs(constructorSign.hashCode());
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<? extends Annotation> clazz) {
        return MethodUtil.getAnnotation(annotations, clazz) != null;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> clazz) {
        if (annotations == null || clazz == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return (T)annotation;
        }
        return null;
    }

    public static String getCaller() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[3];
        return caller.getClassName() + "." + caller.getMethodName();
    }

    public static void grant(String ... signatures) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String caller = stack[3].getClassName() + "." + stack[3].getMethodName();
        String callee = stack[2].getClassName() + "." + stack[2].getMethodName();
        if (!Arrays.asList(signatures).contains(caller)) {
            throw new RuntimeException("Access denied to method " + callee);
        }
    }
}

