/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;

public class SystemUtil {
    private static final List<Process> processes = new ArrayList<Process>();
    private static final List<Broker> localJVM = new ArrayList<Broker>();
    private static final Configuration conf = Configuration.getInstance();
    private static final boolean sshAvailable = SystemUtil.commandExists("ssh");
    private static boolean changeUserStatus = false;
    private static String changeUserName = null;

    public static void endAllChildren() {
        for (Process process : processes) {
            if (process == null) continue;
            process.destroy();
        }
        processes.clear();
        for (Broker broker : localJVM) {
            if (broker == null) continue;
            broker.kill();
        }
        localJVM.clear();
    }

    public static int runCmd(List<String> argvs, String dir, String executeAs) {
        if (executeAs != null && !executeAs.isEmpty() && SystemUtil.canChangeUser(executeAs)) {
            argvs = SystemUtil.commandAs(executeAs, Util.join(" ", SystemUtil.escapeDollar(argvs)));
        }
        long startTime = System.currentTimeMillis();
        LogWriter.writeDebugInfo("[System] Run command");
        for (String arg : argvs) {
            LogWriter.writeDebugInfo(" %79s", arg);
        }
        ProcessBuilder pb = new ProcessBuilder(argvs);
        if (dir != null && !dir.isEmpty()) {
            pb.directory(new File(dir));
        }
        if (conf.isRedirectOutputToRoot()) {
            pb = pb.inheritIO();
        } else {
            pb.redirectErrorStream(true);
            pb.redirectOutput(new File("/dev/null"));
        }
        if (pb != null) {
            try {
                Process process = pb.start();
                processes.add(process);
                LogWriter.writeDebugInfo("[System] Started command after %s ms", System.currentTimeMillis() - startTime);
                return 0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static boolean mkdir(Path dir, String executeAs) {
        Util.OSType os = Util.getOSType();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("mkdir");
        switch (os) {
            case Windows: {
                cmd.add("/Q");
                break;
            }
            default: {
                cmd.add("-m=755");
                cmd.add("-p");
            }
        }
        cmd.add(dir.toAbsolutePath().toString());
        return SystemUtil.runCmd(cmd, null, executeAs) == 0;
    }

    public static boolean rm(Path path, String executeAs) {
        Util.OSType os = Util.getOSType();
        ArrayList<String> cmd = new ArrayList<String>();
        switch (os) {
            case Windows: {
                cmd.add("del");
                cmd.add("/q");
                break;
            }
            default: {
                cmd.add("rm");
            }
        }
        cmd.add(path.toAbsolutePath().toString());
        return SystemUtil.runCmd(cmd, null, executeAs) == 0;
    }

    public static boolean rmdir(Path dir, String executeAs) {
        Util.OSType os = Util.getOSType();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("rmdir");
        switch (os) {
            case Windows: {
                cmd.add("/Q");
                break;
            }
        }
        cmd.add(dir.toAbsolutePath().toString());
        return SystemUtil.runCmd(cmd, null, executeAs) == 0;
    }

    public static int runCmd(List<String> argvs, String dir) {
        return SystemUtil.runCmd(argvs, dir, null);
    }

    public static int runCmd(List<String> argvs) {
        return SystemUtil.runCmd(argvs, null);
    }

    public static boolean commandExists(String command) {
        try {
            Runtime.getRuntime().exec(command);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean commandWork(List<String> command) {
        try {
            ProcessBuilder exec = new ProcessBuilder(command);
            Process start = exec.start();
            return start.waitFor() == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public static boolean canChangeUser(String user) {
        if (changeUserName == null ? user == null : changeUserName.equals(user)) {
            return changeUserStatus;
        }
        changeUserName = user;
        changeUserStatus = SystemUtil.commandWork(SystemUtil.commandAs(user, "echo 1"));
        return changeUserStatus;
    }

    private static List<String> commandAs(String user, String command) {
        Util.OSType os = Util.getOSType();
        ArrayList<String> execute = new ArrayList<String>();
        switch (os) {
            case Windows: {
                execute.add("RUNAS");
                execute.add("/USER:" + user);
                execute.add("/PROFILE");
                execute.add("/SAVECRED");
                execute.add("CMD");
                execute.add("/K");
                execute.add(command);
                break;
            }
            default: {
                execute.add("sudo");
                execute.add("-inu");
                execute.add(user);
                execute.add("sh");
                execute.add("-c");
                execute.add(command);
            }
        }
        return execute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runRemoteCmdSSHJ(String url, List<String> command) {
        int returnValue = -1;
        SSHClient client = new SSHClient();
        LogWriter.writeDebugInfo("[System] Connect to " + url + " using sshj");
        try {
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            client.connect(url);
            LogWriter.writeDebugInfo("[System] Use user " + System.getProperty("user.name") + "for connection");
            client.authPublickey(System.getProperty("user.name"));
            Session session = client.startSession();
            StringBuilder commandAsString = new StringBuilder();
            for (int i = 0; i < command.size(); ++i) {
                commandAsString.append(command.get(i));
                if (i >= command.size() - 1) continue;
                commandAsString.append(" ");
            }
            LogWriter.writeDebugInfo("[System] Run remote command");
            session.exec(commandAsString.toString());
            returnValue = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                client.disconnect();
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public static int runRemoteCmd(String url, List<String> command) {
        return SystemUtil.runRemoteCmd(url, null, command);
    }

    public static int runRemoteCmd(String url, String port, List<String> command) {
        if (conf.isUseNativeSSHifPossible() && sshAvailable) {
            command = SystemUtil.escapeDollar(command);
            command.add(0, url);
            if (port != null && !port.isEmpty()) {
                command.add(0, String.format("-p %s", port));
            }
            command.add(0, "ssh");
            return SystemUtil.runCmd(command);
        }
        return SystemUtil.runRemoteCmdSSHJ(url, command);
    }

    private static List<String> escapeDollar(List<String> command) {
        ArrayList<String> newCommand = new ArrayList<String>(command);
        for (int i = 0; i < newCommand.size(); ++i) {
            String com = (String)newCommand.get(i);
            if (!com.contains("$")) continue;
            newCommand.set(i, com.replace("$", "$\\"));
        }
        return newCommand;
    }

    public static synchronized void registerLocalJVM(Broker broker) {
        Objects.requireNonNull(broker);
        localJVM.add(broker);
    }
}

