/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util.ssl;

import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class KeyPairDetails {
    protected String alias;
    protected Date validUntil;
    protected int privateKeySize;
    protected final Map<ASN1ObjectIdentifier, String> rdn = new HashMap<ASN1ObjectIdentifier, String>();
    boolean hasName = false;

    public KeyPairDetails() {
    }

    public KeyPairDetails(KeyPairDetails other) {
        Objects.requireNonNull(other);
        this.alias = other.alias;
        this.validUntil = other.validUntil;
        this.privateKeySize = other.privateKeySize;
        this.rdn.putAll(other.rdn);
        this.hasName = other.hasName;
    }

    public KeyPairDetails(String alias, Date validUntil, int privateKeySize) {
        this.alias = alias;
        this.rdn.put(BCStyle.OU, "PopJava");
        this.rdn.put(BCStyle.CN, alias);
        this.validUntil = validUntil;
        this.privateKeySize = privateKeySize;
        this.hasName = true;
    }

    public KeyPairDetails(String alias) {
        this(alias, new Date(System.currentTimeMillis() + 31536000000L), 2048);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public void setValidFor(int days) {
        long until = System.currentTimeMillis() + (long)days * 86400000L;
        this.validUntil = new Date(until);
    }

    public int getPrivateKeySize() {
        return this.privateKeySize;
    }

    public void setPrivateKeySize(int keySize) {
        this.privateKeySize = keySize;
    }

    public void addRDN(ASN1ObjectIdentifier name, String value) {
        this.rdn.put(name, value);
    }

    public void removeRDN(ASN1ObjectIdentifier name) {
        this.rdn.remove(name);
    }

    public Map<ASN1ObjectIdentifier, String> getRDN() {
        return Collections.unmodifiableMap(this.rdn);
    }

    public void validate() {
        if (this.alias == null || this.alias.isEmpty()) {
            throw new InvalidParameterException("An alias must be given and not empty");
        }
        if (this.rdn.isEmpty()) {
            throw new InvalidParameterException("At least one argument of the RDN must be provided");
        }
        if (this.validUntil == null) {
            throw new InvalidParameterException("A expiration date must be set");
        }
        if (this.privateKeySize < 1024) {
            throw new InvalidParameterException("Keys below 1024 bits are insecure (consider using 2048 or higher)");
        }
    }
}

