/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util.ssl;

import java.io.File;
import java.security.InvalidParameterException;

public class KeyStoreDetails {
    protected String keyStorePassword;
    protected String privateKeyPassword;
    protected File keyStoreFile;
    protected KeyStoreFormat keyStoreFormat;

    public KeyStoreDetails() {
    }

    public KeyStoreDetails(KeyStoreDetails other) {
        if (other != null) {
            this.keyStorePassword = other.keyStorePassword;
            this.privateKeyPassword = other.privateKeyPassword;
            this.keyStoreFile = other.keyStoreFile;
            this.keyStoreFormat = other.keyStoreFormat;
        }
    }

    public KeyStoreDetails(String storepass, String keypass, File keyStoreFile, KeyStoreFormat keyStoreFormat) {
        this.keyStorePassword = storepass;
        this.privateKeyPassword = keypass;
        this.keyStoreFile = keyStoreFile;
        this.keyStoreFormat = keyStoreFormat;
    }

    public KeyStoreDetails(String storepass, String keypass, File keyStoreFile) {
        this(storepass, keypass, keyStoreFile, KeyStoreFormat.JKS);
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String storepass) {
        this.keyStorePassword = storepass;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyPassword(String keypass) {
        this.privateKeyPassword = keypass;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public KeyStoreFormat getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(KeyStoreFormat keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public void validate() {
        if (this.keyStorePassword == null || this.keyStorePassword.length() < 6) {
            throw new InvalidParameterException("Store password must be set and at least 6 character long");
        }
        if (this.privateKeyPassword == null || this.privateKeyPassword.length() < 6) {
            throw new InvalidParameterException("Key password must be set and at least 6 character long");
        }
        if (this.keyStoreFile == null) {
            throw new InvalidParameterException("KeyStore file must be set");
        }
        if (this.keyStoreFormat == null) {
            throw new InvalidParameterException("A format for the keystore must be provided: JKS, PKCS12, ...");
        }
        if (this.keyStoreFormat == KeyStoreFormat.PKCS12 && !this.privateKeyPassword.equals(this.keyStorePassword)) {
            throw new InvalidParameterException("When using PKCS12 storePass and keyPass must match");
        }
    }

    public static enum KeyStoreFormat {
        JKS,
        PKCS12;

    }
}

