/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util.ssl;

import ch.icosys.popjava.core.combox.socket.ssl.POPKeyManager;
import ch.icosys.popjava.core.combox.socket.ssl.POPTrustManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.ssl.KeyPairDetails;
import ch.icosys.popjava.core.util.ssl.KeyStoreDetails;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class SSLUtils {
    private static SSLContext sslContextInstance = null;
    private static POPTrustManager trustManager = null;
    private static POPKeyManager keyManager = null;
    private static CertificateFactory certFactory;
    private static File keyStoreLocation;
    private static final Configuration conf;
    private static final SecureRandom RANDOM;

    private SSLUtils() {
    }

    private static KeyStore loadKeyStore() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(conf.getSSLKeyStoreFormat().name());
        keyStore.load(new FileInputStream(conf.getSSLKeyStoreFile()), conf.getSSLKeyStorePassword().toCharArray());
        return keyStore;
    }

    private static void storeKeyStore(KeyStore keyStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileOutputStream fos = new FileOutputStream(conf.getSSLKeyStoreFile());){
            keyStore.store(fos, conf.getSSLKeyStorePassword().toCharArray());
        }
    }

    public static SSLContext getSSLContext() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (sslContextInstance == null || !conf.getSSLTemporaryCertificateLocation().equals(keyStoreLocation)) {
            keyStoreLocation = conf.getSSLTemporaryCertificateLocation();
            if (trustManager == null) {
                trustManager = new POPTrustManager();
                keyManager = new POPKeyManager();
                TrustManager[] trustManagers = new TrustManager[]{trustManager};
                KeyManager[] keyManagers = new KeyManager[]{keyManager};
                if (sslContextInstance == null) {
                    sslContextInstance = SSLContext.getInstance(conf.getSSLProtocolVersion());
                }
                sslContextInstance.init(keyManagers, trustManagers, RANDOM);
            } else {
                trustManager.reloadTrustManager();
                keyManager.reloadKeyManager();
            }
        }
        return sslContextInstance;
    }

    public static void invalidateSSLSessions() {
        if (sslContextInstance == null) {
            return;
        }
        SSLUtils.invalidateSSLSessions(sslContextInstance.getClientSessionContext());
        SSLUtils.invalidateSSLSessions(sslContextInstance.getServerSessionContext());
    }

    private static void invalidateSSLSessions(SSLSessionContext context) {
        Enumeration<byte[]> sessionEnum = context.getIds();
        while (sessionEnum.hasMoreElements()) {
            byte[] id = sessionEnum.nextElement();
            SSLSession session = context.getSession(id);
            session.invalidate();
        }
    }

    public static void reloadPOPManagers() {
        try {
            if (trustManager != null) {
                trustManager.reloadTrustManager();
            }
            if (keyManager != null) {
                keyManager.reloadKeyManager();
            }
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[SSLUtils] Failed to reload Managers: %s", e.getCause());
            LogWriter.writeExceptionLog(e);
        }
    }

    private static String confidenceLinkAlias(POPNode node, String networkUUID) {
        return String.format("%x@%s", node.hashCode(), networkUUID.toLowerCase());
    }

    private static void addConfidenceLink(POPNode node, Certificate certificate, String networkUUID, boolean mode) throws IOException {
        try {
            KeyStore keyStore = SSLUtils.loadKeyStore();
            String nodeAlias = SSLUtils.confidenceLinkAlias(node, networkUUID);
            ArrayList<String> aliases = Collections.list(keyStore.aliases());
            if (aliases.contains(nodeAlias) ^ mode) {
                return;
            }
            keyStore.setCertificateEntry(nodeAlias, certificate);
            SSLUtils.storeKeyStore(keyStore);
        }
        catch (Exception e) {
            throw new IOException("Failed to save Confidence Link in KeyStore.");
        }
    }

    public static void addConfidenceLink(POPNode node, Certificate certificate, String networkUUID) throws IOException {
        SSLUtils.addConfidenceLink(node, certificate, networkUUID, false);
    }

    public static void replaceConfidenceLink(POPNode node, Certificate certificate, String networkUUID) throws IOException {
        SSLUtils.addConfidenceLink(node, certificate, networkUUID, true);
    }

    public static void removeConfidenceLink(POPNode node, String networkUUID) throws IOException {
        String nodeAlias = SSLUtils.confidenceLinkAlias(node, networkUUID);
        SSLUtils.removeAlias(nodeAlias);
    }

    public static void removeAlias(String alias) throws IOException {
        try {
            KeyStore keyStore = SSLUtils.loadKeyStore();
            ArrayList<String> aliases = Collections.list(keyStore.aliases());
            if (!aliases.contains(alias)) {
                return;
            }
            keyStore.deleteEntry(alias);
            SSLUtils.storeKeyStore(keyStore);
        }
        catch (Exception e) {
            throw new IOException("Failed to remove alias [" + alias + "] from KeyStore.");
        }
    }

    public static String certificateFingerprint(byte[] certificate) {
        try {
            ByteArrayInputStream fi = new ByteArrayInputStream(certificate);
            Certificate cert = certFactory.generateCertificate(fi);
            fi.close();
            return SSLUtils.certificateFingerprint(cert);
        }
        catch (IOException | CertificateException exception) {
            return null;
        }
    }

    public static String certificateFingerprint(Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            StringBuilder builder = new StringBuilder();
            for (byte b : digest) {
                builder.append(String.format("%02X", b));
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            return null;
        }
    }

    public static byte[] certificateBytes(Certificate cert) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("-----BEGIN CERTIFICATE-----\n");
            sb.append(Base64.getEncoder().encodeToString(cert.getEncoded())).append("\n");
            sb.append("-----END CERTIFICATE-----\n");
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static Certificate certificateFromBytes(byte[] certificate) throws CertificateException {
        Certificate cert = null;
        try (ByteArrayInputStream fi = new ByteArrayInputStream(certificate);){
            cert = certFactory.generateCertificate(fi);
        }
        catch (IOException e) {
            LogWriter.writeDebugInfo("[SSLUtils] invalid array for certificate conversion: %s", e.getMessage());
        }
        return cert;
    }

    public static boolean isCertificateKnown(Certificate certificate) {
        SSLUtils.ensureManagerCreation();
        return trustManager.isCertificateKnown(certificate);
    }

    public static String getNetworkFromFingerprint(String fingerprint) {
        SSLUtils.ensureManagerCreation();
        return trustManager.getNetworkFromFingerprint(fingerprint);
    }

    public static Certificate getCertificate(String fingerprint) {
        SSLUtils.ensureManagerCreation();
        return trustManager.getCertificate(fingerprint);
    }

    public static Certificate getCertificateFromAlias(String uuid) {
        SSLUtils.ensureManagerCreation();
        return trustManager.getCertificateFromAlias(uuid);
    }

    public static boolean isConfidenceLink(String fingerprint) {
        SSLUtils.ensureManagerCreation();
        return trustManager.isConfidenceLink(fingerprint);
    }

    public static void addCertToTempStore(byte[] certificate) {
        SSLUtils.addCertToTempStore(certificate, true);
    }

    public static void addCertToTempStore(byte[] certificate, boolean reload) {
        SSLUtils.ensureManagerCreation();
        try {
            Certificate cert = SSLUtils.certificateFromBytes(certificate);
            if (trustManager.isCertificateKnown(cert)) {
                return;
            }
            String fingerprint = SSLUtils.certificateFingerprint(cert);
            String outName = fingerprint + ".cer";
            Path path = conf.getSSLTemporaryCertificateLocation().toPath().resolve(outName);
            Files.write(path, certificate, new OpenOption[0]);
            if (reload) {
                trustManager.reloadTrustManager();
            }
        }
        catch (Exception ex) {
            LogWriter.writeDebugInfo("[SSLUtils] failed to save certificate: ", ex.getMessage());
        }
    }

    private static void ensureManagerCreation() {
        try {
            SSLUtils.getSSLContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean generateKeyStore(KeyStoreDetails ksOptions, KeyPairDetails keyOptions) {
        boolean generated;
        KeyStore.PrivateKeyEntry privateKeyEntry = SSLUtils.ensureKeyPairGeneration(keyOptions);
        try {
            SSLUtils.addKeyEntryToKeyStore(ksOptions, keyOptions, privateKeyEntry, false);
            generated = true;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            LogWriter.writeDebugInfo("[KeyStore] Generation failed with message: %s.", e.getMessage());
            generated = false;
        }
        return generated;
    }

    public static void addKeyEntryToKeyStore(KeyStoreDetails ksOptions, KeyPairDetails keyOptions, KeyStore.PrivateKeyEntry privateKeyEntry) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        SSLUtils.addKeyEntryToKeyStore(ksOptions, keyOptions, privateKeyEntry, true);
    }

    private static void addKeyEntryToKeyStore(KeyStoreDetails ksOptions, KeyPairDetails keyOptions, KeyStore.PrivateKeyEntry privateKeyEntry, boolean reload) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore ks = KeyStore.getInstance(ksOptions.getKeyStoreFormat().name());
        try (FileInputStream in = new FileInputStream(ksOptions.getKeyStoreFile());){
            ks.load(in, ksOptions.getKeyStorePassword().toCharArray());
        }
        catch (Exception e) {
            ks.load(null);
        }
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(ksOptions.getPrivateKeyPassword().toCharArray());
        ks.setEntry(keyOptions.getAlias(), privateKeyEntry, passwordProtection);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ks.store(out, ksOptions.getKeyStorePassword().toCharArray());
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        KeyStore ksout = KeyStore.getInstance(ksOptions.getKeyStoreFormat().name());
        ksout.load(in, ksOptions.getKeyStorePassword().toCharArray());
        ksout.store(new FileOutputStream(ksOptions.getKeyStoreFile()), ksOptions.getKeyStorePassword().toCharArray());
        if (reload && trustManager != null) {
            trustManager.reloadTrustManager();
            keyManager.reloadKeyManager();
        }
    }

    public static KeyStore.PrivateKeyEntry ensureKeyPairGeneration(KeyPairDetails options) {
        boolean retry = true;
        KeyStore.PrivateKeyEntry key = null;
        do {
            try {
                key = SSLUtils.generateKeyPair(options);
                retry = false;
            }
            catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
                LogWriter.writeDebugInfo("[KeyStore] Secure Private Key generation problem. Retrying after message: %s.", e.getMessage());
            }
        } while (retry);
        return key;
    }

    public static KeyStore.PrivateKeyEntry generateKeyPair(KeyPairDetails options) throws NoSuchAlgorithmException, IOException, OperatorCreationException, CertificateException, IllegalArgumentException {
        SubjectPublicKeyInfo pubKey;
        options.validate();
        KeyPairGenerator pairGenerator = KeyPairGenerator.getInstance("RSA");
        pairGenerator.initialize(options.getPrivateKeySize());
        KeyPair pair = pairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)pair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)pair.getPrivate();
        ByteArrayInputStream der = new ByteArrayInputStream(rsaPublicKey.getEncoded());
        Object object = null;
        try (ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)der);){
            pubKey = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream.readObject());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            SSLUtils.$closeResource((Throwable)object, der);
        }
        X500NameBuilder nameBuilder = new X500NameBuilder((X500NameStyle)new BCStrictStyle());
        for (Map.Entry entry : options.getRDN().entrySet()) {
            nameBuilder.addRDN((ASN1ObjectIdentifier)entry.getKey(), (String)entry.getValue());
        }
        X500Name subjectName = nameBuilder.build();
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(subjectName, BigInteger.valueOf(RANDOM.nextInt()), GregorianCalendar.getInstance().getTime(), options.getValidUntil(), subjectName, pubKey);
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        BcRSAContentSignerBuilder sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
        RSAKeyParameters keyParams = new RSAKeyParameters(true, rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getModulus());
        ContentSigner contentSigner = sigGen.build((AsymmetricKeyParameter)keyParams);
        X509CertificateHolder certificateHolder = x509v3CertificateBuilder.build(contentSigner);
        JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
        X509Certificate x509Certificate = certConverter.getCertificate(certificateHolder);
        return new KeyStore.PrivateKeyEntry(rsaPrivateKey, new Certificate[]{x509Certificate});
    }

    static {
        keyStoreLocation = null;
        conf = Configuration.getInstance();
        RANDOM = new SecureRandom();
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

