/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core;

import ch.icosys.popjava.core.PJMethodHandler;
import ch.icosys.popjava.core.PJProxyFactory;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.javaagent.POPJavaAgent;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeAJobManager;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.util.ArrayList;
import javassist.util.proxy.ProxyObject;

public class PopJava {
    private PopJava() {
    }

    public static <T> T newActive(Class<T> targetClass, ObjectDescription objectDescription, Object ... argvs) throws POPException {
        POPSystem.start();
        PJProxyFactory factoryProxy = new PJProxyFactory(targetClass);
        return (T)factoryProxy.newPOPObject(null, objectDescription, argvs);
    }

    public static Object newActiveFromName(String targetClass, Object ... argvs) throws POPException, ClassNotFoundException {
        return PopJava.newActive(null, Class.forName(targetClass), argvs);
    }

    public static <T> T newActive(Object parentObject, Class<T> targetClass, Object ... argvs) throws POPException {
        POPSystem.start();
        PJProxyFactory factoryProxy = new PJProxyFactory(targetClass);
        Broker parentBroker = null;
        if (parentObject != null) {
            if (parentObject instanceof POPObject) {
                parentBroker = ((POPObject)parentObject).getBroker();
            } else if (parentObject instanceof Broker) {
                parentBroker = (Broker)parentObject;
            }
        }
        return (T)factoryProxy.newPOPObject(parentBroker, argvs);
    }

    public static <T> T newActive(Object parentObject, Class<T> targetClass, POPAccessPoint accessPoint, String networkUUID) throws POPException {
        POPSystem.start();
        PJProxyFactory factoryProxy = new PJProxyFactory(targetClass);
        Broker parentBroker = null;
        if (parentObject != null) {
            if (parentObject instanceof POPObject) {
                parentBroker = ((POPObject)parentObject).getBroker();
            } else if (parentObject instanceof Broker) {
                parentBroker = (Broker)parentObject;
            }
        }
        return (T)factoryProxy.bindPOPObject(parentBroker, accessPoint, networkUUID);
    }

    public static <T> T newActive(Object parentObject, Class<T> targetClass, POPAccessPoint accessPoint) throws POPException {
        return PopJava.newActive(parentObject, targetClass, accessPoint, null);
    }

    public static <T> T newActiveConnect(Object parentObject, Class<T> targetClass, POPAccessPoint accessPoint) throws POPException {
        return PopJava.newActive(parentObject, targetClass, accessPoint);
    }

    public static <T> T connect(Object parentObject, Class<T> targetClass, String networkUUID, POPAccessPoint accessPoint) {
        return PopJava.newActive(parentObject, targetClass, accessPoint, networkUUID);
    }

    public static <T> T newActiveFromBuffer(Combox<?> sourceCombox, Class<T> targetClass, POPBuffer buffer) throws POPException {
        POPSystem.start();
        PJProxyFactory factoryProxy = new PJProxyFactory(targetClass);
        return (T)factoryProxy.newActiveFromBuffer(sourceCombox, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POPAccessPoint[] newTFCSearch(Class<?> targetClass, int maxInstances, ObjectDescription od) {
        POPSystem.start();
        od.setConnector("tfc");
        if (od.getNetwork().isEmpty()) {
            return new POPAccessPoint[0];
        }
        if (maxInstances <= 0) {
            return new POPAccessPoint[0];
        }
        POPAccessPoint[] instances = new POPAccessPoint[maxInstances];
        for (int i = 0; i < maxInstances; ++i) {
            instances[i] = new POPAccessPoint();
        }
        POPJavaJobManager jm = PopJava.connectToJM();
        try {
            jm.createObject(POPSystem.appServiceAccessPoint, targetClass.getName(), od, instances.length, instances, 0, new POPAccessPoint[0]);
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[TFC] Can't look for resources: %s", e.getCause());
            LogWriter.writeExceptionLog(e);
        }
        finally {
            jm.exit();
        }
        ArrayList<POPAccessPoint> actives = new ArrayList<POPAccessPoint>();
        for (POPAccessPoint instance : instances) {
            if (instance.isEmpty()) continue;
            actives.add(instance);
            byte[] cert = instance.getX509certificate();
            if (cert == null || cert.length <= 0) continue;
            SSLUtils.addCertToTempStore(cert);
        }
        return actives.toArray(new POPAccessPoint[actives.size()]);
    }

    private static POPJavaJobManager connectToJM() {
        Configuration conf = Configuration.getInstance();
        String protocol = conf.getJobManagerProtocols()[0];
        int port = conf.getJobManagerPorts()[0];
        POPAccessPoint jma = new POPAccessPoint(String.format("%s://%s:%d", protocol, POPSystem.getHostIP().getAddress().getHostAddress(), port));
        return PopJava.newActiveConnect(null, POPJavaJobManager.class, jma);
    }

    public static POPAccessPoint[] newTFCSearchOn(Class<?> targetClass, String networkUUID, POPNode node) {
        POPAccessPoint[] aps = new POPAccessPoint[]{};
        if (!(node instanceof POPNodeAJobManager)) {
            return aps;
        }
        POPNodeAJobManager jmNode = (POPNodeAJobManager)node;
        try {
            POPJavaJobManager jm = PopJava.connectToJM();
            aps = jm.newTFCSearchOn(jmNode.getJobManagerAccessPoint(), networkUUID, targetClass.getName());
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[TFC] Can't connect to [%s].", node);
        }
        return aps;
    }

    public static POPAccessPoint getAccessPoint(Object object) {
        if (object == null) {
            throw new NullPointerException("Reference to POPJava object was null");
        }
        if (object instanceof POPObject) {
            POPObject temp = (POPObject)object;
            return temp.getAccessPoint();
        }
        throw new RuntimeException("Object was not of type " + POPObject.class.getName());
    }

    public static <T> T getThis(T object) {
        if (object instanceof POPObject) {
            return (T)((POPObject)object).getThis(object.getClass());
        }
        return null;
    }

    public static void destroy(Object object) {
        ((POPObject)object).exit();
    }

    public static void disconnect(Object object) {
        if (object instanceof ProxyObject) {
            ((PJMethodHandler)((ProxyObject)object).getHandler()).decRef();
            ((PJMethodHandler)((ProxyObject)object).getHandler()).close();
        }
    }

    public static boolean isPOPJavaActive() {
        try {
            POPJavaAgent.getInstance();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static POPRemoteCaller getRemoteCaller() {
        return Broker.getRemoteCaller();
    }

    public static POPRemoteCaller getRemote(Object object) {
        if (object instanceof ProxyObject) {
            ProxyObject origin = (ProxyObject)object;
            return ((PJMethodHandler)origin.getHandler()).getRemote();
        }
        throw new IllegalArgumentException("The object is not a valid Proxy Object");
    }
}

