/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.annotation.processors;

import ch.icosys.popjava.core.annotation.POPAsyncConc;
import ch.icosys.popjava.core.annotation.POPAsyncMutex;
import ch.icosys.popjava.core.annotation.POPAsyncSeq;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.annotation.POPPrivate;
import ch.icosys.popjava.core.annotation.POPSyncConc;
import ch.icosys.popjava.core.annotation.POPSyncMutex;
import ch.icosys.popjava.core.annotation.POPSyncSeq;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"popjava.annotation.POPClass"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class POPClassProcessor
extends AbstractProcessor {
    private Messager messager;
    private static final TypeVisitor<Boolean, Void> SERIALIZABLE_ARGS_VISITOR = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, Void v) {
            for (TypeMirror typeMirror : t.getParameterTypes()) {
                if (typeMirror.getKind().isPrimitive()) continue;
                return false;
            }
            return true;
        }
    };
    private static final TypeVisitor<Boolean, Void> NO_ARGS_VISITOR = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, Void v) {
            return t.getParameterTypes().isEmpty();
        }
    };

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.messager = env.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        for (TypeElement typeElement : annotations) {
            this.processNoArgsConstructorClasses(env, typeElement);
        }
        return true;
    }

    private void processNoArgsConstructorClasses(RoundEnvironment env, TypeElement type) {
        for (Element element : env.getElementsAnnotatedWith(type)) {
            this.processClass(element);
        }
    }

    private void processClass(Element element) {
        POPClass popAnnotation = element.getAnnotation(POPClass.class);
        if (popAnnotation == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "POP-Class " + element + " did not have the @" + POPClass.class.getName() + " annotation", element);
            return;
        }
        if (!popAnnotation.isDistributable()) {
            return;
        }
        if (!this.doesClassContainNoArgsConstructor(element)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Class " + element + " needs a No-Args Constructor", element);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD || !element2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            this.checkPublicMethodAnnotation(element2);
        }
    }

    private void checkPublicMethodAnnotation(Element method) {
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method " + method + " can not be public and static", method);
        }
        if (method.getAnnotation(POPAsyncSeq.class) == null && method.getAnnotation(POPAsyncConc.class) == null && method.getAnnotation(POPAsyncMutex.class) == null && method.getAnnotation(POPSyncSeq.class) == null && method.getAnnotation(POPSyncConc.class) == null && method.getAnnotation(POPSyncMutex.class) == null && method.getAnnotation(POPPrivate.class) == null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Method " + method + " is public but does not have a POP-Java annotation, @" + POPSyncConc.class.getSimpleName() + " will be used", method);
            return;
        }
        MethodReturnType types = this.getMethodData(method);
        if (types.types.getKind() != TypeKind.VOID && (method.getAnnotation(POPAsyncSeq.class) != null || method.getAnnotation(POPAsyncConc.class) != null || method.getAnnotation(POPAsyncMutex.class) != null)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method " + method + " is of non void return type but is asynchronous");
        }
    }

    private MethodReturnType getMethodData(Element methodElement) {
        MethodReturnType data = new MethodReturnType();
        TypeMirror mirror = methodElement.asType();
        mirror.accept(this.visitor(data), null);
        return data;
    }

    public boolean areParametersSerializable(Element el) {
        TypeMirror mirror = el.asType();
        return mirror.accept(SERIALIZABLE_ARGS_VISITOR, null) != false;
    }

    private boolean doesClassContainNoArgsConstructor(Element el) {
        for (Element element : el.getEnclosedElements()) {
            TypeMirror mirror;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !(mirror = element.asType()).accept(NO_ARGS_VISITOR, null).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private TypeVisitor<Boolean, Void> visitor(final MethodReturnType data) {
        return new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            public Boolean visitExecutable(ExecutableType t, Void v) {
                data.types = t.getReturnType();
                return true;
            }
        };
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private class MethodReturnType {
        private TypeMirror types;

        private MethodReturnType() {
        }
    }
}

