/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.base;

import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;

public class POPException
extends RuntimeException
implements IPOPBase {
    private static final long serialVersionUID = 4815021357012126570L;
    public int errorCode;
    public String errorMessage;

    public POPException(int errorCode, String errorMessage) {
        super(errorMessage);
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    public POPException() {
        this.errorMessage = "";
        this.errorCode = 0;
    }

    public static void throwObjectNoResource() throws POPException {
        throw new POPException(10001, "Object No Resource");
    }

    public static void throwObjectBindException(POPAccessPoint accessPoint) throws POPException {
        throw new POPException(10002, "Cannot bind to access point:" + accessPoint.toString());
    }

    public static void throwBufferFormatException(Class<?> c) throws POPException {
        throw new POPException(10007, String.format("Wrong buffer format. Cannot get the class %s from buffer", c.getName()));
    }

    public static void throwReflectException(String methodName, String errorMessage) throws POPException {
        throw POPException.createReflectException(methodName, errorMessage);
    }

    public static POPException createReflectException(String methodName, String errorMessage) {
        String message = String.format("Exception while invoking method %s. More Information:%s", methodName, errorMessage);
        return new POPException(10014, message);
    }

    public static void throwReflectSerializeException(String className, String errorMessage) throws POPException {
        String message = String.format("Exception while invoking method serialize(buffer) of class %s. More Information:%s", className, errorMessage);
        throw new POPException(10015, message);
    }

    public static POPException createReflectMethodNotFoundException(String className, int classId, int methodId, String errorMessage) {
        String message = String.format("Cannot find the method id %d in class %s (%d). More Information:%s", methodId, className, classId, errorMessage);
        return new POPException(10016, message);
    }

    public static POPException throwBufferNotAvailableException() throws POPException {
        return new POPException(10016, "The buffer hasn't been initialized");
    }

    public static POPException throwComboxNotAvailableException() throws POPException {
        return new POPException(10017, "The combox hasn't been initialized");
    }

    public static POPException throwAccessPointNotAvailableException(POPAccessPoint accesspoint) throws POPException {
        String info = "null";
        if (accesspoint != null) {
            info = accesspoint.toString();
        }
        return new POPException(10018, "The accesspoint hasn't been initialized: " + info);
    }

    public static POPException throwNullObjectNotAllowException() throws POPException {
        return new POPException(10019, "Not allowed to put null object to buffer except a null array");
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.errorCode = buffer.getInt();
        this.errorMessage = buffer.getString();
        return true;
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putInt(this.errorCode);
        buffer.putString(this.errorMessage);
        return true;
    }
}

