/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.baseobject;

import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.SystemUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AccessPoint {
    public static final int DEFAULT_PORT = 12008;
    public static final String DEFAULT_HOST = "localhost";
    protected String protocol;
    protected int port;
    protected String host;

    public AccessPoint() {
        this.host = DEFAULT_HOST;
        this.port = 12008;
    }

    public AccessPoint(String protocol, String host, int port) {
        this.host = this.normalizeHostname(host);
        this.protocol = protocol;
        this.port = port;
    }

    public AccessPoint(AccessPoint accessPoint) {
        this(accessPoint.getProtocol(), accessPoint.getHost(), accessPoint.getPort());
    }

    private String normalizeHostname(String hostname) {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return hostname;
        }
        if (host != null && hostname.equals(host)) {
            return POPSystem.getHostIP().getAddress().getHostAddress();
        }
        return hostname;
    }

    public static AccessPoint create(String accessString) {
        accessString = accessString.trim();
        String protocol = "";
        String host = "";
        int port = 0;
        String[] args = accessString.split("://|:");
        String[] datas = new String[3];
        int n = 0;
        for (String arg : args) {
            String tempString = arg.trim();
            if (tempString.length() <= 0) continue;
            datas[n++] = tempString;
        }
        Configuration conf = Configuration.getInstance();
        switch (n) {
            case 3: {
                protocol = datas[0].trim();
                host = datas[1].trim();
                port = Integer.parseInt(datas[2]);
                break;
            }
            case 2: {
                if (args[0].trim().equalsIgnoreCase(conf.getDefaultProtocol())) {
                    protocol = conf.getDefaultProtocol();
                    host = datas[0].trim();
                    port = Integer.parseInt(datas[1]);
                    break;
                }
                return null;
            }
            default: {
                protocol = conf.getDefaultProtocol();
                host = DEFAULT_HOST;
                port = 12008;
            }
        }
        if (protocol.length() > 0 && host.length() > 0) {
            return new AccessPoint(protocol, host, port);
        }
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isEmpty() {
        if (this.host == null || this.host.length() == 0) {
            return true;
        }
        return this.port <= 0;
    }

    public boolean isPrivateIP() {
        return SystemUtil.isHostInPrivateSubnet(this.host);
    }

    public String toString() {
        return String.format("%s://%s:%d", this.protocol, this.host, this.port);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPoint other = (AccessPoint)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }
}

