/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.baseobject;

import ch.icosys.popjava.core.baseobject.ConnectionType;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.util.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectDescription
implements IPOPBase {
    private final Configuration conf = Configuration.getInstance();
    protected boolean isLocalJob;
    protected boolean isManual;
    protected int maxDepth;
    protected int waitTime;
    protected int maxSize;
    protected boolean searchSet;
    protected String hostarch;
    protected String hostcore;
    protected String hostuser;
    protected float powerMin;
    protected float powerReq;
    protected float bandwidthMin;
    protected float bandwidthReq;
    protected float memoryMin;
    protected float memoryReq;
    protected float wallTime;
    protected String encoding;
    protected String[] protocols;
    protected String platform;
    protected String hostName;
    protected String jobUrl;
    protected String codeFile;
    protected String directory;
    protected String batch;
    protected List<String> searchHosts = new ArrayList<String>();
    protected String remoteAccessPoint = "";
    protected POPAccessPoint originAppService = null;
    protected static final String NETWORK_KEY = "_network";
    protected static final String CONNECTOR_KEY = "_connector";
    protected String jvmParamters;
    protected ConnectionType connectionType = ConnectionType.ANY;
    protected String connectionSecret;
    protected Boolean useLocalJVM = null;
    protected boolean tracking = false;
    protected boolean upnp = false;
    private final ConcurrentHashMap<String, String> attributes = new ConcurrentHashMap();

    public ObjectDescription() {
        this.wallTime = -1.0f;
        this.encoding = "";
        this.protocols = new String[]{""};
        this.platform = "*-*";
        this.hostName = "";
        this.jobUrl = "";
        this.codeFile = "";
        this.directory = "";
        this.batch = "";
        this.waitTime = -1;
        this.hostarch = "";
        this.hostcore = "";
        this.hostuser = "";
        this.powerMin = -1.0f;
        this.powerReq = -1.0f;
        this.bandwidthMin = -1.0f;
        this.bandwidthReq = -1.0f;
        this.memoryMin = -1.0f;
        this.memoryReq = -1.0f;
        this.setNetwork("");
        this.setConnector("");
    }

    public ObjectDescription(ObjectDescription od) {
        this.powerMin = od.getPowerMin();
        this.powerReq = od.getPowerReq();
        this.memoryMin = od.getMemoryMin();
        this.memoryReq = od.getMemoryReq();
        this.bandwidthMin = od.getBandwidthMin();
        this.bandwidthReq = od.getBandwidthReq();
        this.wallTime = od.getWallTime();
        this.encoding = od.getEncoding();
        this.protocols = od.getProtocols();
        this.platform = od.getPlatform();
        this.hostName = od.getHostName();
        this.jobUrl = od.getJobUrl();
        this.codeFile = od.getCodeFile();
        this.hostuser = od.getHostuser();
        this.hostarch = od.getHostarch();
        this.hostcore = od.getHostcore();
        this.maxDepth = od.getSearchMaxDepth();
        this.maxSize = od.getSearchMaxSize();
        this.waitTime = od.getSearchWaitTime();
        this.setNetwork(od.getNetwork());
        this.setConnector(od.getConnector());
        this.useLocalJVM = od.useLocalJVM();
        this.searchHosts.addAll(od.searchHosts);
    }

    public boolean useLocalJVM() {
        if (this.useLocalJVM == null) {
            return false;
        }
        return this.useLocalJVM;
    }

    public void setUseLocalJVM(boolean localJVM) {
        this.useLocalJVM = localJVM;
    }

    public void setDirectory(String d) {
        this.directory = d;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setPower(float required, float min) {
        this.powerMin = min;
        this.powerReq = required;
    }

    public void setMemory(float required, float min) {
        this.memoryMin = min;
        this.memoryReq = required;
    }

    public void setBandwidth(float required, float min) {
        this.bandwidthMin = min;
        this.bandwidthReq = required;
    }

    public void setWallTime(float walltime) {
        this.wallTime = walltime;
    }

    public void setSearchHosts(String ... searchHosts) {
        this.searchHosts.clear();
        this.searchHosts.addAll(Arrays.asList(searchHosts));
    }

    public void addSearchHosts(String searchHost) {
        this.searchHosts.add(searchHost);
    }

    public String[] getSearchHosts() {
        return this.searchHosts.toArray(new String[this.searchHosts.size()]);
    }

    public void manual(boolean a) {
        this.isManual = a;
    }

    public void setSearch(int maxdepth, int maxsize, int waittime) {
        this.searchSet = true;
        this.maxDepth = maxdepth;
        this.maxSize = maxsize;
        this.waitTime = waittime;
    }

    public int getSearchMaxDepth() {
        return this.maxDepth;
    }

    public int getSearchMaxSize() {
        return this.maxSize;
    }

    public int getSearchWaitTime() {
        return this.waitTime;
    }

    public boolean isSearchSet() {
        return this.searchSet;
    }

    public void setHostname(String hostname) {
        this.hostName = hostname;
    }

    public void setHostarch(String arch) {
        this.hostarch = arch;
    }

    public String getHostarch() {
        return this.hostarch;
    }

    public void setHostcore(String core) {
        this.hostcore = core;
    }

    public String getHostcore() {
        return this.hostcore;
    }

    public void setHostuser(String user) {
        this.hostuser = user;
    }

    public String getHostuser() {
        return this.hostuser;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatch() {
        return this.batch;
    }

    public void setJobUrl(String jobUrl) {
        this.jobUrl = jobUrl;
    }

    public void setCodeFile(String codeFile) {
        this.codeFile = codeFile;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setJVMParamters(String parameters) {
        this.jvmParamters = parameters;
    }

    public void setConnectionType(ConnectionType type) {
        this.connectionType = type;
    }

    public void setConnectionSecret(String secret) {
        this.connectionSecret = secret;
    }

    public float getPowerMin() {
        return this.powerMin;
    }

    public float getPowerReq() {
        return this.powerReq;
    }

    public float getMemoryMin() {
        return this.memoryMin;
    }

    public float getMemoryReq() {
        return this.memoryReq;
    }

    public float getBandwidthMin() {
        return this.bandwidthMin;
    }

    public float getBandwidthReq() {
        return this.bandwidthReq;
    }

    public float getWallTime() {
        return this.wallTime;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getJobUrl() {
        return this.jobUrl;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getJVMParameters() {
        return this.jvmParamters;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getConnectionSecret() {
        return this.connectionSecret;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getCodeFile() {
        return this.codeFile;
    }

    public String getNetwork() {
        return this.getValue(NETWORK_KEY);
    }

    public void setNetwork(String network) {
        this.setValue(NETWORK_KEY, network);
    }

    public String getConnector() {
        return this.getValue(CONNECTOR_KEY);
    }

    public void setConnector(String connector) {
        if (connector.isEmpty()) {
            connector = this.conf.getJobManagerDefaultConnector();
        }
        this.setValue(CONNECTOR_KEY, connector);
    }

    public void setValue(String key, String value) {
        if (this.attributes.containsKey(key)) {
            if (value == null) {
                this.attributes.remove(key);
            } else {
                this.attributes.replace(key, value);
            }
        } else {
            this.attributes.put(key, value);
        }
    }

    public String getValue(String key) {
        return this.attributes.getOrDefault(key, "");
    }

    public void removeValue(String key) {
        if (this.attributes.containsKey(key)) {
            this.attributes.remove(key);
        }
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public void setRemoteAccessPoint(String accessPoint) {
        this.remoteAccessPoint = accessPoint;
    }

    public String getRemoteAccessPoint() {
        return this.remoteAccessPoint;
    }

    public POPAccessPoint getOriginAppService() {
        return this.originAppService;
    }

    public void setOriginAppService(POPAccessPoint originAppService) {
        this.originAppService = originAppService;
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setUPNP(boolean upnp) {
        this.upnp = upnp;
    }

    public boolean isUPNPEnabled() {
        return this.upnp;
    }

    public boolean isEmpty() {
        return this.powerMin <= 0.0f && this.powerReq <= 0.0f && this.bandwidthMin <= 0.0f && this.bandwidthReq <= 0.0f && this.memoryMin <= 0.0f && this.memoryReq <= 0.0f && this.wallTime <= 0.0f && this.encoding.isEmpty() && this.platform.isEmpty() && this.hostName.isEmpty() && this.jobUrl.isEmpty() && this.codeFile.isEmpty() && (this.protocols.length == 0 || this.protocols.length == 1 && this.protocols[0].isEmpty());
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        float tmpPowerReq = buffer.getFloat();
        float tmpPowerMin = buffer.getFloat();
        float tmpMemoryReq = buffer.getFloat();
        float tmpMemoryMin = buffer.getFloat();
        float tmpBandwidthReq = buffer.getFloat();
        float tmpBandwidthMin = buffer.getFloat();
        float walltime = buffer.getFloat();
        boolean isManual = buffer.getBoolean();
        String cwd = buffer.getString();
        int maxDepth = buffer.getInt();
        int maxSize = buffer.getInt();
        int waitTime = buffer.getInt();
        String hostName = buffer.getString();
        String hostuser = buffer.getString();
        String hostCore = buffer.getString();
        String hostArch = buffer.getString();
        String batch = buffer.getString();
        String jobUrl = buffer.getString();
        String codeFile = buffer.getString();
        String platform = buffer.getString();
        String[] protocols = buffer.getArray(String[].class);
        String encoding = buffer.getString();
        this.setPower(tmpPowerReq, tmpPowerMin);
        this.setMemory(tmpMemoryReq, tmpMemoryMin);
        this.setBandwidth(tmpBandwidthReq, tmpBandwidthMin);
        this.setWallTime(walltime);
        this.manual(isManual);
        this.setDirectory(cwd);
        this.setSearch(maxDepth, maxSize, waitTime);
        this.setHostname(hostName);
        this.setHostuser(hostuser);
        this.setHostcore(hostCore);
        this.setHostarch(hostArch);
        this.setBatch(batch);
        this.setJobUrl(jobUrl);
        this.setCodeFile(codeFile);
        this.setPlatform(platform);
        this.setProtocols(protocols);
        this.setEncoding(encoding);
        int hostsNum = buffer.getInt();
        for (int i = 0; i < hostsNum; ++i) {
            this.searchHosts.add(buffer.getString());
        }
        this.attributes.clear();
        int attributeCount = buffer.getInt();
        for (int i = 0; i < attributeCount; ++i) {
            String key = buffer.getString();
            String value = buffer.getString();
            this.setValue(key, value);
        }
        return true;
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putFloat(this.powerReq);
        buffer.putFloat(this.powerMin);
        buffer.putFloat(this.memoryReq);
        buffer.putFloat(this.memoryMin);
        buffer.putFloat(this.bandwidthReq);
        buffer.putFloat(this.bandwidthMin);
        buffer.putFloat(this.wallTime);
        buffer.putBoolean(this.isManual);
        buffer.putString(this.directory);
        buffer.putInt(this.maxDepth);
        buffer.putInt(this.maxSize);
        buffer.putInt(this.waitTime);
        buffer.putString(this.hostName);
        buffer.putString(this.hostuser);
        buffer.putString(this.hostcore);
        buffer.putString(this.hostarch);
        buffer.putString(this.batch);
        buffer.putString(this.jobUrl);
        buffer.putString(this.codeFile);
        buffer.putString(this.platform);
        buffer.putArray(this.protocols);
        buffer.putString(this.encoding);
        buffer.putInt(this.searchHosts.size());
        for (String searchHost : this.searchHosts) {
            buffer.putString(searchHost);
        }
        buffer.putInt(this.attributes.size());
        Enumeration<String> keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            buffer.putString(key);
            buffer.putString(this.attributes.get(key));
        }
        return true;
    }

    public void merge(ObjectDescription od) {
        if (od.getPowerMin() > 0.0f && od.getPowerReq() > 0.0f) {
            this.setPower(od.getPowerMin(), od.getPowerReq());
        }
        if (od.getBandwidthMin() > 0.0f && od.getBandwidthReq() > 0.0f) {
            this.setBandwidth(od.getBandwidthReq(), od.getBandwidthMin());
        }
        if (od.getMemoryMin() > 0.0f && od.getMemoryReq() > 0.0f) {
            this.setMemory(od.getMemoryReq(), od.getMemoryMin());
        }
        if (od.getWallTime() > 0.0f) {
            this.wallTime = od.getWallTime();
        }
        if (od.getEncoding().length() > 0) {
            this.encoding = od.getEncoding();
        }
        if (this.protocols == null || this.protocols.length == 0 || this.protocols[0].isEmpty() || od.getProtocols().length > this.protocols.length) {
            this.protocols = od.getProtocols();
        }
        if (od.getPlatform().length() > 0) {
            this.platform = od.getPlatform();
        }
        if (od.getHostName().length() > 0) {
            this.hostName = od.getHostName();
        }
        if (od.getJobUrl().length() > 0) {
            this.jobUrl = od.getJobUrl();
        }
        if (od.getCodeFile().length() > 0) {
            this.codeFile = od.getCodeFile();
        }
        if (od.getSearchMaxDepth() > 0) {
            this.maxDepth = od.getSearchMaxDepth();
        }
        if (od.getSearchMaxSize() > 0) {
            this.maxSize = od.getSearchMaxSize();
        }
        if (od.getSearchWaitTime() > 0) {
            this.waitTime = od.getSearchWaitTime();
        }
        if (od.useLocalJVM != null) {
            this.useLocalJVM = od.useLocalJVM;
        }
        if (this.getNetwork() == null || this.getNetwork().isEmpty()) {
            this.setNetwork(od.getNetwork());
        }
        if (this.getConnector() == null || this.getConnector().isEmpty()) {
            this.setConnector(od.getConnector());
        }
        if (!this.tracking && od.tracking) {
            this.tracking = true;
        }
        this.searchHosts.addAll(od.searchHosts);
        this.upnp = this.upnp || od.upnp;
    }

    public String toString() {
        return "od";
    }
}

