/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.baseobject;

import ch.icosys.popjava.core.baseobject.POPTrackingMethod;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class POPTracking
implements IPOPBase {
    private POPRemoteCaller caller;
    private final Map<String, POPTrackingMethod> calls;

    public POPTracking() {
        this(null);
    }

    public POPTracking(POPRemoteCaller caller) {
        this.caller = caller;
        this.calls = new HashMap<String, POPTrackingMethod>();
    }

    public POPRemoteCaller getCaller() {
        return this.caller;
    }

    public List<POPTrackingMethod> getCalls() {
        POPTrackingMethod[] data = this.calls.values().toArray(new POPTrackingMethod[this.calls.size()]);
        return Arrays.asList(data);
    }

    public synchronized void track(String method, long time, int inputSize, int outputSize) {
        POPTrackingMethod recorder = this.calls.get(method);
        if (recorder == null) {
            recorder = new POPTrackingMethod(method);
            this.calls.put(method, recorder);
        }
        recorder.increment(time, inputSize, outputSize);
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        this.caller.serialize(buffer);
        buffer.putInt(this.calls.size());
        for (POPTrackingMethod call : this.calls.values()) {
            call.serialize(buffer);
        }
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.caller = (POPRemoteCaller)buffer.getValue(POPRemoteCaller.class);
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            POPTrackingMethod method = new POPTrackingMethod();
            method.deserialize(buffer);
            this.calls.put(method.getMethod(), method);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.caller).append("\n");
        for (POPTrackingMethod value : this.calls.values()) {
            sb.append(value).append("\n");
        }
        return sb.toString();
    }
}

