/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.broker;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.annotation.POPAsyncConc;
import ch.icosys.popjava.core.annotation.POPAsyncMutex;
import ch.icosys.popjava.core.annotation.POPAsyncSeq;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.annotation.POPParameter;
import ch.icosys.popjava.core.annotation.POPSyncConc;
import ch.icosys.popjava.core.annotation.POPSyncMutex;
import ch.icosys.popjava.core.annotation.POPSyncSeq;
import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.base.MethodInfo;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.baseobject.POPTracking;
import ch.icosys.popjava.core.broker.Request;
import ch.icosys.popjava.core.broker.RequestQueue;
import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.BufferFactoryFinder;
import ch.icosys.popjava.core.buffer.BufferXDR;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.combox.ComboxConnection;
import ch.icosys.popjava.core.combox.ComboxFactory;
import ch.icosys.popjava.core.combox.ComboxFactoryFinder;
import ch.icosys.popjava.core.combox.ComboxServer;
import ch.icosys.popjava.core.javaagent.POPJavaAgent;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.MethodUtil;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import ch.icosys.popjava.core.util.RuntimeDirectoryThread;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import ch.icosys.popjava.core.util.upnp.UPNPManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javassist.NotFoundException;
import javassist.util.proxy.ProxyObject;

public final class Broker {
    public static final int REQUEST_QUEUE_TIMEOUT_MS = 600;
    public static final int BASIC_CALL_MAX_RANGE = 10;
    public static final int CONSTRUCTOR_SEMANTIC_ID = 21;
    public static final String CALLBACK_PREFIX = "-callback=";
    public static final String CODELOCATION_PREFIX = "-codelocation=";
    public static final String OBJECT_NAME_PREFIX = "-object=";
    public static final String ACTUAL_OBJECT_NAME_PREFIX = "-actualobject=";
    public static final String APPSERVICE_PREFIX = "-appservice=";
    public static final String JOB_SERVICE = "-jobservice=";
    public static final String POPJAVA_CONFIG_PREFIX = "-configfile=";
    public static final String NETWORK_UUID = "-network=";
    public static final String TRACKING = "-tracking";
    public static final String UPNP = "-upnp";
    private static final ThreadLocal<POPRemoteCaller> remoteCaller = new InheritableThreadLocal<POPRemoteCaller>();
    private final RequestQueue requestQueue = new RequestQueue();
    private State state;
    private ComboxServer[] comboxServers;
    private POPBuffer buffer;
    private POPAccessPoint accessPoint = new POPAccessPoint();
    private POPObject popObject = null;
    private POPObject popInfo = null;
    private int connectionCount = 0;
    private final Semaphore sequentialSemaphore = new Semaphore(1, true);
    private boolean tracking;
    private boolean upnp;
    private final Map<Method, Annotation[][]> methodParametersAnnotationCache = new HashMap<Method, Annotation[][]>();
    private final Map<Method, Integer> methodSemanticsCache = new HashMap<Method, Integer>();
    private final Map<POPRemoteCaller, POPTracking> callerTracking = new ConcurrentHashMap<POPRemoteCaller, POPTracking>();
    private final ExecutorService threadPoolSequential = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable arg0) {
            Thread thread = Executors.defaultThreadFactory().newThread(arg0);
            thread.setName("Sequential request thread");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final ExecutorService threadPoolConcurrent = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 50, new ThreadFactory(){
        private int threadIndex = 0;

        @Override
        public Thread newThread(Runnable arg0) {
            Thread thread = Executors.defaultThreadFactory().newThread(arg0);
            thread.setName("Concurrent request thread " + this.threadIndex++);
            thread.setDaemon(true);
            return thread;
        }
    });

    public Broker(POPObject object) {
        this.popObject = object;
        this.popObject.setBroker(this);
        ++this.connectionCount;
        String[] protocols = this.popObject.getOd().getProtocols();
        ArrayList<String> initParams = new ArrayList<String>();
        if (protocols != null && protocols.length > 0) {
            ComboxFactoryFinder finder = ComboxFactoryFinder.getInstance();
            for (String protocol : protocols) {
                String[] split = protocol.split(":");
                ComboxFactory factory = finder.findFactory(split[0]);
                int port = 0;
                if (split.length == 2) {
                    try {
                        port = Integer.parseInt(split[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (factory == null) continue;
                initParams.add(String.format("-%s_port=%d", factory.getComboxName(), port));
            }
        }
        if (this.popObject.getOd().isTracking()) {
            initParams.add(TRACKING);
        }
        if (this.popObject.getOd().isUPNPEnabled()) {
            initParams.add(UPNP);
        }
        initParams.add(NETWORK_UUID + this.popObject.getOd().getNetwork());
        this.initialize(initParams);
        this.popInfo = object;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Broker.this.treatRequests();
                    Broker.this.close();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("EXITING BROKER " + Broker.this.popInfo.getClassName());
            }
        }, "Local JVM Broker thread").start();
    }

    private Broker(String codelocation, String objectName) {
        URLClassLoader urlClassLoader = null;
        if (codelocation != null && codelocation.length() > 0) {
            URL url = null;
            if (codelocation.startsWith("http:")) {
                try {
                    URL website = new URL(codelocation);
                    ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                    File tempJar = File.createTempFile(website.getFile(), ".jar");
                    FileOutputStream fos = new FileOutputStream(tempJar);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    fos.close();
                    codelocation = tempJar.getAbsolutePath();
                    tempJar.deleteOnExit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
            try {
                LogWriter.writeDebugInfo("[Broker] Local file '%s'", codelocation);
                url = new File(codelocation).toURI().toURL();
                POPJavaAgent.getInstance().addJar(codelocation);
            }
            catch (MalformedURLException e) {
                LogWriter.writeDebugInfo("[Broker] %s.MalformedURLException : %s", this.getClass().getName(), e.getMessage());
                System.exit(0);
            }
            catch (NotFoundException e) {
                e.printStackTrace();
                System.exit(0);
            }
            if (url != null) {
                LogWriter.writeDebugInfo("[Broker] url construct");
                urlClassLoader = new URLClassLoader(new URL[]{url});
            }
        }
        if (urlClassLoader != null) {
            Util.urlClassloaders.add(urlClassLoader);
        }
        try {
            Class<?> targetClass = this.getPOPObjectClass(objectName, urlClassLoader);
            this.popInfo = (POPObject)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[Broker] %s ; Mesage: %s", e.getClass().getName(), e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private boolean invokeConstructor(Request request) {
        Class<?>[] parameterTypes = null;
        Object[] parameters = null;
        Constructor<?> constructor = null;
        POPException exception = null;
        try {
            MethodInfo info = new MethodInfo(request.getClassId(), request.getMethodId());
            constructor = this.popInfo.getConstructorByInfo(info);
        }
        catch (NoSuchMethodException e) {
            exception = POPException.createReflectMethodNotFoundException(this.popInfo.getClass().getName(), request.getClassId(), request.getMethodId(), e.getMessage());
        }
        if (exception == null && constructor != null) {
            parameterTypes = constructor.getParameterTypes();
            try {
                POPBuffer requestBuffer = request.getBuffer();
                request.setBuffer(null);
                parameters = this.getParameters(request.getConnection().getCombox(), requestBuffer, parameterTypes, constructor.getParameterAnnotations());
            }
            catch (POPException e) {
                exception = e;
            }
        }
        this.normalizePOPParamameters(parameters);
        if (exception == null && constructor != null) {
            try {
                this.popObject = (POPObject)constructor.newInstance(parameters);
                this.popObject.setBroker(this);
                POPClass annotation = this.popObject.getClass().getAnnotation(POPClass.class);
                if (annotation != null) {
                    this.requestQueue.setMaxQueue(annotation.maxRequestQueue());
                }
            }
            catch (Exception e) {
                exception = POPException.createReflectException(constructor.getName(), e.getMessage());
            }
        }
        if (exception == null && constructor != null && parameterTypes != null && parameters != null) {
            if ((request.getSemantics() & 1) != 0) {
                MessageHeader messageHeader = new MessageHeader();
                messageHeader.setRequestID(request.getRequestID());
                POPBuffer responseBuffer = request.getConnection().getCombox().getBufferFactory().createBuffer();
                responseBuffer.setHeader(messageHeader);
                Annotation[][] annotations = constructor.getParameterAnnotations();
                for (int index = 0; index < parameterTypes.length; ++index) {
                    if (!Util.isParameterNotOfDirection(annotations[index], POPParameter.Direction.IN) || !Util.isParameterUsable(annotations[index]) || parameters[index] instanceof POPObject && !Util.isParameterOfAnyDirection(annotations[index])) continue;
                    try {
                        responseBuffer.serializeReferenceObject(parameterTypes[index], parameters[index]);
                        continue;
                    }
                    catch (POPException e) {
                        exception = new POPException(e.errorCode, e.errorMessage);
                        break;
                    }
                }
                if (exception == null) {
                    this.sendResponse(request.getConnection(), responseBuffer);
                }
            }
            for (int index = 0; index < parameterTypes.length; ++index) {
                POPObject obj;
                if (!POPObject.class.isAssignableFrom(parameterTypes[index]) || parameters[index] == null || !(obj = (POPObject)parameters[index]).isTemporary()) continue;
                obj.exit();
            }
        }
        if (exception != null) {
            LogWriter.writeDebugInfo("[Broker] %s sendException: %s", this.getLogPrefix(), exception.getMessage());
            this.sendException(request.getConnection(), exception, request.getRequestID());
            System.exit(0);
        }
        return true;
    }

    private Object[] getParameters(Combox<?> sourceCombox, POPBuffer requestBuffer, Class<?>[] parameterTypes, Annotation[][] annotations) throws POPException {
        Object[] parameters = new Object[parameterTypes.length];
        int index = 0;
        for (index = 0; index < parameterTypes.length; ++index) {
            if (!Util.isParameterNotOfDirection(annotations[index], POPParameter.Direction.OUT) || !Util.isParameterUsable(annotations[index])) continue;
            try {
                parameters[index] = requestBuffer.getValue(sourceCombox, parameterTypes[index]);
                continue;
            }
            catch (POPException e) {
                e.printStackTrace();
                throw new POPException(e.errorCode, e.errorMessage);
            }
            catch (Exception e) {
                throw new POPException(10020, "Unknown exception when get parameter " + parameterTypes[index].getName());
            }
        }
        return parameters;
    }

    public void finalizeRequest(Request request) {
        try {
            if ((request.getSemantics() & 4) != 0) {
                return;
            }
            MethodInfo info = new MethodInfo(request.getClassId(), request.getMethodId());
            Method method = this.popInfo.getMethodByInfo(info);
            if (this.methodSemanticsCache.containsKey(method)) {
                request.setSemantics(this.methodSemanticsCache.get(method));
                return;
            }
            Annotation[] annotations = method.getAnnotations();
            int semantics = 0;
            boolean isLocalhost = false;
            POPSyncConc syncConc = MethodUtil.getAnnotation(annotations, POPSyncConc.class);
            if (syncConc != null) {
                semantics = 9;
                isLocalhost = syncConc.localhost();
            } else {
                POPSyncSeq syncSeq = MethodUtil.getAnnotation(annotations, POPSyncSeq.class);
                if (syncSeq != null) {
                    semantics = 1;
                    isLocalhost = syncSeq.localhost();
                } else {
                    POPSyncMutex syncMutex = MethodUtil.getAnnotation(annotations, POPSyncMutex.class);
                    if (syncMutex != null) {
                        semantics = 17;
                        isLocalhost = syncMutex.localhost();
                    } else {
                        POPAsyncConc asyncConc = MethodUtil.getAnnotation(annotations, POPAsyncConc.class);
                        if (asyncConc != null) {
                            semantics = 8;
                            isLocalhost = asyncConc.localhost();
                        } else {
                            POPAsyncSeq asyncSeq = MethodUtil.getAnnotation(annotations, POPAsyncSeq.class);
                            if (asyncSeq != null) {
                                semantics = 0;
                                isLocalhost = asyncSeq.localhost();
                            } else {
                                POPAsyncMutex asyncMutex = MethodUtil.getAnnotation(annotations, POPAsyncMutex.class);
                                if (asyncMutex != null) {
                                    semantics = 16;
                                    isLocalhost = asyncMutex.localhost();
                                } else {
                                    semantics = request.getSemantics();
                                }
                            }
                        }
                    }
                }
            }
            if (isLocalhost) {
                semantics |= 0x100;
            }
            request.setSemantics(semantics);
            this.methodSemanticsCache.put(method, semantics);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeMethod(Request request) throws InterruptedException {
        if (request.isSequential()) {
            this.sequentialSemaphore.acquire();
        }
        Object result = new Object();
        POPException exception = null;
        Method method = null;
        Class<?> returnType = null;
        Class<?>[] parameterTypes = null;
        Object[] parameters = null;
        int index = 0;
        MethodInfo info = new MethodInfo(request.getClassId(), request.getMethodId());
        try {
            method = this.popInfo.getMethodByInfo(info);
        }
        catch (NoSuchMethodException e) {
            exception = POPException.createReflectMethodNotFoundException(this.popInfo.getClass().getName(), request.getClassId(), request.getMethodId(), e.getMessage());
            this.popInfo.printMethodInfo();
            System.out.println(this.accessPoint);
        }
        if (method != null && !this.methodParametersAnnotationCache.containsKey(method)) {
            this.methodParametersAnnotationCache.put(method, method.getParameterAnnotations());
        }
        Annotation[][] parametersAnnotations = this.methodParametersAnnotationCache.get(method);
        int inputSize = 0;
        if (exception == null && method != null) {
            returnType = method.getReturnType();
            parameterTypes = method.getParameterTypes();
            try {
                POPBuffer requestBuffer = request.getBuffer();
                if (this.tracking) {
                    inputSize = requestBuffer.size();
                }
                request.setBuffer(null);
                parameters = this.getParameters(request.getConnection().getCombox(), requestBuffer, parameterTypes, parametersAnnotations);
            }
            catch (POPException e) {
                exception = e;
            }
        }
        this.normalizePOPParamameters(parameters);
        long trackingTime = 0L;
        POPRemoteCaller remote = null;
        if (this.tracking) {
            remote = request.getConnection().getRemoteCaller();
        }
        if (exception == null && method != null) {
            long trackingStart = System.currentTimeMillis();
            try {
                method.setAccessible(true);
                if (returnType != Void.class && returnType != Void.TYPE) {
                    result = method.invoke((Object)this.popObject, parameters);
                } else {
                    method.invoke((Object)this.popObject, parameters);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                LogWriter.writeExceptionLog(e);
                LogWriter.writeExceptionLog(e.getCause());
                LogWriter.writeDebugInfo("[Broker] Cannot execute. Cause %s.", e.getCause().getMessage());
                exception = POPException.createReflectException(method.getName(), e.getCause().getMessage());
            }
            catch (Exception e) {
                LogWriter.writeExceptionLog(e);
                LogWriter.writeDebugInfo("[Broker] Cannot execute %s", method.toGenericString());
                exception = POPException.createReflectException(method.getName(), e.getMessage());
            }
            finally {
                if (this.tracking) {
                    trackingTime = System.currentTimeMillis() - trackingStart;
                }
            }
        }
        int outputSize = 0;
        if (exception == null && method != null && parameterTypes != null && parameters != null) {
            if (request.isSynchronous()) {
                MessageHeader messageHeader = new MessageHeader();
                messageHeader.setRequestID(request.getRequestID());
                POPBuffer responseBuffer = request.getConnection().getCombox().getBufferFactory().createBuffer();
                responseBuffer.setHeader(messageHeader);
                for (index = 0; index < parameterTypes.length; ++index) {
                    if (!Util.isParameterNotOfDirection(parametersAnnotations[index], POPParameter.Direction.IN) || !Util.isParameterUsable(parametersAnnotations[index]) || parameters[index] instanceof POPObject && !Util.isParameterOfAnyDirection(parametersAnnotations[index])) continue;
                    try {
                        responseBuffer.serializeReferenceObject(parameterTypes[index], parameters[index]);
                        continue;
                    }
                    catch (POPException e) {
                        LogWriter.writeDebugInfo("[Broker] Exception serializing parameter %s", parameterTypes[index].getName());
                        exception = new POPException(e.errorCode, e.errorMessage);
                        break;
                    }
                }
                if (exception == null && returnType != Void.class && returnType != Void.TYPE && returnType != Void.TYPE) {
                    try {
                        if (result instanceof POPObject) {
                            POPObject returnObject = (POPObject)result;
                            POPAccessPoint objAp = returnObject.getAccessPoint();
                            String originFingerprint = objAp.getFingerprint();
                            if (originFingerprint != null) {
                                Certificate originCert = SSLUtils.getCertificate(originFingerprint);
                                objAp.setX509certificate(SSLUtils.certificateBytes(originCert));
                                String destinationFingerprint = request.getConnection().getAccessPoint().getFingerprint();
                                Certificate destCert = SSLUtils.getCertificate(destinationFingerprint);
                                returnObject.PopRegisterFutureConnectorCertificate(SSLUtils.certificateBytes(destCert));
                            }
                            returnObject.getOd().setNetwork(request.getConnection().getNetworkUUID());
                        }
                        responseBuffer.putValue(result, returnType);
                    }
                    catch (POPException e) {
                        exception = e;
                    }
                }
                if (exception == null) {
                    if (this.tracking) {
                        outputSize = responseBuffer.size();
                    }
                    this.sendResponse(request.getConnection(), responseBuffer);
                }
            }
            for (index = 0; index < parameterTypes.length; ++index) {
                POPObject object;
                if (!POPObject.class.isAssignableFrom(parameterTypes[index]) || parameters[index] == null || !(object = (POPObject)parameters[index]).isTemporary()) continue;
                LogWriter.writeDebugInfo("[Broker] Exit popobject");
                object.exit();
            }
        }
        if (this.tracking && remote != null && method != null) {
            this.registerTracking(remote, method.toGenericString(), trackingTime, inputSize, outputSize);
        }
        if (exception != null) {
            LogWriter.writeDebugInfo("[Broker] %s sendException: %s.", this.getLogPrefix(), exception.getMessage());
            if (request.isSynchronous()) {
                this.sendException(request.getConnection(), exception, request.getRequestID());
            }
        }
        if (request.isSequential()) {
            this.sequentialSemaphore.release();
        }
        return true;
    }

    private void normalizePOPParamameters(Object[] parameters) {
        for (int i = 0; parameters != null && i < parameters.length; ++i) {
            if (!(parameters[i] instanceof POPObject)) continue;
            POPObject object = (POPObject)parameters[i];
            if (!(parameters[i] instanceof ProxyObject)) {
                object = (POPObject)PopJava.newActiveConnect(this, object.getClass(), object.getAccessPoint());
            }
            object.makeTemporary();
            parameters[i] = object;
        }
    }

    public boolean invoke(Request request) throws InterruptedException {
        POPRemoteCaller caller = request.getRemoteCaller();
        remoteCaller.set(caller);
        if (request.isLocalhost() && !caller.isLocalHost(this.accessPoint)) {
            if (request.isSynchronous()) {
                POPException exception = new POPException(10021, "You can't call a localhost method from a remote location. " + caller.getRemote().getHostAddress());
                this.sendException(request.getConnection(), exception, request.getRequestID());
            }
        } else if ((request.getSemantics() & 4) != 0) {
            this.invokeConstructor(request);
        } else {
            this.invokeMethod(request);
        }
        request.setStatus(2);
        this.clearResourceAfterInvoke(request);
        return true;
    }

    public void clearResourceAfterInvoke(Request request) {
        request.getRequestQueue().remove(request);
    }

    public void serveRequest(final Request request) throws InterruptedException {
        request.setBroker(this);
        request.setStatus(1);
        if (request.isMutex()) {
            this.invoke(request);
        } else {
            Runnable popRequest = new Runnable(){

                @Override
                public void run() {
                    try {
                        Broker.this.invoke(request);
                    }
                    catch (InterruptedException e) {
                        LogWriter.writeExceptionLog(e);
                    }
                }
            };
            if (request.isConcurrent()) {
                this.threadPoolConcurrent.execute(popRequest);
            } else {
                this.threadPoolSequential.execute(popRequest);
            }
        }
    }

    public boolean popCall(Request request) {
        if (request.getMethodId() >= 10) {
            return false;
        }
        POPBuffer buffer = request.getBuffer();
        POPBuffer responseBuffer = request.getConnection().getCombox().getBufferFactory().createBuffer();
        switch (request.getMethodId()) {
            case 0: {
                if ((request.getSemantics() & 1) == 0) break;
                MessageHeader messageHeader = new MessageHeader();
                messageHeader.setRequestID(request.getRequestID());
                responseBuffer.setHeader(messageHeader);
                responseBuffer.putInt(0);
                responseBuffer.putString(POPSystem.getPlatform());
                responseBuffer.putString(BufferFactoryFinder.getInstance().getSupportingBuffer());
                this.sendResponse(request.getConnection(), responseBuffer);
                break;
            }
            case 1: {
                if (this.popInfo == null) {
                    return false;
                }
                int ret = 1;
                if ((request.getSemantics() & 1) == 0) break;
                MessageHeader messageHeader = new MessageHeader();
                messageHeader.setRequestID(request.getRequestID());
                responseBuffer.setHeader(messageHeader);
                responseBuffer.putInt(ret);
                this.sendResponse(request.getConnection(), responseBuffer);
                break;
            }
            case 2: {
                if (this.popInfo == null) {
                    return false;
                }
                int ret = 1;
                if ((request.getSemantics() & 1) == 0) break;
                MessageHeader messageHeader = new MessageHeader();
                messageHeader.setRequestID(request.getRequestID());
                responseBuffer.setHeader(messageHeader);
                responseBuffer.putInt(ret);
                this.sendResponse(request.getConnection(), responseBuffer);
                break;
            }
            case 3: {
                String encoding = buffer.getString();
                boolean foundEncoding = this.findEndcoding(encoding);
                if ((request.getSemantics() & 1) != 0) {
                    MessageHeader messageHeader = new MessageHeader();
                    messageHeader.setRequestID(request.getRequestID());
                    responseBuffer.setHeader(messageHeader);
                    responseBuffer.putBoolean(foundEncoding);
                    this.sendResponse(request.getConnection(), responseBuffer);
                }
                if (!foundEncoding) break;
                request.setBufferType(encoding);
                BufferFactory bufferFactory = BufferFactoryFinder.getInstance().findFactory(encoding);
                request.getConnection().getCombox().setBufferFactory(bufferFactory);
                break;
            }
            case 4: {
                if (this.popInfo == null || !this.popInfo.canKill()) break;
                System.exit(1);
                break;
            }
            case 5: {
                if (this.popInfo == null) {
                    return false;
                }
                if ((request.getSemantics() & 1) == 0) break;
                MessageHeader messageHeader = new MessageHeader();
                messageHeader.setRequestID(request.getRequestID());
                responseBuffer.setHeader(messageHeader);
                boolean isAlive = true;
                responseBuffer.putBoolean(isAlive);
                this.sendResponse(request.getConnection(), responseBuffer);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public synchronized void kill() {
        this.setState(State.Exit);
    }

    private void close() {
        if (this.comboxServers == null) {
            return;
        }
        for (ComboxServer comboxServer : this.comboxServers) {
            comboxServer.close();
        }
    }

    public POPAccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public void treatRequests() throws InterruptedException {
        this.setState(State.Running);
        while (this.getState() == State.Running) {
            Request request = this.requestQueue.pick(600, TimeUnit.MILLISECONDS);
            if (request == null || request.getClassId() == 0 || request.getMethodId() == 0) continue;
            this.serveRequest(request);
        }
        LogWriter.writeDebugInfo("[Broker] Close broker " + this.popInfo.getClassName());
    }

    public synchronized void onNewConnection() {
        ++this.connectionCount;
        LogWriter.writeDebugInfo("[Broker] Open connection " + this.connectionCount);
    }

    public synchronized void onCloseConnection(String source) {
        --this.connectionCount;
        LogWriter.writeDebugInfo("[Broker] Close connection, left " + this.connectionCount + " " + source);
        if (this.connectionCount <= 0) {
            this.setState(State.Exit);
        }
    }

    public boolean isDaemon() {
        return this.popInfo == null || this.popInfo.isDaemon();
    }

    public boolean isTraking() {
        return this.tracking;
    }

    public static POPRemoteCaller getRemoteCaller() {
        return remoteCaller.get();
    }

    public synchronized State getState() {
        if (this.isDaemon()) {
            return State.Running;
        }
        return this.state;
    }

    public synchronized void setState(State state) {
        this.state = state;
    }

    protected boolean findEndcoding(String encoding) {
        return true;
    }

    public boolean initialize(List<String> argvs) {
        try {
            String externalIP;
            this.accessPoint = new POPAccessPoint();
            this.buffer = new BufferXDR();
            ComboxFactoryFinder finder = ComboxFactoryFinder.getInstance();
            ComboxFactory[] comboxFactories = finder.getAvailableFactories();
            this.tracking = Util.removeStringFromList(argvs, TRACKING) != null;
            this.upnp = Util.removeStringFromList(argvs, UPNP) != null;
            ArrayList<ComboxServer> liveServers = new ArrayList<ComboxServer>();
            for (ComboxFactory factory : comboxFactories) {
                String port;
                String prefix = String.format("-%s_port=", factory.getComboxName());
                while ((port = Util.removeStringFromList(argvs, prefix)) != null) {
                    int iPort = 0;
                    if (port.length() > 0) {
                        try {
                            iPort = Integer.parseInt(port);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    AccessPoint ap = new AccessPoint(factory.getComboxName(), POPSystem.getHostIP().getAddress().getHostAddress(), iPort);
                    this.accessPoint.addAccessPoint(ap);
                    liveServers.add(factory.createServerCombox(ap, this.buffer, this));
                }
            }
            if (liveServers.isEmpty()) {
                for (ComboxFactory factory : ComboxFactoryFinder.getInstance().getAvailableFactories()) {
                    AccessPoint ap = new AccessPoint(factory.getComboxName(), POPSystem.getHostIP().getAddress().getHostAddress(), 0);
                    this.accessPoint.addAccessPoint(ap);
                    liveServers.add(factory.createServerCombox(ap, this.buffer, this));
                }
            }
            if (this.upnp && (externalIP = UPNPManager.getExternalIP()) != null && !externalIP.isEmpty()) {
                for (int i = 0; i < this.accessPoint.size(); ++i) {
                    AccessPoint ap = new AccessPoint(this.accessPoint.get(i));
                    ap.setHost(externalIP);
                    UPNPManager.mapAccessPoint(ap, 1000L);
                    this.accessPoint.addAccessPoint(ap);
                }
            }
            this.comboxServers = liveServers.toArray(new ComboxServer[liveServers.size()]);
            return true;
        }
        catch (Exception e) {
            LogWriter.writeExceptionLog(e);
            return false;
        }
    }

    protected Class<?> getPOPObjectClass(String className, URLClassLoader urlClassLoader) throws ClassNotFoundException {
        if (urlClassLoader != null) {
            return Class.forName(className, true, urlClassLoader);
        }
        return Class.forName(className);
    }

    public static void main(String[] argvs) throws InterruptedException {
        POPSystem.setStarted();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LogWriter.writeDebugInfo("[Broker] POP Uncatched exception");
                LogWriter.writeExceptionLog(e);
            }
        });
        ArrayList<String> argvList = new ArrayList<String>(argvs.length);
        LogWriter.writeDebugInfo("[Broker] Broker parameters");
        for (String str : argvs) {
            argvList.add(str);
            LogWriter.writeDebugInfo(" %79s", str);
        }
        LogWriter.writeDebugInfo("[Broker] Broker parameters end");
        String appservice = Util.removeStringFromList(argvList, APPSERVICE_PREFIX);
        String codelocation = Util.removeStringFromList(argvList, CODELOCATION_PREFIX);
        String objectName = Util.removeStringFromList(argvList, OBJECT_NAME_PREFIX);
        String actualObjectName = Util.removeStringFromList(argvList, ACTUAL_OBJECT_NAME_PREFIX);
        String userConfiguration = Util.removeStringFromList(argvList, POPJAVA_CONFIG_PREFIX);
        String jobService = Util.removeStringFromList(argvList, JOB_SERVICE);
        String network = Util.removeStringFromList(argvList, NETWORK_UUID);
        Configuration conf = Configuration.getInstance();
        if (userConfiguration != null) {
            try {
                File config = new File(userConfiguration);
                conf.load(config);
            }
            catch (IOException e) {
                LogWriter.writeDebugInfo("[Broker] Couldn't load user config %s: %s", userConfiguration, e.getMessage());
            }
        }
        String objId = Util.generateUUID();
        RuntimeDirectoryThread runtimeCleanup = new RuntimeDirectoryThread(objId);
        runtimeCleanup.addCleanupHook();
        System.setProperty("user.dir", Paths.get(objId, new String[0]).toString());
        if (actualObjectName != null && actualObjectName.length() > 0) {
            objectName = actualObjectName;
        }
        String callbackString = Util.removeStringFromList(argvList, CALLBACK_PREFIX);
        if (appservice != null && appservice.length() > 0) {
            POPSystem.appServiceAccessPoint.setAccessString(appservice);
        }
        if (jobService != null && !jobService.isEmpty()) {
            POPSystem.jobService.setAccessString(jobService);
        }
        Combox callback = null;
        if (callbackString != null && callbackString.length() > 0) {
            POPAccessPoint accessPoint = new POPAccessPoint(callbackString);
            ComboxFactoryFinder finder = ComboxFactoryFinder.getInstance();
            for (int i = 0; i < accessPoint.size(); ++i) {
                String protocol = accessPoint.get(i).getProtocol();
                ComboxFactory factory = finder.findFactory(protocol);
                if (factory == null) continue;
                try {
                    callback = factory.createClientCombox(network);
                    if (callback.connectToServer(null, accessPoint, 0)) {
                        LogWriter.writeDebugInfo("[Broker] Connected to callback socket");
                        break;
                    }
                    LogWriter.writeDebugInfo("[Broker] Error: fail to connect to callback:%s", accessPoint.toString());
                    break;
                }
                catch (IOException e) {
                    LogWriter.writeExceptionLog(e);
                    LogWriter.writeDebugInfo("[Broker] Failed to connect to callback socket");
                }
            }
        }
        if (callback == null) {
            LogWriter.writeDebugInfo("[Broker] Error: callback is null");
            System.exit(1);
        }
        Broker broker = null;
        try {
            broker = new Broker(codelocation, objectName);
        }
        catch (Exception e) {
            LogWriter.writeExceptionLog(e);
        }
        int status = 0;
        if (broker == null || !broker.initialize(argvList)) {
            status = 1;
        }
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.setRequestType(0);
        messageHeader.setConnectionID(0);
        BufferXDR buffer = new BufferXDR();
        buffer.setHeader(messageHeader);
        ((POPBuffer)buffer).putInt(status);
        broker.getAccessPoint().serialize(buffer);
        callback.send(buffer);
        LogWriter.writeDebugInfo("[Broker] Broker can be accessed at " + broker.getAccessPoint().toString());
        callback.close(0);
        callback = null;
        buffer = null;
        argvList = null;
        if (status == 0) {
            broker.treatRequests();
            broker.close();
        }
        LogWriter.writeDebugInfo("[Broker] End broker life : " + objectName);
    }

    public boolean sendException(ComboxConnection<?> combox, POPException exception, int requestId) {
        exception.printStackTrace();
        POPBuffer buffer = combox.getCombox().getBufferFactory().createBuffer();
        MessageHeader messageHeader = new MessageHeader(14);
        messageHeader.setRequestID(requestId);
        buffer.setHeader(messageHeader);
        exception.serialize(buffer);
        combox.send(buffer);
        return true;
    }

    public void sendResponse(ComboxConnection<?> combox, POPBuffer buffer) {
        combox.send(buffer);
    }

    public String getLogPrefix() {
        if (this.popInfo == null) {
            return this.getClass().getName() + ".Intilizing:";
        }
        return this.getClass().getName() + "." + this.popInfo.getClass().getName() + ":";
    }

    public RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    private synchronized void registerTracking(POPRemoteCaller caller, String method, long time, int inputSize, int outputSize) {
        POPTracking userTracking = this.callerTracking.get(caller);
        if (userTracking == null) {
            userTracking = new POPTracking(caller);
            this.callerTracking.put(caller, userTracking);
        }
        userTracking.track(method, time, inputSize, outputSize);
    }

    public POPRemoteCaller[] getTrackingUsers() {
        return this.callerTracking.keySet().toArray(new POPRemoteCaller[this.callerTracking.size()]);
    }

    public POPTracking getTracked(POPRemoteCaller caller) {
        return this.callerTracking.get(caller);
    }

    public boolean isUPNPEnabled() {
        return this.upnp;
    }

    public static enum State {
        Running,
        Exit,
        Abort;

    }
}

