/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox;

import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.util.POPRemoteCaller;

public class ComboxConnection<T> {
    private Combox<T> combox;
    protected T peerConnection;
    private int connectionID;

    public ComboxConnection(Combox<T> combox, int connectionID) {
        this.combox = combox;
        this.connectionID = connectionID;
        this.peerConnection = combox.peerConnection;
    }

    public Combox<T> getCombox() {
        return this.combox;
    }

    public int send(POPBuffer buffer) {
        this.throwIfClosed();
        buffer.getHeader().setConnectionID(this.connectionID);
        return this.combox.send(buffer);
    }

    public int receive(POPBuffer buffer, int requestId) {
        this.throwIfClosed();
        return this.combox.receive(buffer, requestId, this.connectionID);
    }

    public String getNetworkUUID() {
        this.throwIfClosed();
        return this.combox.getNetworkUUID();
    }

    public POPRemoteCaller getRemoteCaller() {
        this.throwIfClosed();
        return this.combox.getRemoteCaller();
    }

    public POPAccessPoint getAccessPoint() {
        this.throwIfClosed();
        return this.combox.getAccessPoint();
    }

    public void close() {
        if (this.combox != null) {
            this.combox.close(this.connectionID);
            this.combox = null;
        }
    }

    public BufferFactory getBufferFactory() {
        this.throwIfClosed();
        return this.combox.getBufferFactory();
    }

    public void setBufferFactory(BufferFactory bufferFactory) {
        this.throwIfClosed();
        this.combox.setBufferFactory(bufferFactory);
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    private void throwIfClosed() {
        if (this.combox == null) {
            throw new RuntimeException("Combox closed");
        }
    }
}

