/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket;

import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.combox.ComboxServer;
import ch.icosys.popjava.core.combox.ComboxUtils;
import ch.icosys.popjava.core.combox.socket.ComboxAcceptSocket;
import java.io.IOException;
import java.net.ServerSocket;

public abstract class ComboxServerSocket
extends ComboxServer {
    public static final int BUFFER_LENGTH = 1024;
    private final int RECEIVE_BUFFER_SIZE = 4096000;
    protected ServerSocket serverSocket = null;
    private ComboxAcceptSocket serverCombox = null;

    public ComboxServerSocket(AccessPoint accessPoint, int timeout, Broker broker) throws IOException {
        super(accessPoint, timeout, broker);
        this.createServer();
    }

    public final void createServer() throws IOException {
        this.serverSocket = ComboxUtils.createServerSocket(this.accessPoint.getPort(), ss -> ss.setReceiveBufferSize(4096000), this.broker.isUPNPEnabled());
        this.serverCombox = this.createCombox();
        this.serverCombox.setStatus(0);
        Thread thread = new Thread((Runnable)this.serverCombox, "Server combox acception thread");
        thread.start();
        this.accessPoint.setProtocol(this.getProtocol());
        this.accessPoint.setHost(this.accessPoint.getHost());
        this.accessPoint.setPort(this.serverSocket.getLocalPort());
    }

    public String getUrl() {
        return String.format("%s://%s:%d", this.getProtocol(), this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
    }

    @Override
    public void close() {
        this.serverCombox.close();
    }

    protected abstract String getProtocol();

    protected abstract ComboxAcceptSocket createCombox() throws IOException;
}

