/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.raw;

import ch.icosys.popjava.core.combox.ComboxAllocate;
import ch.icosys.popjava.core.combox.ComboxUtils;
import ch.icosys.popjava.core.combox.socket.raw.ComboxRawSocket;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class ComboxAllocateSocket
extends ComboxAllocate<ComboxRawSocket> {
    protected ServerSocket serverSocket = null;

    public ComboxAllocateSocket(boolean enableUPNP) {
        try {
            this.serverSocket = ComboxUtils.createServerSocket(0, ss -> ss.setSoTimeout(Configuration.getInstance().getConnectionTimeout()), enableUPNP);
        }
        catch (IOException e) {
            LogWriter.writeExceptionLog(e);
        }
    }

    @Override
    public void startToAcceptOneConnection() {
        try {
            Socket peerConnection = this.serverSocket.accept();
            this.combox = new ComboxRawSocket();
            ((ComboxRawSocket)this.combox).serverAccept(null, peerConnection);
        }
        catch (IOException e) {
            LogWriter.writeExceptionLog(e);
        }
    }

    @Override
    public void close(int connectionID) {
        super.close(connectionID);
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected String getProtocol() {
        return "socket";
    }

    @Override
    protected String getIP() {
        InetAddress address = this.serverSocket.getInetAddress();
        String ip = address.getHostAddress();
        if (address.isAnyLocalAddress()) {
            ip = POPSystem.getHostIP().getAddress().getHostAddress();
        }
        return ip;
    }

    @Override
    protected int getPort() {
        return this.serverSocket.getLocalPort();
    }
}

