/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.mapgen;

import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.mapgen.PathWorker;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassReader {
    private String cleanPath;
    private String className;
    private String packageName = "";

    public ClassReader(String path) {
        this.cleanPath = PathWorker.getCleanPath(path);
        this.className = PathWorker.getFileWithoutExt(path);
    }

    public boolean isParclass() throws ClassNotFoundException, MalformedURLException {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{new URL("file://" + this.cleanPath)}, this.getClass().getClassLoader());
        Class<?> c = Class.forName(this.className, true, loader);
        if (ClassReader.isParclass(c)) {
            Package p = c.getPackage();
            if (p != null) {
                this.packageName = p.getName();
            }
            return true;
        }
        return false;
    }

    public static boolean isParclass(Class<?> c) {
        Class<?> sc = c;
        do {
            POPClass popAnnotation;
            if ((popAnnotation = sc.getAnnotation(POPClass.class)) != null) {
                return true;
            }
            if (sc != POPObject.class) continue;
            return true;
        } while ((sc = sc.getSuperclass()) != null);
        return false;
    }

    public String getClassFullName() {
        if (this.packageName.equals("")) {
            return this.className;
        }
        return this.packageName + "." + this.className;
    }

    public String getCleanPath() {
        return this.cleanPath;
    }
}

