/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts;

import ch.icosys.popjava.core.scripts.shell.CommandHandler;
import ch.icosys.popjava.core.scripts.shell.CommandInfo;
import ch.icosys.popjava.core.scripts.shell.ConsoleHandler;
import ch.icosys.popjava.core.scripts.shell.ICommand;
import ch.icosys.popjava.core.scripts.shell.command.CDebug;
import ch.icosys.popjava.core.scripts.shell.command.CJobManager;
import ch.icosys.popjava.core.scripts.shell.command.CKeystore;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Properties;

public class POPJShell {
    public static final ShellConfiguration configuration = new ShellConfiguration();
    private final ConsoleHandler consoleHandler = ConsoleHandler.getInstance();
    private final CommandHandler commandHandler = new CommandHandler();

    public POPJShell() {
        this.initCommands();
    }

    private void start() {
        System.out.println("Welcome to POP-Java simple configuration shell.");
        System.out.println("This shell is not interactive, you must type every command.");
        System.out.println("Use `help` to know the available commands.");
        System.out.println("Every command has a --help (-h) flag which print its options.");
        while (true) {
            try {
                while (true) {
                    System.out.print("$ ");
                    CommandInfo ci = this.consoleHandler.readCommand();
                    if (ci == null) continue;
                    this.commandHandler.execute(ci);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void initCommands() {
        this.commandHandler.add(new CKeystore());
        this.commandHandler.add(new CJobManager());
        this.commandHandler.add(new Help());
        this.commandHandler.add(new CDebug());
    }

    public static void optionNotFound(String keyword, String help) {
        System.out.format("%s: command not found\n", keyword);
        System.out.println(help);
    }

    public static void main(String[] args) {
        POPJShell shell = new POPJShell();
        shell.start();
    }

    public static class ShellConfiguration {
        private static final Path LOCATION = Paths.get("pshell.properties", new String[0]).toAbsolutePath();
        private final Properties PROPS = new Properties();

        public ShellConfiguration() {
            try (FileInputStream in = new FileInputStream(LOCATION.toFile());){
                this.PROPS.load(in);
            }
            catch (IOException e) {
                try {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_READ);
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    Files.createFile(LOCATION, new FileAttribute[0]);
                    Files.setPosixFilePermissions(LOCATION, perms);
                }
                catch (IOException ex) {
                    System.err.println("Couldn't save shell configuration, it may not work in the future.");
                }
            }
        }

        public String getPrivateNetwork() {
            return this.PROPS.getProperty(S.PRIVATE_NETWORK.name());
        }

        public void setPrivateNetwork(String networkUUID) {
            this.saveValue(S.PRIVATE_NETWORK, networkUUID);
        }

        private void saveValue(S key, String val) {
            this.PROPS.setProperty(key.name(), val);
            try (FileOutputStream out = new FileOutputStream(LOCATION.toFile());){
                this.PROPS.store(out, "Generated by POP Shell");
            }
            catch (IOException e) {
                System.err.println("Couldn't save POP Shell configuration.");
            }
        }

        private static enum S {
            PRIVATE_NETWORK;

        }
    }

    private class Help
    implements ICommand {
        @Override
        public String keyword() {
            return "help";
        }

        @Override
        public int execute(CommandInfo info) {
            System.out.println(POPJShell.this.commandHandler.help());
            return 0;
        }

        @Override
        public String help() {
            return "";
        }

        @Override
        public String description() {
            return "print this help";
        }
    }
}

