/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class POPNode {
    protected String host;
    protected String[] creationParams;
    protected final POPNetworkDescriptor descriptor;
    protected boolean temporary = false;

    public POPNode(POPNetworkDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public POPNetworkDescriptor getConnectorDescriptor() {
        return this.descriptor;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public abstract String toString();

    public String[] getCreationParams() {
        return Arrays.copyOf(this.creationParams, this.creationParams.length);
    }

    public Map<String, Object> toYamlResource() {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        for (String param : this.creationParams) {
            String key = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1);
            mapParams.put(key, value);
        }
        return mapParams;
    }
}

