/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.search;

import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.service.jobmanager.Resource;
import ch.icosys.popjava.core.service.jobmanager.search.SNExploration;
import ch.icosys.popjava.core.service.jobmanager.search.SNWayback;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class SNRequest
implements IPOPBase {
    private String requestId;
    private String os;
    private Resource minResource;
    private Resource reqResource;
    private SNExploration explorationNodes;
    private SNWayback wayback;
    private String networkUUID;
    private String connector;
    private boolean endRequest = false;
    private int hops = Integer.MAX_VALUE;
    private int popAppId;
    private String[] hosts = new String[0];
    private byte[] publicCertificate = new byte[0];
    private byte[] appServiceCertificate = new byte[0];
    private final Map<String, String> customParams = new HashMap<String, String>();

    public SNRequest() {
    }

    public SNRequest(String nodeId, Resource reqResource, Resource minResource, String networkUUID, String connector, String appServiceFingerprint) {
        this.requestId = nodeId;
        this.os = POPSystem.getPlatform();
        this.minResource = minResource;
        this.reqResource = reqResource;
        this.explorationNodes = new SNExploration();
        this.wayback = new SNWayback();
        this.networkUUID = networkUUID;
        this.connector = connector;
        Certificate localPublicCertificate = SSLUtils.getCertificateFromAlias(networkUUID);
        if (localPublicCertificate != null) {
            this.publicCertificate = SSLUtils.certificateBytes(localPublicCertificate);
        }
        if (appServiceFingerprint != null) {
            Certificate appServiceCert = SSLUtils.getCertificate(appServiceFingerprint);
            this.appServiceCertificate = SSLUtils.certificateBytes(appServiceCert);
        }
    }

    public boolean isEndRequest() {
        return this.endRequest;
    }

    public void setAsEndRequest() {
        this.endRequest = true;
    }

    public String getUID() {
        return this.requestId;
    }

    public SNExploration getExplorationList() {
        return this.explorationNodes;
    }

    public String getNetworkUUID() {
        return this.networkUUID;
    }

    public void setHosts(String[] hosts) {
        this.hosts = hosts;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public void setHopLimit(int hops) {
        this.hops = hops;
    }

    public void decreaseHopLimit() {
        --this.hops;
    }

    public int getRemainingHops() {
        return this.hops;
    }

    public void setPOPAppId(int popAppId) {
        this.popAppId = popAppId;
    }

    public int getPOPAppId() {
        return this.popAppId;
    }

    public Resource getResourceNeeded() {
        return this.reqResource;
    }

    public Resource getMinResourceNeeded() {
        return this.minResource;
    }

    public SNWayback getWayback() {
        return this.wayback;
    }

    public void setOS(String platform) {
        this.os = platform;
    }

    public byte[] getPublicCertificate() {
        return this.publicCertificate;
    }

    public byte[] getAppServiceCertificate() {
        return this.appServiceCertificate;
    }

    public String getConnector() {
        return this.connector;
    }

    public void setValue(String key, String value) {
        this.customParams.put(key, value);
    }

    public String getValue(String key) {
        return this.customParams.get(key);
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putString(this.requestId);
        buffer.putString(this.os);
        buffer.putValue(this.minResource, Resource.class);
        buffer.putValue(this.reqResource, Resource.class);
        buffer.putValue(this.explorationNodes, SNExploration.class);
        buffer.putValue(this.wayback, SNWayback.class);
        buffer.putString(this.networkUUID);
        buffer.putBoolean(this.endRequest);
        buffer.putInt(this.hops);
        buffer.putInt(this.popAppId);
        buffer.putByteArray(this.publicCertificate);
        buffer.putString(this.connector);
        buffer.putInt(this.hosts.length);
        for (String hostFilter : this.hosts) {
            buffer.putString(hostFilter);
        }
        buffer.putInt(this.customParams.size());
        for (Map.Entry entry : this.customParams.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            buffer.putString(key);
            buffer.putString(value);
        }
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.requestId = buffer.getString();
        this.os = buffer.getString();
        this.minResource = (Resource)buffer.getValue(Resource.class);
        this.reqResource = (Resource)buffer.getValue(Resource.class);
        this.explorationNodes = (SNExploration)buffer.getValue(SNExploration.class);
        this.wayback = (SNWayback)buffer.getValue(SNWayback.class);
        this.networkUUID = buffer.getString();
        this.endRequest = buffer.getBoolean();
        this.hops = buffer.getInt();
        this.popAppId = buffer.getInt();
        int buffSize = buffer.getInt();
        this.publicCertificate = buffer.getByteArray(buffSize);
        this.connector = buffer.getString();
        int hostsSize = buffer.getInt();
        this.hosts = new String[hostsSize];
        for (int i = 0; i < hostsSize; ++i) {
            this.hosts[i] = buffer.getString();
        }
        int mapSize = buffer.getInt();
        for (int i = 0; i < mapSize; ++i) {
            this.customParams.put(buffer.getString(), buffer.getString());
        }
        return true;
    }
}

