/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.annotation.POPParameter;
import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.base.MethodInfo;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.interfacebase.Interface;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.ClassUtil;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.MethodUtil;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;

public class PJMethodHandler
extends Interface
implements MethodHandler {
    protected final int constructorSemanticId = 21;
    protected POPObject popObjectInfo = null;
    private final AtomicBoolean setup = new AtomicBoolean(false);
    private final Map<Method, Annotation[][]> methodAnnotationCache = new HashMap<Method, Annotation[][]>();
    private final Configuration conf = Configuration.getInstance();
    private final ConcurrentHashMap<Integer, Method> methodCache = new ConcurrentHashMap();
    private final Set<Integer> methodMisses = new HashSet<Integer>();

    public PJMethodHandler(Broker parentBroker, POPObject popObject) {
        super(parentBroker);
        this.popObjectInfo = popObject;
    }

    public void setSetup() {
        this.setup.set(true);
    }

    public void popConstructor(Class<?> targetClass, final Object ... argvs) throws POPException, NoSuchMethodException {
        this.replacePOPObjectArguments(argvs);
        final Constructor<?> constructor = ClassUtil.getConstructor(targetClass, ClassUtil.getObjectTypes(argvs));
        final Class[] parameterTypes = constructor.getParameterTypes();
        final Exception temp = new Exception(targetClass.getName());
        Runnable constructorRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PJMethodHandler.this.allocate(PJMethodHandler.this.popObjectInfo.getClassName());
                    MethodInfo methodInfo = PJMethodHandler.this.popObjectInfo.getMethodInfo(constructor);
                    MessageHeader messageHeader = new MessageHeader(methodInfo.getClassId(), methodInfo.getMethodId(), 21);
                    messageHeader.setRequestID(PJMethodHandler.this.getRequestID());
                    if (PJMethodHandler.this.combox == null) {
                        throw new POPException(10017, "Can't call object, combox not connected");
                    }
                    BufferFactory factory = PJMethodHandler.this.combox.getCombox().getBufferFactory();
                    POPBuffer popBuffer = factory.createBuffer();
                    popBuffer.setHeader(messageHeader);
                    Annotation[][] annotations = constructor.getParameterAnnotations();
                    for (int index = 0; index < argvs.length; ++index) {
                        if (!Util.isParameterNotOfDirection(annotations[index], POPParameter.Direction.OUT) || !Util.isParameterUsable(annotations[index])) continue;
                        popBuffer.putValue(argvs[index], parameterTypes[index]);
                    }
                    PJMethodHandler.this.popDispatch(popBuffer);
                    POPBuffer responseBuffer = PJMethodHandler.this.combox.getCombox().getBufferFactory().createBuffer();
                    PJMethodHandler.this.popResponse(responseBuffer, messageHeader.getRequestID());
                    for (int index = 0; index < parameterTypes.length; ++index) {
                        POPObject object;
                        if (Util.isParameterNotOfDirection(annotations[index], POPParameter.Direction.IN) && Util.isParameterUsable(annotations[index]) && (!(argvs[index] instanceof POPObject) || Util.isParameterOfAnyDirection(annotations[index]))) {
                            responseBuffer.deserializeReferenceObject(parameterTypes[index], argvs[index]);
                        }
                        if (!(argvs[index] instanceof POPObject) || !(object = (POPObject)argvs[index]).isTemporary()) continue;
                        object.exit();
                    }
                }
                catch (Exception e) {
                    temp.printStackTrace();
                    e.printStackTrace();
                }
                PJMethodHandler.this.setSetup();
            }
        };
        POPClass annotation = targetClass.getAnnotation(POPClass.class);
        if (this.conf.isAsyncConstructor() && (annotation == null || annotation.useAsyncConstructor())) {
            POPSystem.startAsyncConstructor(constructorRunnable);
        } else {
            constructorRunnable.run();
        }
    }

    public boolean bindObject(POPAccessPoint accesspoint) throws POPException {
        this.popAccessPoint.setAccessString(accesspoint.toString());
        this.setup.set(true);
        return this.bind(accesspoint);
    }

    public Object invoke(Object self, Method m, Method proceed, Object[] argvs) throws Throwable {
        while (!this.setup.get()) {
            Thread.sleep(50L);
        }
        this.replacePOPObjectArguments(argvs);
        Object result = null;
        boolean[] canExecute = new boolean[1];
        result = this.invokeCustomMethod(self, m, proceed, canExecute, argvs);
        if (canExecute[0]) {
            return result;
        }
        Class<?> proceedClass = m.getDeclaringClass();
        if (!POPObject.class.isAssignableFrom(proceedClass)) {
            return null;
        }
        Class<?> returnType = m.getReturnType();
        result = new Object();
        MethodInfo info = this.popObjectInfo.getMethodInfo(m);
        if (info == null || info.getClassId() == 0 && info.getMethodId() == 0) {
            throw new POPException(10021, "The methods " + m.getName() + " has no POP annotation");
        }
        m.setAccessible(true);
        int methodSemantics = this.popObjectInfo.getSemantic(info);
        MessageHeader messageHeader = new MessageHeader(info.getClassId(), info.getMethodId(), methodSemantics);
        messageHeader.setRequestID(this.getRequestID());
        if (this.combox == null) {
            throw new POPException(10017, "Can't invoke method, object not connected");
        }
        POPBuffer popBuffer = this.combox.getBufferFactory().createBuffer();
        popBuffer.setHeader(messageHeader);
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (!this.methodAnnotationCache.containsKey(m)) {
            this.methodAnnotationCache.put(m, m.getParameterAnnotations());
        }
        Annotation[][] annotations = this.methodAnnotationCache.get(m);
        for (int index = 0; index < argvs.length; ++index) {
            if (!Util.isParameterNotOfDirection(annotations[index], POPParameter.Direction.OUT) || !Util.isParameterUsable(annotations[index])) continue;
            popBuffer.putValue(argvs[index], parameterTypes[index]);
        }
        this.popDispatch(popBuffer);
        if ((methodSemantics & 1) != 0) {
            POPBuffer responseBuffer = this.combox.getCombox().getBufferFactory().createBuffer();
            this.popResponse(responseBuffer, messageHeader.getRequestID());
            for (int index = 0; index < parameterTypes.length; ++index) {
                if (!Util.isParameterNotOfDirection(annotations[index], POPParameter.Direction.IN) || !Util.isParameterUsable(annotations[index]) || argvs[index] instanceof POPObject && !Util.isParameterOfAnyDirection(annotations[index])) continue;
                responseBuffer.deserializeReferenceObject(parameterTypes[index], argvs[index]);
            }
            if (returnType != Void.class && returnType != Void.TYPE) {
                result = responseBuffer.getValue(returnType);
            }
        } else if (returnType != Void.class && returnType != Void.TYPE) {
            try {
                result = returnType.isPrimitive() ? ClassUtil.getDefaultPrimitiveValue(returnType) : null;
            }
            catch (Exception e) {
                result = null;
            }
        }
        for (Object argv : argvs) {
            if (!(argv instanceof POPObject)) continue;
            POPObject object = (POPObject)argv;
            LogWriter.writeDebugInfo("Closing POPObject again " + object.getClassName());
            if (!object.isTemporary()) continue;
            object.exit();
        }
        return result;
    }

    private void replacePOPObjectArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            POPAccessPoint objAp;
            String originFingerprint;
            if (!(args[i] instanceof POPObject)) continue;
            POPObject object = (POPObject)args[i];
            if (!(args[i] instanceof ProxyObject)) {
                object = (POPObject)PopJava.newActive((Object)this.parentBroker, object.getClass(), object.getAccessPoint());
                object.makeTemporary();
                args[i] = object;
            }
            if ((originFingerprint = (objAp = object.getAccessPoint()).getFingerprint()) == null) continue;
            Certificate originCert = SSLUtils.getCertificate(originFingerprint);
            objAp.setX509certificate(SSLUtils.certificateBytes(originCert));
            String destinationFingerprint = this.popAccessPoint.getFingerprint();
            Certificate destCert = SSLUtils.getCertificate(destinationFingerprint);
            if (destCert == null) continue;
            object.PopRegisterFutureConnectorCertificate(SSLUtils.certificateBytes(destCert));
        }
    }

    private Method getSameInterfaceMethod(Method method) {
        int methodHash = MethodUtil.methodId(method);
        if (this.methodMisses.contains(methodHash)) {
            return null;
        }
        Method m = this.methodCache.get(methodHash);
        if (m != null) {
            return m;
        }
        try {
            m = this.getClass().getMethod(method.getName(), method.getParameterTypes());
            this.methodCache.put(methodHash, m);
            return m;
        }
        catch (Exception e) {
            this.methodMisses.add(methodHash);
            return null;
        }
    }

    private Object invokeCustomMethod(Object self, Method m, Method proceed, boolean[] canExcute, Object[] argvs) {
        canExcute[0] = false;
        String methodName = m.getName();
        if (argvs.length == 1 && (methodName.equals("serialize") || methodName.equals("deserialize"))) {
            boolean result = false;
            POPBuffer buffer = (POPBuffer)argvs[0];
            if (methodName.equals("serialize")) {
                if (self instanceof POPObject) {
                    POPObject o = (POPObject)self;
                    this.od.merge(o.getOd());
                }
                canExcute[0] = true;
                result = this.serialize(buffer);
            } else if (methodName.equals("deserialize")) {
                canExcute[0] = true;
                result = this.deserialize(buffer);
            }
            return result;
        }
        if (argvs.length == 2 && methodName.equals("deserialize")) {
            boolean result = false;
            POPBuffer buffer = (POPBuffer)argvs[1];
            Combox sourceCombox = (Combox)argvs[0];
            canExcute[0] = true;
            result = this.deserialize(sourceCombox, buffer);
            return result;
        }
        if (methodName.equals("exit") && argvs.length == 0) {
            LogWriter.writeDebugInfo("Close method handler through exit: " + this.popObjectInfo.getClassName());
            canExcute[0] = true;
            this.invokeExit();
        } else {
            Method interfaceMethod = this.getSameInterfaceMethod(m);
            if (interfaceMethod != null) {
                try {
                    Object result = interfaceMethod.invoke((Object)this, argvs);
                    canExcute[0] = true;
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new Object();
    }

    private void invokeExit() {
        this.close();
        this.decRef();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.popAccessPoint.toString();
    }
}

