/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.base;

public class MessageHeader {
    public static final int REQUEST = 0;
    public static final int RESPONSE = 1;
    public static final int EXCEPTION = 2;
    public static final int BIND_STATUS_CALL = 0;
    public static final int ADD_REF_CALL = 1;
    public static final int DEC_REF_CALL = 2;
    public static final int GET_ENCODING_CALL = 3;
    public static final int KILL_ALL = 4;
    public static final int OBJECT_ALIVE_CALL = 5;
    public static final int HEADER_LENGTH = 28;
    private int connectionID;
    private int requestType;
    private int classId;
    private int methodId;
    private int semantics;
    private int exceptionCode;
    private int requestID = -1;

    public MessageHeader(int classId, int methodId, int semantics) {
        this.classId = classId;
        this.methodId = methodId;
        this.semantics = semantics;
        this.requestType = 0;
        this.exceptionCode = 0;
    }

    public MessageHeader() {
        this.requestType = 1;
        this.exceptionCode = 0;
        this.classId = 0;
        this.methodId = 0;
        this.semantics = 1;
    }

    public MessageHeader(int exceptionCode) {
        this.requestType = 2;
        this.exceptionCode = exceptionCode;
        this.classId = 0;
        this.methodId = 0;
        this.semantics = 1;
    }

    public void setConnectionID(int connectionID) {
        this.connectionID = connectionID;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public int getClassId() {
        return this.classId;
    }

    public void setClassId(int classId) {
        this.classId = classId;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public void setMethodId(int methodId) {
        this.methodId = methodId;
    }

    public int getSemantics() {
        return this.semantics;
    }

    public void setSenmatics(int senmatics) {
        this.semantics = senmatics;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public String toString() {
        return String.format("MessageHeaderInfo: RequestType=%s,ClassId=%d,MethodId=%d,Sematics=%d,ErrorCode=%d", MessageHeader.getRequestTypeName(this.getRequestType()), this.getClassId(), this.getMethodId(), this.getSemantics(), this.getExceptionCode());
    }

    private static String getRequestTypeName(int type) {
        switch (type) {
            case 0: {
                return "Request";
            }
            case 1: {
                return "Response";
            }
            case 2: {
                return "Exception";
            }
        }
        return "UNKOWN " + type;
    }
}

